/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum ProviderFormat {
    PGB,
    RDBMS,
    CSV,
    ES;


    public boolean isFileFormat() {
        switch (this) {
            case PGB: 
            case CSV: {
                return true;
            }
        }
        return false;
    }

    public boolean isTextFormat() {
        switch (this) {
            case CSV: {
                return true;
            }
        }
        return false;
    }

    public boolean supportsVectorProperties() {
        switch (this) {
            case PGB: 
            case CSV: {
                return true;
            }
        }
        return false;
    }

    public boolean supportsPropertyColumn() {
        switch (this) {
            case PGB: 
            case CSV: 
            case RDBMS: {
                return true;
            }
        }
        return false;
    }

    public boolean supportsPropertyConversion() {
        switch (this) {
            case RDBMS: {
                return true;
            }
        }
        return false;
    }

    @JsonValue
    public String toKey() {
        return this.name().toLowerCase();
    }

    public String toString() {
        return this.toKey();
    }

    @JsonCreator
    public static ProviderFormat parseFormat(String input) {
        return ProviderFormat.valueOf(input.toUpperCase());
    }
}

