/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import oracle.pgx.config.AbstractGraphConfigFactory;
import oracle.pgx.config.AbstractPgGraphConfigBuilder;
import oracle.pgx.config.DbEngine;
import oracle.pgx.config.PgRdbmsGraphConfig;
import oracle.pgx.config.PgRdbmsGraphConfigFactory;

public final class PgRdbmsGraphConfigBuilder
extends AbstractPgGraphConfigBuilder<PgRdbmsGraphConfigBuilder, PgRdbmsGraphConfig> {
    public PgRdbmsGraphConfigBuilder() {
        this.setDbEngine(DbEngine.RDBMS);
    }

    @Override
    protected AbstractGraphConfigFactory<PgRdbmsGraphConfig> getFactory() {
        return new PgRdbmsGraphConfigFactory(true, true);
    }

    @Override
    public PgRdbmsGraphConfigBuilder copyFrom(PgRdbmsGraphConfig graphConfig) {
        super.copyFrom(graphConfig);
        this.setJdbcUrl(graphConfig.getJdbcUrl());
        this.setUsername(graphConfig.getUsername());
        this.setDataSourceId(graphConfig.getDataSourceId());
        this.setOwner(graphConfig.getOwner());
        this.setPassword((String)graphConfig.getValues().get(PgRdbmsGraphConfig.Field.PASSWORD));
        this.setSecurityPolicy(graphConfig.getSecurityPolicy());
        this.setLabel(graphConfig.getLabel());
        this.setRowLabel(graphConfig.getRowLabel());
        this.setOptions(graphConfig.getOptions());
        this.setVertexViewName(graphConfig.getVerticesViewName());
        this.setEdgeViewName(graphConfig.getEdgesViewName());
        this.setViewParallelHintDegree(graphConfig.getViewParallelHintDegree());
        return (PgRdbmsGraphConfigBuilder)this.getThis();
    }

    public PgRdbmsGraphConfigBuilder setJdbcUrl(String url) {
        this.values.put(PgRdbmsGraphConfig.Field.JDBC_URL.toKey(), url);
        return this;
    }

    public PgRdbmsGraphConfigBuilder setUsername(String username) {
        this.values.put(PgRdbmsGraphConfig.Field.USERNAME.toKey(), username);
        return this;
    }

    public PgRdbmsGraphConfigBuilder setDataSourceId(String dataSource) {
        this.values.put(PgRdbmsGraphConfig.Field.DATA_SOURCE_ID.toKey(), dataSource);
        return this;
    }

    public PgRdbmsGraphConfigBuilder setOwner(String owner) {
        this.values.put(PgRdbmsGraphConfig.Field.OWNER.toKey(), owner);
        return this;
    }

    public PgRdbmsGraphConfigBuilder setSecurityPolicy(String policy) {
        this.values.put(PgRdbmsGraphConfig.Field.SECURITY_POLICY.toKey(), policy);
        return this;
    }

    public PgRdbmsGraphConfigBuilder setLabel(String label) {
        this.values.put(PgRdbmsGraphConfig.Field.LABEL.toKey(), label);
        return this;
    }

    public PgRdbmsGraphConfigBuilder setRowLabel(String rowLabel) {
        this.values.put(PgRdbmsGraphConfig.Field.ROW_LABEL.toKey(), rowLabel);
        return this;
    }

    public PgRdbmsGraphConfigBuilder setOptions(String options) {
        this.values.put(PgRdbmsGraphConfig.Field.OPTIONS.toKey(), options);
        return this;
    }

    public PgRdbmsGraphConfigBuilder setVertexViewName(String viewName) {
        this.values.put(PgRdbmsGraphConfig.Field.VERTICES_VIEW_NAME.toKey(), viewName);
        return this;
    }

    public PgRdbmsGraphConfigBuilder setEdgeViewName(String viewName) {
        this.values.put(PgRdbmsGraphConfig.Field.EDGES_VIEW_NAME.toKey(), viewName);
        return this;
    }

    public PgRdbmsGraphConfigBuilder setViewParallelHintDegree(Integer dop) {
        this.values.put(PgRdbmsGraphConfig.Field.VIEW_PARALLEL_HINT_DEGREE.toKey(), dop);
        return this;
    }
}

