/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import com.fasterxml.jackson.annotation.JsonValue;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import oracle.pgx.common.types.IdStrategy;
import oracle.pgx.common.types.IdType;
import oracle.pgx.common.util.ConfigJsonUtil;
import oracle.pgx.config.AbstractConfig;
import oracle.pgx.config.AbstractPartitionedGraphConfig;
import oracle.pgx.config.ConfigField;
import oracle.pgx.config.ConfigParser;
import oracle.pgx.config.EntityProviderConfig;
import oracle.pgx.config.ExternalStoreConfig;
import oracle.pgx.config.GraphErrorHandlingConfig;
import oracle.pgx.config.GraphLoadingConfig;
import oracle.pgx.config.GraphOptimizedFor;
import oracle.pgx.config.ParseResult;
import oracle.pgx.config.PgxRedactionRuleConfig;
import oracle.pgx.config.PgxRedactionRuleMappingConfig;
import oracle.pgx.config.PreparedQueryConfig;
import oracle.pgx.config.PropertiesConfigParser;

public class PartitionedGraphConfig
extends AbstractPartitionedGraphConfig {
    private final Map<Field, Object> values;
    private final Set<Field> defaults;
    private final Map<String, Object> leftoverValues;

    public static PartitionedGraphConfig parse(InputStream is, boolean strict, String parentPath) throws IOException {
        return PartitionedGraphConfig.parse(ConfigParser.parseRaw(is), strict, parentPath);
    }

    static PartitionedGraphConfig parse(InputStream is, boolean strict, String parentPath, boolean parseHiddenValues) throws IOException {
        return PartitionedGraphConfig.parse(ConfigParser.parseRaw(is), strict, parentPath, parseHiddenValues);
    }

    public static PartitionedGraphConfig parse(Map<String, Object> raw, boolean strict, String parentPath) {
        ParseResult pr = ConfigParser.parse(raw, (ConfigField[])Field.values(), (boolean)strict, (String)parentPath);
        return new PartitionedGraphConfig(pr.getValues(), raw, pr.getDefaults());
    }

    static PartitionedGraphConfig parse(Map<String, Object> raw, boolean strict, String parentPath, boolean parseHiddenValues) {
        ParseResult pr = ConfigParser.parse(raw, (ConfigField[])Field.values(), (boolean)strict, (String)parentPath, (boolean)parseHiddenValues);
        return new PartitionedGraphConfig(pr.getValues(), raw, pr.getDefaults());
    }

    public static PartitionedGraphConfig parse(Properties props, boolean strict) {
        ParseResult pr = PropertiesConfigParser.parse((Properties)props, (ConfigField[])Field.values(), (boolean)strict);
        return new PartitionedGraphConfig(pr.getValues(), null, pr.getDefaults());
    }

    public static Field[] getConfigFields() {
        return Field.values();
    }

    protected PartitionedGraphConfig(Map<Field, Object> values, Map<String, Object> leftoverValues, Set<Field> defaults) {
        this.values = values;
        this.leftoverValues = leftoverValues == null ? Collections.emptyMap() : leftoverValues;
        this.defaults = defaults;
        this.initialize();
    }

    public Map<Field, Object> getValues() {
        return this.values;
    }

    public boolean isEmpty() {
        return this.getValuesWithoutDefaults().isEmpty();
    }

    public boolean hasDefaultValue(Field field) {
        return this.defaults.contains(field);
    }

    @JsonValue
    public Map<Field, Object> getValuesWithoutDefaults() {
        HashMap<Field, Object> valuesWithoutDefaults = new HashMap<Field, Object>(this.values);
        for (Field field : this.defaults) {
            valuesWithoutDefaults.remove(field);
        }
        return valuesWithoutDefaults;
    }

    public Map<String, Object> getLeftoverValues() {
        return this.leftoverValues;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean hideSensitiveData) {
        if (!this.canSerialize()) {
            throw new UnsupportedOperationException("some objects part of this config cannot be serialized");
        }
        try {
            Object configValues = hideSensitiveData ? this.hiddenSensitiveData() : this;
            return ConfigJsonUtil.toJson(configValues);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private final Map<Field, Object> hiddenSensitiveData() {
        HashMap<Field, Object> hiddenValues = new HashMap<Field, Object>(this.getValuesWithoutDefaults());
        for (Field f : this.values.keySet()) {
            if (!f.isSensitive()) continue;
            hiddenValues.put(f, "*******");
        }
        return hiddenValues;
    }

    @Override
    public String getName() {
        return (String)this.values.get(Field.NAME);
    }

    public String getPgViewName() {
        return (String)this.values.get(Field.PG_VIEW_NAME);
    }

    public List<String> getQueries() {
        return (List)this.values.get(Field.QUERIES);
    }

    public List<PreparedQueryConfig> getPreparedQueries() {
        return (List)this.values.get(Field.PREPARED_QUERIES);
    }

    @Override
    public GraphOptimizedFor getOptimizedFor() {
        return (GraphOptimizedFor)((Object)this.values.get(Field.OPTIMIZED_FOR));
    }

    @Override
    public IdStrategy getVertexIdStrategy() {
        return (IdStrategy)this.values.get(Field.VERTEX_ID_STRATEGY);
    }

    @Override
    public IdStrategy getEdgeIdStrategy() {
        return (IdStrategy)this.values.get(Field.EDGE_ID_STRATEGY);
    }

    @Override
    public IdType getVertexIdType() {
        return (IdType)this.values.get(Field.VERTEX_ID_TYPE);
    }

    @Override
    public IdType getEdgeIdType() {
        return (IdType)this.values.get(Field.EDGE_ID_TYPE);
    }

    @Override
    public Double getArrayCompactionThreshold() {
        return (Double)this.values.get(Field.ARRAY_COMPACTION_THRESHOLD);
    }

    @Override
    public List<EntityProviderConfig> getVertexProviders() {
        return (List)this.values.get(Field.VERTEX_PROVIDERS);
    }

    @Override
    public List<EntityProviderConfig> getEdgeProviders() {
        return (List)this.values.get(Field.EDGE_PROVIDERS);
    }

    @Override
    public GraphLoadingConfig getLoading() {
        return (GraphLoadingConfig)this.values.get(Field.LOADING);
    }

    @Override
    public List<PgxRedactionRuleConfig> getRedactionRules() {
        return (List)this.values.get(Field.REDACTION_RULES);
    }

    @Override
    public List<PgxRedactionRuleMappingConfig> getRulesMapping() {
        return (List)this.values.get(Field.RULES_MAPPING);
    }

    @Override
    public List<ExternalStoreConfig> getExternalStores() {
        return (List)this.values.get(Field.EXTERNAL_STORES);
    }

    @Override
    public Integer getMaxBatchSize() {
        return (Integer)this.values.get(Field.MAX_BATCH_SIZE);
    }

    @Override
    public String getEsUrl() {
        return (String)this.values.get(Field.ES_URL);
    }

    @Override
    public String getEsIndexName() {
        return (String)this.values.get(Field.ES_INDEX_NAME);
    }

    @Override
    public String getProxyUrl() {
        return (String)this.values.get(Field.PROXY_URL);
    }

    @Override
    public String getScrollTime() {
        return (String)this.values.get(Field.SCROLL_TIME);
    }

    @Override
    public String getUsername() {
        return (String)this.values.get(Field.USERNAME);
    }

    @Override
    public Integer getNumConnections() {
        return (Integer)this.values.get(Field.NUM_CONNECTIONS);
    }

    @Override
    public String getSchema() {
        return (String)this.values.get(Field.SCHEMA);
    }

    @Override
    public String getJdbcUrl() {
        return (String)this.values.get(Field.JDBC_URL);
    }

    @Override
    public String getDataSourceId() {
        return (String)this.values.get(Field.DATA_SOURCE_ID);
    }

    @Override
    public Integer getMaxPrefetchedRows() {
        return (Integer)this.values.get(Field.MAX_PREFETCHED_ROWS);
    }

    @Override
    public GraphErrorHandlingConfig getErrorHandling() {
        return (GraphErrorHandlingConfig)this.values.get(Field.ERROR_HANDLING);
    }

    @Override
    public List<String> getLocalDateFormat() {
        return (List)this.values.get(Field.LOCAL_DATE_FORMAT);
    }

    @Override
    public List<String> getTimeFormat() {
        return (List)this.values.get(Field.TIME_FORMAT);
    }

    @Override
    public List<String> getTimestampFormat() {
        return (List)this.values.get(Field.TIMESTAMP_FORMAT);
    }

    @Override
    public List<String> getTimeWithTimezoneFormat() {
        return (List)this.values.get(Field.TIME_WITH_TIMEZONE_FORMAT);
    }

    @Override
    public List<String> getTimestampWithTimezoneFormat() {
        return (List)this.values.get(Field.TIMESTAMP_WITH_TIMEZONE_FORMAT);
    }

    @Override
    public Character getVectorComponentDelimiter() {
        return (Character)this.values.get(Field.VECTOR_COMPONENT_DELIMITER);
    }

    public String getPoint2d() {
        return (String)this.values.get(Field.POINT2D);
    }

    @Override
    public Map getAttributes() {
        return (Map)this.values.get(Field.ATTRIBUTES);
    }

    @Override
    public String getKeystoreAlias() {
        return (String)this.values.get(Field.KEYSTORE_ALIAS);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PartitionedGraphConfig other = (PartitionedGraphConfig)obj;
        if (!Objects.equals(this.getName(), other.getName())) {
            return false;
        }
        if (!Objects.equals(this.getPgViewName(), other.getPgViewName())) {
            return false;
        }
        if (!Objects.equals(this.getQueries(), other.getQueries())) {
            return false;
        }
        if (!Objects.equals(this.getPreparedQueries(), other.getPreparedQueries())) {
            return false;
        }
        if (!Objects.equals((Object)this.getOptimizedFor(), (Object)other.getOptimizedFor())) {
            return false;
        }
        if (!Objects.equals(this.getValidatedVertexIdStrategy(), other.getValidatedVertexIdStrategy())) {
            return false;
        }
        if (!Objects.equals(this.getValidatedEdgeIdStrategy(), other.getValidatedEdgeIdStrategy())) {
            return false;
        }
        if (!Objects.equals(this.getValidatedVertexIdType(), other.getValidatedVertexIdType())) {
            return false;
        }
        if (!Objects.equals(this.getValidatedEdgeIdType(), other.getValidatedEdgeIdType())) {
            return false;
        }
        if (!Objects.equals(this.getArrayCompactionThreshold(), other.getArrayCompactionThreshold())) {
            return false;
        }
        if (!Objects.equals(new HashSet<EntityProviderConfig>(this.getVertexProviders()), new HashSet<EntityProviderConfig>(other.getVertexProviders()))) {
            return false;
        }
        if (!Objects.equals(new HashSet<EntityProviderConfig>(this.getEdgeProviders()), new HashSet<EntityProviderConfig>(other.getEdgeProviders()))) {
            return false;
        }
        if (!Objects.equals(this.getLoading(), other.getLoading())) {
            return false;
        }
        if (!Objects.equals(this.getRedactionRules(), other.getRedactionRules())) {
            return false;
        }
        if (!Objects.equals(this.getRulesMapping(), other.getRulesMapping())) {
            return false;
        }
        if (!Objects.equals(this.getExternalStores(), other.getExternalStores())) {
            return false;
        }
        if (!Objects.equals(this.getMaxBatchSize(), other.getMaxBatchSize())) {
            return false;
        }
        if (!Objects.equals(this.getEsUrl(), other.getEsUrl())) {
            return false;
        }
        if (!Objects.equals(this.getEsIndexName(), other.getEsIndexName())) {
            return false;
        }
        if (!Objects.equals(this.getProxyUrl(), other.getProxyUrl())) {
            return false;
        }
        if (!Objects.equals(this.getScrollTime(), other.getScrollTime())) {
            return false;
        }
        if (!Objects.equals(this.getUsername(), other.getUsername())) {
            return false;
        }
        if (!Objects.equals(this.getNumConnections(), other.getNumConnections())) {
            return false;
        }
        if (!Objects.equals(this.getSchema(), other.getSchema())) {
            return false;
        }
        if (!Objects.equals(this.getJdbcUrl(), other.getJdbcUrl())) {
            return false;
        }
        if (!Objects.equals(this.getDataSourceId(), other.getDataSourceId())) {
            return false;
        }
        if (!Objects.equals(this.getMaxPrefetchedRows(), other.getMaxPrefetchedRows())) {
            return false;
        }
        if (!Objects.equals(this.getErrorHandling(), other.getErrorHandling())) {
            return false;
        }
        if (!Objects.equals(this.getLocalDateFormat(), other.getLocalDateFormat())) {
            return false;
        }
        if (!Objects.equals(this.getTimeFormat(), other.getTimeFormat())) {
            return false;
        }
        if (!Objects.equals(this.getTimestampFormat(), other.getTimestampFormat())) {
            return false;
        }
        if (!Objects.equals(this.getTimeWithTimezoneFormat(), other.getTimeWithTimezoneFormat())) {
            return false;
        }
        if (!Objects.equals(this.getTimestampWithTimezoneFormat(), other.getTimestampWithTimezoneFormat())) {
            return false;
        }
        if (!Objects.equals(this.getVectorComponentDelimiter(), other.getVectorComponentDelimiter())) {
            return false;
        }
        if (!Objects.equals(this.getPoint2d(), other.getPoint2d())) {
            return false;
        }
        if (!Objects.equals(this.getAttributes(), other.getAttributes())) {
            return false;
        }
        if (!Objects.equals(this.values.get(Field.PASSWORD), other.values.get(Field.PASSWORD))) {
            return false;
        }
        return Objects.equals(this.getKeystoreAlias(), other.getKeystoreAlias());
    }

    public static enum Field implements ConfigField
    {
        NAME(Collections.emptyList(), Collections.emptyList(), String.class, true, null, false, false, false, false),
        PG_VIEW_NAME(Collections.emptyList(), Collections.emptyList(), String.class, false, null, false, false, false, false),
        QUERIES(Collections.emptyList(), Collections.emptyList(), String.class, false, null, true, false, false, false),
        PREPARED_QUERIES(Collections.emptyList(), Collections.emptyList(), PreparedQueryConfig.class, false, null, true, false, false, false),
        OPTIMIZED_FOR(Collections.emptyList(), Collections.emptyList(), GraphOptimizedFor.class, false, (Object)((Object)GraphOptimizedFor.READ), false, false, false, false),
        VERTEX_ID_STRATEGY(Collections.emptyList(), Collections.emptyList(), IdStrategy.class, false, null, false, false, false, false),
        EDGE_ID_STRATEGY(Collections.emptyList(), Collections.emptyList(), IdStrategy.class, false, null, false, false, false, false),
        VERTEX_ID_TYPE(Arrays.asList("node_id_type"), Collections.emptyList(), IdType.class, false, null, false, false, false, false),
        EDGE_ID_TYPE(Collections.emptyList(), Collections.emptyList(), IdType.class, false, null, false, false, false, false),
        ARRAY_COMPACTION_THRESHOLD(Collections.emptyList(), Collections.emptyList(), Double.class, false, 0.2, false, false, false, false),
        VERTEX_PROVIDERS(Collections.emptyList(), Collections.emptyList(), EntityProviderConfig.class, false, Collections.emptyList(), true, false, false, false),
        EDGE_PROVIDERS(Collections.emptyList(), Collections.emptyList(), EntityProviderConfig.class, false, Collections.emptyList(), true, false, false, false),
        LOADING(Arrays.asList("loading_options"), Collections.emptyList(), GraphLoadingConfig.class, false, Collections.emptyMap(), false, false, false, false),
        REDACTION_RULES(Collections.emptyList(), Collections.emptyList(), PgxRedactionRuleConfig.class, false, Collections.emptyList(), true, false, false, false),
        RULES_MAPPING(Collections.emptyList(), Collections.emptyList(), PgxRedactionRuleMappingConfig.class, false, Collections.emptyList(), true, false, false, false),
        EXTERNAL_STORES(Collections.emptyList(), Collections.emptyList(), ExternalStoreConfig.class, false, Collections.emptyList(), true, false, false, false),
        MAX_BATCH_SIZE(Collections.emptyList(), Collections.emptyList(), Integer.class, false, 10000, false, false, false, false),
        ES_URL(Collections.emptyList(), Collections.emptyList(), String.class, false, null, false, false, false, false),
        ES_INDEX_NAME(Arrays.asList("es_index_name"), Collections.emptyList(), String.class, false, null, false, false, false, false),
        PROXY_URL(Collections.emptyList(), Collections.emptyList(), String.class, false, null, false, false, false, false),
        SCROLL_TIME(Collections.emptyList(), Collections.emptyList(), String.class, false, "1m", false, false, false, false),
        USERNAME(Collections.emptyList(), Collections.emptyList(), String.class, false, null, false, false, false, false),
        NUM_CONNECTIONS(Collections.emptyList(), Collections.emptyList(), Integer.class, false, "<no-of-CPUs>", false, false, false, false),
        SCHEMA(Collections.emptyList(), Collections.emptyList(), String.class, false, null, false, false, false, false),
        JDBC_URL(Collections.emptyList(), Collections.emptyList(), String.class, false, null, false, false, false, false),
        DATA_SOURCE_ID(Collections.emptyList(), Collections.emptyList(), String.class, false, null, false, false, false, false),
        MAX_PREFETCHED_ROWS(Collections.emptyList(), Collections.emptyList(), Integer.class, false, 10000, false, false, false, false),
        ERROR_HANDLING(Collections.emptyList(), Collections.emptyList(), GraphErrorHandlingConfig.class, false, Collections.emptyMap(), false, false, false, false),
        LOCAL_DATE_FORMAT(Collections.emptyList(), Collections.emptyList(), String.class, false, Arrays.asList("yyyy-M[M]-d[d]", "M[M]/d[d]/yyyy", "d[d]-MMM-yyyy", "d[d]-M[M]-yyyy", "yyyy-MM-dd'T'H[H]:m[m][:s[s][.SSS[SSS]]][XXX]", "yyyy-MM-dd'T'H[H]:m[m][:s[s][.SSSSSS]][XXX]"), true, false, false, false),
        TIME_FORMAT(Collections.emptyList(), Collections.emptyList(), String.class, false, Arrays.asList("h[h]:m[m][:s[s][.SSS]] a[ XXX]", "[yyyy-MM-dd'T']H[H]:m[m][:s[s][.SSS[SSS]]][XXX]", "yyyy-MM-dd'T'H[H]:m[m][:s[s][.SSSSSS]][XXX]"), true, false, false, false),
        TIMESTAMP_FORMAT(Collections.emptyList(), Collections.emptyList(), String.class, false, Arrays.asList("yyyy-MM-dd'T'H[H]:m[m][:s[s][.SSS[SSS]]][XXX]", "yyyy-MM-dd H[H]:m[m][:s[s][.SSS[SSS]]][XXX]", "yyyy-MM-dd'T'H[H]:m[m][:s[s][.SSSSSS]][XXX]"), true, false, false, false),
        TIME_WITH_TIMEZONE_FORMAT(Collections.emptyList(), Collections.emptyList(), String.class, false, Arrays.asList("h[h]:m[m][:s[s]] a[ XXX]", "[yyyy-MM-dd'T']H[H]:m[m][:s[s][.SSS[SSS]]][XXX]", "yyyy-MM-dd'T'H[H]:m[m][:s[s][.SSSSSS]][XXX]"), true, false, false, false),
        TIMESTAMP_WITH_TIMEZONE_FORMAT(Collections.emptyList(), Collections.emptyList(), String.class, false, Arrays.asList("yyyy-MM-dd'T'H[H]:m[m][:s[s][.SSS[SSS]]][XXX]", "yyyy-MM-dd H[H]:m[m][:s[s][.SSS[SSS]]][XXX]", "yyyy-MM-dd'T'H[H]:m[m][:s[s][.SSSSSS]][XXX]"), true, false, false, false),
        VECTOR_COMPONENT_DELIMITER(Collections.emptyList(), Collections.emptyList(), Character.class, false, Character.valueOf(';'), false, false, false, false),
        POINT2D(Collections.emptyList(), Collections.emptyList(), String.class, false, "0.0 0.0", false, false, false, false),
        ATTRIBUTES(Collections.emptyList(), Collections.emptyList(), Map.class, false, Collections.emptyMap(), false, false, false, false),
        PASSWORD(Collections.emptyList(), Collections.emptyList(), String.class, false, null, false, false, true, true),
        KEYSTORE_ALIAS(Collections.emptyList(), Collections.emptyList(), String.class, false, null, false, false, false, false);

        private final List<String> aliases;
        private final List<String> singletonListAliases;
        private final Class<?> type;
        private final boolean required;
        private final Object defaultVal;
        private final boolean array;
        private final boolean path;
        private final boolean sensitive;
        private final boolean hidden;

        private Field(List<String> aliases, List<String> singletonListAliases, Class<?> type, boolean required, Object factoryDefaultVal, boolean array, boolean path, boolean sensitive, boolean hidden) {
            this.aliases = aliases;
            this.singletonListAliases = singletonListAliases;
            this.type = type;
            this.required = required;
            this.defaultVal = AbstractConfig.getDefault("partitioned.graph.json", this, factoryDefaultVal);
            this.array = array;
            this.path = path;
            this.sensitive = sensitive;
            this.hidden = hidden;
        }

        @Override
        public List<String> getKeyAliases() {
            return this.aliases;
        }

        @Override
        public List<String> getSingletonListKeyAliases() {
            return this.singletonListAliases;
        }

        @Override
        public Class<?> getType() {
            return this.type;
        }

        @Override
        public boolean isRequired() {
            return this.required;
        }

        @Override
        public boolean isArray() {
            return this.array;
        }

        @Override
        public boolean isPath() {
            return this.path;
        }

        @Override
        public Object getDefaultVal() {
            return this.defaultVal;
        }

        @Override
        @JsonValue
        public String toKey() {
            return this.name().toLowerCase();
        }

        public String toString() {
            return this.toKey();
        }

        @Override
        public boolean isSensitive() {
            return this.sensitive;
        }

        @Override
        public boolean isHidden() {
            return this.hidden;
        }
    }
}

