/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import java.util.List;
import oracle.pgx.common.types.IdType;
import oracle.pgx.common.types.PropertyType;
import oracle.pgx.common.util.NameValidator;
import oracle.pgx.config.AbstractConfig;
import oracle.pgx.config.AbstractPartitionedGraphConfig;
import oracle.pgx.config.CommonLoadableConfig;
import oracle.pgx.config.GraphPropertyConfig;
import oracle.pgx.config.ProviderFormat;
import oracle.pgx.config.ProviderLoadingConfig;
import oracle.pgx.config.internal.ConfigUtils;
import oracle.pgx.config.internal.ConvertibleToEntityProviderConfigBuilder;

public abstract class EntityProviderConfig
extends AbstractConfig
implements CommonLoadableConfig<ProviderFormat>,
ConvertibleToEntityProviderConfigBuilder {
    private IdType sourceVertexKeyType = IdType.LONG;
    private IdType destinationVertexKeyType = IdType.LONG;

    protected abstract void validate(AbstractPartitionedGraphConfig var1);

    public static boolean supportsVectorProperties(ProviderFormat format) {
        return format.supportsVectorProperties();
    }

    public static boolean supportsPropertyColumn(ProviderFormat format) {
        return format.supportsPropertyColumn();
    }

    public abstract String getLabel();

    public String getValidatedLabel() {
        String label = this.getLabel();
        if (label == null) {
            label = this.getName();
        }
        return label;
    }

    public abstract List<GraphPropertyConfig> getProps();

    @Override
    public abstract String getName();

    public abstract IdType getKeyType();

    public abstract Boolean hasKeys();

    public abstract ProviderLoadingConfig getLoading();

    public IdType getSourceVertexKeyType() {
        return this.sourceVertexKeyType;
    }

    public IdType getDestinationVertexKeyType() {
        return this.destinationVertexKeyType;
    }

    void setSourceVertexKeyType(IdType vertexIdType) {
        this.sourceVertexKeyType = vertexIdType;
    }

    void setDestinationVertexKeyType(IdType vertexIdType) {
        this.destinationVertexKeyType = vertexIdType;
    }

    public abstract String getSourceVertexProvider();

    public abstract String getDestinationVertexProvider();

    public int numProperties() {
        return this.getProps().size();
    }

    public String getPropertyName(int i) {
        return this.getProps().get(i).getName();
    }

    public PropertyType getPropertyType(int i) {
        return this.getProps().get(i).getType();
    }

    public int getPropertyDimension(int i) {
        return this.getProps().get(i).getDimension();
    }

    public Object getPropertyDefault(int i) {
        return this.getProps().get(i).getParsedDefaultValue();
    }

    public boolean isKeyMappingEnabled() {
        return this.getLoading().isCreateKeyMapping();
    }

    public boolean isLabelLoadingEnabled() {
        return false;
    }

    public boolean supportsVectorProperties() {
        return EntityProviderConfig.supportsVectorProperties((ProviderFormat)((Object)this.getFormat()));
    }

    public boolean supportsPropertyColumn() {
        return EntityProviderConfig.supportsPropertyColumn((ProviderFormat)((Object)this.getFormat()));
    }

    @Override
    protected void validate() {
        ConfigUtils.validateProperties(this.getProps(), this.supportsVectorProperties(), this.supportsPropertyColumn(), false, ((ProviderFormat)((Object)this.getFormat())).toString());
        NameValidator.validate((String[])new String[]{this.getName()});
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof EntityProviderConfig)) {
            return false;
        }
        EntityProviderConfig other = (EntityProviderConfig)obj;
        if (!this.getName().equals(other.getName())) {
            return false;
        }
        if (this.getProps().size() != other.getProps().size()) {
            return false;
        }
        if (this.getKeyType() != other.getKeyType()) {
            return false;
        }
        for (int i = 0; i < this.getProps().size(); ++i) {
            if (!this.getPropertyName(i).equals(other.getPropertyName(i))) {
                return false;
            }
            if (this.getPropertyType(i) != other.getPropertyType(i)) {
                return false;
            }
            if (this.getPropertyDimension(i) != other.getPropertyDimension(i)) {
                return false;
            }
            if (this.getPropertyDefault(i).equals(other.getPropertyDefault(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int code = this.getName().hashCode();
        code += this.getKeyType().hashCode();
        for (GraphPropertyConfig prop : this.getProps()) {
            code += prop.getName().hashCode();
            code += prop.getType().hashCode();
        }
        return code;
    }
}

