/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import oracle.pgx.common.util.ConfigJsonUtil;
import oracle.pgx.config.DataMemoryLimitsConfig;

public final class DataMemoryLimitsConfigBuilder {
    private final Map<DataMemoryLimitsConfig.Field, Object> values = new HashMap<DataMemoryLimitsConfig.Field, Object>();

    public static DataMemoryLimitsConfig buildDataMemoryLimitsConfig(Consumer<DataMemoryLimitsConfigBuilder> builderSetup) {
        DataMemoryLimitsConfigBuilder builder = new DataMemoryLimitsConfigBuilder();
        builderSetup.accept(builder);
        return builder.build();
    }

    public DataMemoryLimitsConfigBuilder() {
    }

    public DataMemoryLimitsConfigBuilder(Map<DataMemoryLimitsConfig.Field, Object> values) {
        this.putAll(values);
    }

    public DataMemoryLimitsConfigBuilder(DataMemoryLimitsConfig config) {
        this.putAll(config);
    }

    public DataMemoryLimitsConfigBuilder(DataMemoryLimitsConfigBuilder builder) {
        this.putAll(builder.values);
    }

    public DataMemoryLimitsConfigBuilder putAll(Map<DataMemoryLimitsConfig.Field, Object> values) {
        this.values.putAll(values);
        return this;
    }

    public DataMemoryLimitsConfigBuilder putAll(DataMemoryLimitsConfig config) {
        this.putAll(config.getValuesWithoutDefaults());
        return this;
    }

    public DataMemoryLimitsConfigBuilder clear() {
        this.values.clear();
        return this;
    }

    public DataMemoryLimitsConfig build(String parentPath) {
        try {
            return DataMemoryLimitsConfig.parse(this.toInputStream(), true, parentPath);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public DataMemoryLimitsConfig build() {
        return this.build(null);
    }

    public InputStream toInputStream() {
        try {
            return ConfigJsonUtil.toJsonInputStream(this.values);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public Map<DataMemoryLimitsConfig.Field, Object> getValues() {
        return Collections.unmodifiableMap(this.values);
    }

    public String toString() {
        return "DataMemoryLimitsConfigBuilder" + this.values;
    }

    public DataMemoryLimitsConfigBuilder setMaxTotalDataMemorySize(String maxTotalDataMemorySize) {
        this.values.put(DataMemoryLimitsConfig.Field.MAX_TOTAL_DATA_MEMORY_SIZE, maxTotalDataMemorySize);
        return this;
    }

    public DataMemoryLimitsConfigBuilder setMaxTotalDataMemoryRatio(double maxTotalDataMemoryRatio) {
        this.values.put(DataMemoryLimitsConfig.Field.MAX_TOTAL_DATA_MEMORY_RATIO, maxTotalDataMemoryRatio);
        return this;
    }

    public DataMemoryLimitsConfigBuilder setMaxTotalPrivateDataMemorySize(String maxTotalPrivateDataMemorySize) {
        this.values.put(DataMemoryLimitsConfig.Field.MAX_TOTAL_PRIVATE_DATA_MEMORY_SIZE, maxTotalPrivateDataMemorySize);
        return this;
    }

    public DataMemoryLimitsConfigBuilder setMaxTotalPrivateDataMemoryRatio(double maxTotalPrivateDataMemoryRatio) {
        this.values.put(DataMemoryLimitsConfig.Field.MAX_TOTAL_PRIVATE_DATA_MEMORY_RATIO, maxTotalPrivateDataMemoryRatio);
        return this;
    }

    public DataMemoryLimitsConfigBuilder setMaxTotalSharedDataMemorySize(String maxTotalSharedDataMemorySize) {
        this.values.put(DataMemoryLimitsConfig.Field.MAX_TOTAL_SHARED_DATA_MEMORY_SIZE, maxTotalSharedDataMemorySize);
        return this;
    }

    public DataMemoryLimitsConfigBuilder setMaxTotalSharedDataMemoryRatio(double maxTotalSharedDataMemoryRatio) {
        this.values.put(DataMemoryLimitsConfig.Field.MAX_TOTAL_SHARED_DATA_MEMORY_RATIO, maxTotalSharedDataMemoryRatio);
        return this;
    }

    public DataMemoryLimitsConfigBuilder setMaxPerUserDataMemorySize(String maxPerUserDataMemorySize) {
        this.values.put(DataMemoryLimitsConfig.Field.MAX_PER_USER_DATA_MEMORY_SIZE, maxPerUserDataMemorySize);
        return this;
    }

    public DataMemoryLimitsConfigBuilder setMaxPerUserDataMemoryRatio(double maxPerUserDataMemoryRatio) {
        this.values.put(DataMemoryLimitsConfig.Field.MAX_PER_USER_DATA_MEMORY_RATIO, maxPerUserDataMemoryRatio);
        return this;
    }

    public DataMemoryLimitsConfigBuilder setMaxPerSessionDataMemorySize(String maxPerSessionDataMemorySize) {
        this.values.put(DataMemoryLimitsConfig.Field.MAX_PER_SESSION_DATA_MEMORY_SIZE, maxPerSessionDataMemorySize);
        return this;
    }

    public DataMemoryLimitsConfigBuilder setMaxPerSessionDataMemoryRatio(double maxPerSessionDataMemoryRatio) {
        this.values.put(DataMemoryLimitsConfig.Field.MAX_PER_SESSION_DATA_MEMORY_RATIO, maxPerSessionDataMemoryRatio);
        return this;
    }
}

