/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import com.fasterxml.jackson.annotation.JsonValue;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import oracle.pgx.common.util.ConfigJsonUtil;
import oracle.pgx.config.AbstractAuthorizationEntityConfig;
import oracle.pgx.config.AbstractConfig;
import oracle.pgx.config.AuthorizationEntityPermissionConfig;
import oracle.pgx.config.ConfigField;
import oracle.pgx.config.ConfigParser;
import oracle.pgx.config.ParseResult;
import oracle.pgx.config.PropertiesConfigParser;

public class AuthorizationEntityConfig
extends AbstractAuthorizationEntityConfig {
    private final Map<Field, Object> values;
    private final Set<Field> defaults;
    private final Map<String, Object> leftoverValues;

    public static AuthorizationEntityConfig parse(InputStream is, boolean strict, String parentPath) throws IOException {
        return AuthorizationEntityConfig.parse(ConfigParser.parseRaw(is), strict, parentPath);
    }

    static AuthorizationEntityConfig parse(InputStream is, boolean strict, String parentPath, boolean parseHiddenValues) throws IOException {
        return AuthorizationEntityConfig.parse(ConfigParser.parseRaw(is), strict, parentPath, parseHiddenValues);
    }

    public static AuthorizationEntityConfig parse(Map<String, Object> raw, boolean strict, String parentPath) {
        ParseResult pr = ConfigParser.parse(raw, (ConfigField[])Field.values(), (boolean)strict, (String)parentPath);
        return new AuthorizationEntityConfig(pr.getValues(), raw, pr.getDefaults());
    }

    static AuthorizationEntityConfig parse(Map<String, Object> raw, boolean strict, String parentPath, boolean parseHiddenValues) {
        ParseResult pr = ConfigParser.parse(raw, (ConfigField[])Field.values(), (boolean)strict, (String)parentPath, (boolean)parseHiddenValues);
        return new AuthorizationEntityConfig(pr.getValues(), raw, pr.getDefaults());
    }

    public static AuthorizationEntityConfig parse(Properties props, boolean strict) {
        ParseResult pr = PropertiesConfigParser.parse((Properties)props, (ConfigField[])Field.values(), (boolean)strict);
        return new AuthorizationEntityConfig(pr.getValues(), null, pr.getDefaults());
    }

    public static Field[] getConfigFields() {
        return Field.values();
    }

    protected AuthorizationEntityConfig(Map<Field, Object> values, Map<String, Object> leftoverValues, Set<Field> defaults) {
        this.values = values;
        this.leftoverValues = leftoverValues == null ? Collections.emptyMap() : leftoverValues;
        this.defaults = defaults;
        this.initialize();
    }

    public Map<Field, Object> getValues() {
        return this.values;
    }

    public boolean isEmpty() {
        return this.getValuesWithoutDefaults().isEmpty();
    }

    @Override
    public boolean hasDefaultValue(Field field) {
        return this.defaults.contains(field);
    }

    @JsonValue
    public Map<Field, Object> getValuesWithoutDefaults() {
        HashMap<Field, Object> valuesWithoutDefaults = new HashMap<Field, Object>(this.values);
        for (Field field : this.defaults) {
            valuesWithoutDefaults.remove(field);
        }
        return valuesWithoutDefaults;
    }

    public Map<String, Object> getLeftoverValues() {
        return this.leftoverValues;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean hideSensitiveData) {
        if (!this.canSerialize()) {
            throw new UnsupportedOperationException("some objects part of this config cannot be serialized");
        }
        try {
            Object configValues = hideSensitiveData ? this.hiddenSensitiveData() : this;
            return ConfigJsonUtil.toJson(configValues);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private final Map<Field, Object> hiddenSensitiveData() {
        HashMap<Field, Object> hiddenValues = new HashMap<Field, Object>(this.getValuesWithoutDefaults());
        for (Field f : this.values.keySet()) {
            if (!f.isSensitive()) continue;
            hiddenValues.put(f, "*******");
        }
        return hiddenValues;
    }

    @Override
    public String getPgxUser() {
        return (String)this.values.get(Field.PGX_USER);
    }

    @Override
    public String getPgxRole() {
        return (String)this.values.get(Field.PGX_ROLE);
    }

    @Override
    public List<AuthorizationEntityPermissionConfig> getPgxPermissions() {
        return (List)this.values.get(Field.PGX_PERMISSIONS);
    }

    @Override
    public String getMaxDataMemorySize() {
        return (String)this.values.get(Field.MAX_DATA_MEMORY_SIZE);
    }

    @Override
    public Double getMaxDataMemoryRatio() {
        return (Double)this.values.get(Field.MAX_DATA_MEMORY_RATIO);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AuthorizationEntityConfig other = (AuthorizationEntityConfig)obj;
        if (!Objects.equals(this.getPgxUser(), other.getPgxUser())) {
            return false;
        }
        if (!Objects.equals(this.getPgxRole(), other.getPgxRole())) {
            return false;
        }
        if (!Objects.equals(this.getPgxPermissions(), other.getPgxPermissions())) {
            return false;
        }
        if (!Objects.equals(this.getMaxDataMemorySize(), other.getMaxDataMemorySize())) {
            return false;
        }
        return Objects.equals(this.getMaxDataMemoryRatio(), other.getMaxDataMemoryRatio());
    }

    public static enum Field implements ConfigField
    {
        PGX_USER(Collections.emptyList(), Collections.emptyList(), String.class, false, null, false, false, false, false),
        PGX_ROLE(Collections.emptyList(), Collections.emptyList(), String.class, false, null, false, false, false, false),
        PGX_PERMISSIONS(Collections.emptyList(), Collections.emptyList(), AuthorizationEntityPermissionConfig.class, true, Collections.emptyList(), true, false, false, false),
        MAX_DATA_MEMORY_SIZE(Collections.emptyList(), Collections.emptyList(), String.class, false, null, false, false, false, false),
        MAX_DATA_MEMORY_RATIO(Collections.emptyList(), Collections.emptyList(), Double.class, false, 1.0, false, false, false, false);

        private final List<String> aliases;
        private final List<String> singletonListAliases;
        private final Class<?> type;
        private final boolean required;
        private final Object defaultVal;
        private final boolean array;
        private final boolean path;
        private final boolean sensitive;
        private final boolean hidden;

        private Field(List<String> aliases, List<String> singletonListAliases, Class<?> type, boolean required, Object factoryDefaultVal, boolean array, boolean path, boolean sensitive, boolean hidden) {
            this.aliases = aliases;
            this.singletonListAliases = singletonListAliases;
            this.type = type;
            this.required = required;
            this.defaultVal = AbstractConfig.getDefault("authorization.entity.json", this, factoryDefaultVal);
            this.array = array;
            this.path = path;
            this.sensitive = sensitive;
            this.hidden = hidden;
        }

        @Override
        public List<String> getKeyAliases() {
            return this.aliases;
        }

        @Override
        public List<String> getSingletonListKeyAliases() {
            return this.singletonListAliases;
        }

        @Override
        public Class<?> getType() {
            return this.type;
        }

        @Override
        public boolean isRequired() {
            return this.required;
        }

        @Override
        public boolean isArray() {
            return this.array;
        }

        @Override
        public boolean isPath() {
            return this.path;
        }

        @Override
        public Object getDefaultVal() {
            return this.defaultVal;
        }

        @Override
        @JsonValue
        public String toKey() {
            return this.name().toLowerCase();
        }

        public String toString() {
            return this.toKey();
        }

        @Override
        public boolean isSensitive() {
            return this.sensitive;
        }

        @Override
        public boolean isHidden() {
            return this.hidden;
        }
    }
}

