/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import java.util.Objects;
import oracle.pgx.common.types.IdType;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.config.DbEngine;
import oracle.pgx.config.GraphConfig;

public abstract class AbstractPgGraphConfig
extends GraphConfig {
    private Object opg;

    public abstract DbEngine getDbEngine();

    public abstract Integer getMaxNumConnections();

    public void setOraclePropertyGraph(Object opg) {
        this.opg = opg;
        if (opg != null) {
            this.setSerializable(false);
        }
    }

    public Object getOraclePropertyGraph() {
        return this.opg;
    }

    @Override
    public IdType getVertexIdType() {
        return IdType.LONG;
    }

    @Override
    protected void validate() {
        super.validate();
        if (this.getMaxNumConnections() < 1) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"INVALID_NUMBER_OF_CONNECTIONS", (Object[])new Object[]{this.getMaxNumConnections()}));
        }
        if (this.getVertexIdType() != IdType.LONG) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"UNSUPPORTED_NODE_KEY_TYPE", (Object[])new Object[]{this.getVertexIdType()}));
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractPgGraphConfig that = (AbstractPgGraphConfig)o;
        if (!super.equals(that)) {
            return false;
        }
        if (!Objects.equals((Object)this.getDbEngine(), (Object)that.getDbEngine())) {
            return false;
        }
        return Objects.equals(this.getName(), that.getName());
    }

    @Override
    public int hashCode() {
        int code = super.hashCode();
        code += this.getDbEngine().hashCode();
        if (this.getName() != null) {
            code += this.getName().hashCode();
        }
        return code;
    }
}

