/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.common.util.NameValidator;
import oracle.pgx.config.AbstractPartitionedGraphConfig;
import oracle.pgx.config.EntityProviderConfig;
import oracle.pgx.config.EsConnectionConfig;
import oracle.pgx.config.EsEntityProviderConfig;
import oracle.pgx.config.EsEntityProviderConfigBuilder;
import oracle.pgx.config.GraphPropertyConfig;

public abstract class AbstractEsEntityProviderConfig
extends EntityProviderConfig
implements EsConnectionConfig {
    @Override
    public EsEntityProviderConfigBuilder toEntityProviderConfigBuilder() {
        return new EsEntityProviderConfigBuilder().copyFrom((EsEntityProviderConfig)this);
    }

    public abstract boolean hasDefaultValue(EsEntityProviderConfig.Field var1);

    public abstract String getKeyField();

    public abstract String getSourceField();

    public abstract String getDestinationField();

    @Override
    public boolean supportsVectorProperties() {
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractEsEntityProviderConfig that = (AbstractEsEntityProviderConfig)o;
        if (!super.equals(that)) {
            return false;
        }
        if (!Objects.equals(this.getEsUrl(), that.getEsUrl())) {
            return false;
        }
        if (!Objects.equals(this.getEsIndexName(), that.getEsIndexName())) {
            return false;
        }
        if (!Objects.equals(this.getScrollTime(), that.getScrollTime())) {
            return false;
        }
        if (!Objects.equals(this.getUsername(), that.getUsername())) {
            return false;
        }
        if (!Objects.equals(this.getKeystoreAlias(), that.getKeystoreAlias())) {
            return false;
        }
        if (!Objects.equals(this.getLoadedEsIndexName(), that.getLoadedEsIndexName())) {
            return false;
        }
        if (this.hasKeys() != that.hasKeys()) {
            return false;
        }
        if (this.hasKeys().booleanValue() && !Objects.equals(this.getKeyField(), that.getKeyField())) {
            return false;
        }
        if (!Objects.equals(this.getDestinationField(), that.getDestinationField())) {
            return false;
        }
        return Objects.equals(this.getSourceField(), that.getSourceField());
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        if (this.getEsUrl() != null) {
            hash += this.getEsUrl().hashCode();
        }
        if (this.getEsIndexName() != null) {
            hash += this.getEsIndexName().hashCode();
        }
        if (this.getScrollTime() != null) {
            hash += this.getScrollTime().hashCode();
        }
        if (this.getUsername() != null) {
            hash += this.getUsername().hashCode();
        }
        if (this.getKeystoreAlias() != null) {
            hash += this.getKeystoreAlias().hashCode();
        }
        hash += this.getLoadedEsIndexName().hashCode();
        if (this.hasKeys().booleanValue() && this.getKeyField() != null) {
            hash += this.getKeyField().hashCode();
        }
        if (this.getDestinationField() != null) {
            hash += this.getDestinationField().hashCode();
        }
        if (this.getSourceField() != null) {
            hash += this.getSourceField().hashCode();
        }
        return hash;
    }

    @Override
    protected void validate() {
        super.validate();
        String indexName = this.getLoadedEsIndexName();
        if (indexName == null) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"ES_INDEX_NAME_NOT_SET", (Object[])new Object[0]));
        }
        NameValidator.validate((String[])new String[]{this.getKeyField(), this.getSourceField(), this.getDestinationField()});
        for (GraphPropertyConfig prop : this.getProps()) {
            NameValidator.validate((String[])new String[]{prop.getName()});
        }
    }

    @Override
    protected void validate(AbstractPartitionedGraphConfig graphConfig) {
        this.validate();
        String esUrl = this.getEsUrl(graphConfig);
        if (esUrl == null || esUrl.isEmpty()) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"ES_URL_NOT_SET", (Object[])new Object[0]));
        }
        try {
            URL uRL = new URL(esUrl);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public abstract String getKeystoreAlias();

    @Override
    public abstract String getEsIndexName();

    public String getLoadedEsIndexName() {
        String name = this.getEsIndexName();
        return name != null ? name : this.getName();
    }

    public String getEsUrl(AbstractPartitionedGraphConfig graphConfig) {
        return this.hasDefaultValue(EsEntityProviderConfig.Field.ES_URL) ? graphConfig.getEsUrl() : this.getEsUrl();
    }

    public String getEsIndexName(AbstractPartitionedGraphConfig graphConfig) {
        return this.hasDefaultValue(EsEntityProviderConfig.Field.ES_INDEX_NAME) ? graphConfig.getEsIndexName() : this.getEsIndexName();
    }

    public String getScrollTime(AbstractPartitionedGraphConfig graphConfig) {
        return this.hasDefaultValue(EsEntityProviderConfig.Field.SCROLL_TIME) ? graphConfig.getScrollTime() : this.getEsIndexName();
    }

    public String getUsername(AbstractPartitionedGraphConfig graphConfig) {
        return this.hasDefaultValue(EsEntityProviderConfig.Field.USERNAME) ? graphConfig.getUsername() : this.getUsername();
    }

    public String getKeystoreAlias(AbstractPartitionedGraphConfig graphConfig) {
        return this.hasDefaultValue(EsEntityProviderConfig.Field.KEYSTORE_ALIAS) ? graphConfig.getKeystoreAlias() : this.getKeystoreAlias();
    }

    public Integer getMaxBatchSize(AbstractPartitionedGraphConfig graphConfig) {
        return this.hasDefaultValue(EsEntityProviderConfig.Field.MAX_BATCH_SIZE) ? graphConfig.getMaxBatchSize() : this.getMaxBatchSize(graphConfig);
    }
}

