/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.config.ConfigField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConfigParser<F extends ConfigField> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractConfigParser.class);
    protected final F[] fields;
    protected final boolean strict;

    protected AbstractConfigParser(F[] fields, boolean strict) {
        this.fields = fields;
        this.strict = strict;
    }

    protected void error(String key, Object ... params) {
        if (this.strict) {
            throw this.criticalError(key, params);
        }
        LOG.error(ErrorMessages.getMessage((String)key, (Object[])params));
    }

    protected void error(String key, Throwable cause, Object ... params) {
        if (this.strict) {
            throw this.criticalError(key, cause, new Object[0]);
        }
        LOG.error(ErrorMessages.getMessage((String)key, (Object[])params), cause);
    }

    protected RuntimeException criticalError(String key, Object ... params) {
        return new IllegalArgumentException(ErrorMessages.getMessage((String)key, (Object[])params));
    }

    protected RuntimeException criticalError(String key, Throwable cause, Object ... params) {
        return new IllegalArgumentException(ErrorMessages.getMessage((String)key, (Object[])params), cause);
    }
}

