/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.client;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.type.CollectionType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import oracle.pgx.api.internal.Edge;
import oracle.pgx.api.internal.Vertex;
import oracle.pgx.client.AbstractRemoteIterator;
import oracle.pgx.common.types.PropertyType;
import oracle.pgx.common.types.Type;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.common.util.JsonUtil;
import org.apache.hc.client5.http.fluent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RemoteValueIterator<K>
extends AbstractRemoteIterator<K> {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteValueIterator.class);
    private final Type valueType;
    private final Boolean wrappedEntities;

    public RemoteValueIterator(Executor httpExecutor, String requestUrl, String proxyId, int prefetchSize, Type valueType, Boolean wrappedEntities) {
        super(httpExecutor, requestUrl, proxyId, prefetchSize);
        this.valueType = valueType;
        this.wrappedEntities = wrappedEntities;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Collection<K> parseResults(String jsonString) throws JsonParseException, JsonMappingException, IOException {
        if (this.valueType != null) {
            CollectionType collectionClass;
            if (Boolean.TRUE.equals(this.wrappedEntities)) {
                if (this.valueType == PropertyType.VERTEX) {
                    collectionClass = JsonUtil.getTypeFactory().constructCollectionType(ArrayList.class, Vertex.class);
                } else {
                    if (this.valueType != PropertyType.EDGE) throw new IllegalStateException(ErrorMessages.getMessage((String)"UNSUPPORTED_ENTITY_TYPE", (Object[])new Object[]{this.valueType}));
                    collectionClass = JsonUtil.getTypeFactory().constructCollectionType(ArrayList.class, Edge.class);
                }
            } else {
                collectionClass = JsonUtil.getTypeFactory().constructCollectionType(ArrayList.class, this.valueType.getTypeClass());
            }
            JsonNode node = JsonUtil.readTopLevelJsonToTree((String)jsonString);
            JsonParser items = JsonUtil.getValues((JsonNode)node, (String)"items");
            return (ArrayList)JsonUtil.readValue((JsonParser)items, (JavaType)collectionClass);
        }
        LOG.warn("valueType is null, I assume this means there was no entries in the List. Returning empty List.");
        return Collections.emptyList();
    }
}

