/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.client;

import java.net.URI;
import java.util.Iterator;
import oracle.pgx.api.internal.CollectionProxy;
import oracle.pgx.api.internal.ProxyException;
import oracle.pgx.client.RemoteUtils;
import oracle.pgx.client.RemoteValueIterator;
import oracle.pgx.common.types.CollectionType;
import oracle.pgx.common.types.PropertyType;
import oracle.pgx.common.types.Type;
import oracle.pgx.config.ClientConfig;
import org.apache.http.client.fluent.Executor;

public class RemoteCollectionProxy
implements CollectionProxy {
    private final Executor httpExecutor;
    private final String remoteCollectionProxyPath;
    private final String proxyId;
    private final CollectionType collectionType;
    private final int size;
    private final int prefetchSize;
    private final PropertyType valueType;
    private final Boolean wrappedEntities;
    private final URI baseUri;

    public RemoteCollectionProxy(Executor httpExecutor, String path, String proxyId, CollectionType collectionType, int size, int prefetchSize, PropertyType valueType, Boolean wrappedEntities) {
        this.httpExecutor = httpExecutor;
        this.remoteCollectionProxyPath = RemoteUtils.stripTrailingSlash(path);
        this.proxyId = proxyId;
        this.collectionType = collectionType;
        this.size = size;
        this.prefetchSize = prefetchSize;
        this.valueType = valueType;
        this.wrappedEntities = wrappedEntities;
        this.baseUri = URI.create(ClientConfig.Field.BASE_URL.toString());
    }

    private Iterator<Object> getRemoteIterator(String url) {
        return new RemoteValueIterator<Object>(this.httpExecutor, url, this.proxyId, this.prefetchSize, (Type)this.valueType, this.wrappedEntities);
    }

    public String getId() {
        throw new RuntimeException("getId() should never be called on RemoteCollectionProxy");
    }

    public int size() throws ProxyException {
        return this.size;
    }

    public CollectionType getType() throws ProxyException {
        return this.collectionType;
    }

    public PropertyType getElementType() {
        return this.valueType;
    }

    public boolean containsWrappedElement() throws ProxyException {
        throw new RuntimeException("containsWrappedElement() should never be called on RemoteCollectionProxy");
    }

    public Iterator<Object> iterator() throws ProxyException {
        String elementsUrl = this.remoteCollectionProxyPath + "/elements";
        return this.getRemoteIterator(elementsUrl);
    }

    private URI getBaseUri() {
        return this.baseUri;
    }
}

