/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.client;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import oracle.pgx.client.RemoteResponse;
import oracle.pgx.client.RemoteUtils;
import oracle.pgx.common.pojo.UnsafeHttpMethodRequest;
import oracle.pgx.common.util.JsonUtil;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.fluent.Executor;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.fluent.Response;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequestExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(HttpRequestExecutor.class);
    private final Executor httpExecutor;
    private final String csrfToken;
    private final boolean isControl;
    private final String baseUrl;

    public HttpRequestExecutor(Executor httpExecutor, String csrfToken, boolean isControl, String baseUrl) {
        this.httpExecutor = httpExecutor;
        this.csrfToken = csrfToken;
        this.isControl = isControl;
        this.baseUrl = baseUrl;
    }

    public RemoteResponse post(UnsafeHttpMethodRequest payload, String url) throws IOException, ExecutionException {
        return this.post(Collections.emptyList(), payload, url);
    }

    public RemoteResponse post(List<NameValuePair> headers, String url) throws IOException, ExecutionException {
        return this.post(headers, new UnsafeHttpMethodRequest(), url);
    }

    public RemoteResponse post(List<NameValuePair> headers, UnsafeHttpMethodRequest payload, String url) throws IOException, ExecutionException {
        assert (this.csrfToken != null);
        payload.csrfToken = this.csrfToken;
        String jsonPayload = JsonUtil.toJson((Object)payload);
        Request request = Request.Post((String)url).bodyString(jsonPayload, ContentType.APPLICATION_JSON);
        LOG.debug("Requesting {} with payload {}", (Object)request, (Object)jsonPayload);
        headers.forEach(header -> request.addHeader(header.getName(), header.getValue()));
        return this.executeRequest(request);
    }

    public RemoteResponse patch(UnsafeHttpMethodRequest payload, String url) throws IOException, ExecutionException {
        assert (this.csrfToken != null);
        payload.csrfToken = this.csrfToken;
        String jsonPayload = JsonUtil.toJson((Object)payload);
        Request request = Request.Patch((String)url).bodyString(jsonPayload, ContentType.APPLICATION_JSON);
        LOG.debug("Requesting {} with payload {}", (Object)request, (Object)jsonPayload);
        return this.executeRequest(request);
    }

    public RemoteResponse patch(List<NameValuePair> headers, UnsafeHttpMethodRequest payload, String url) throws IOException, ExecutionException {
        payload.csrfToken = this.csrfToken;
        String jsonPayload = JsonUtil.toJson((Object)payload);
        Request request = Request.Patch((String)url).bodyString(jsonPayload, ContentType.APPLICATION_JSON);
        LOG.debug("Requesting {} with payload {}", (Object)request, (Object)jsonPayload);
        headers.forEach(header -> request.addHeader(header.getName(), header.getValue()));
        return this.executeRequest(request);
    }

    public RemoteResponse put(List<NameValuePair> headers, String url, UnsafeHttpMethodRequest payload) throws IOException, ExecutionException {
        assert (this.csrfToken != null);
        payload.csrfToken = this.csrfToken;
        String jsonPayload = JsonUtil.toJson((Object)payload);
        Request request = Request.Put((String)url).bodyString(jsonPayload, ContentType.APPLICATION_JSON);
        LOG.debug("Requesting {} with payload {}", (Object)request, (Object)jsonPayload);
        headers.forEach(header -> request.addHeader(header.getName(), header.getValue()));
        return this.executeRequest(request);
    }

    public RemoteResponse delete(List<NameValuePair> headers, String url) throws IOException, ExecutionException {
        return this.delete(headers, url, Collections.emptyList());
    }

    public RemoteResponse delete(List<NameValuePair> headers, String url, String name, String value) throws IOException, ExecutionException {
        return this.delete(headers, url, Collections.singletonList(new BasicNameValuePair(name, value)));
    }

    public RemoteResponse delete(List<NameValuePair> headers, String url, List<NameValuePair> queryParams) throws IOException, ExecutionException {
        assert (this.csrfToken != null);
        try {
            URIBuilder builder = new URIBuilder(url);
            builder.addParameter("_csrf_token", this.csrfToken);
            builder.addParameters(queryParams);
            Request request = Request.Delete((URI)builder.build());
            LOG.debug("Requesting {}", (Object)request.toString());
            headers.forEach(header -> request.addHeader(header.getName(), header.getValue()));
            return this.executeRequest(request);
        }
        catch (URISyntaxException e) {
            throw new ExecutionException(e);
        }
    }

    public RemoteResponse get(String url) throws IOException, ExecutionException {
        return this.get(url, Collections.emptyList());
    }

    public RemoteResponse get(String url, String paramName, String paramValue) throws IOException, ExecutionException {
        return this.get(url, Collections.singletonList(new BasicNameValuePair(paramName, paramValue)));
    }

    public RemoteResponse get(List<NameValuePair> headers, String url, String paramName, String paramValue) throws IOException, ExecutionException {
        return this.get(headers, url, Collections.singletonList(new BasicNameValuePair(paramName, paramValue)));
    }

    public RemoteResponse get(List<NameValuePair> headers, String url, List<NameValuePair> queryParams) throws IOException, ExecutionException {
        try {
            Request request = Request.Get((URI)new URIBuilder(url).addParameters(queryParams).build());
            LOG.debug("Requesting {}", (Object)request.toString());
            headers.forEach(header -> request.addHeader(header.getName(), header.getValue()));
            return this.executeRequest(request);
        }
        catch (URISyntaxException e) {
            throw new ExecutionException(e);
        }
    }

    public RemoteResponse get(String url, List<NameValuePair> queryParams) throws IOException, ExecutionException {
        try {
            Request request = Request.Get((URI)new URIBuilder(url).addParameters(queryParams).build());
            LOG.debug("Requesting {}", (Object)request.toString());
            return this.executeRequest(request);
        }
        catch (URISyntaxException e) {
            throw new ExecutionException(e);
        }
    }

    public RemoteResponse get(List<NameValuePair> headers, String url) throws IOException, ExecutionException {
        Request request = Request.Get((String)url);
        LOG.debug("Requesting {}", (Object)request.toString());
        headers.forEach(header -> request.addHeader(header.getName(), header.getValue()));
        return this.executeRequest(request);
    }

    public RemoteResponse getWithHeaders(String url, String paramName, String paramValue) throws IOException, ExecutionException {
        return this.getWithHeaders(url, Collections.singletonList(new BasicNameValuePair(paramName, paramValue)));
    }

    public RemoteResponse getWithHeaders(String url, List<NameValuePair> headerParams) throws IOException, ExecutionException {
        try {
            Request request = Request.Get((URI)new URIBuilder(url).build());
            LOG.debug("Requesting {}", (Object)request.toString());
            headerParams.forEach(nameValuePair -> request.setHeader(nameValuePair.getName(), nameValuePair.getValue()));
            return this.executeRequest(request);
        }
        catch (URISyntaxException e) {
            throw new ExecutionException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RemoteResponse executeRequest(Request r) throws IOException, ExecutionException {
        RemoteResponse remoteResponse;
        block5: {
            Response response = this.httpExecutor.execute(r);
            HttpEntity entity = null;
            try {
                HttpResponse httpResponse = response.returnResponse();
                int status = httpResponse.getStatusLine().getStatusCode();
                LOG.debug("received HTTP status {}", (Object)status);
                entity = httpResponse.getEntity();
                String json = EntityUtils.toString((HttpEntity)entity);
                if (LOG.isDebugEnabled()) {
                    LOG.debug(json.length() < 2500 ? json : json.substring(0, 2500));
                }
                if (status >= 400) {
                    throw RemoteUtils.parseExceptionalResponse(status, httpResponse, entity, json);
                }
                URI remoteFutureLocation = this.isControl ? URI.create(this.baseUrl + "/control/v1/futures/x-future-id/") : URI.create(this.baseUrl + "/core/v1/futures/x-future-id/");
                remoteResponse = RemoteUtils.buildRemoteResponse(httpResponse, remoteFutureLocation);
                if (entity == null) break block5;
            }
            catch (Throwable throwable) {
                if (entity != null) {
                    EntityUtils.consume(entity);
                }
                throw throwable;
            }
            EntityUtils.consume((HttpEntity)entity);
        }
        return remoteResponse;
    }
}

