/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.client;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import oracle.pgx.api.ClientContext;
import oracle.pgx.api.PgxFuture;
import oracle.pgx.api.SessionContext;
import oracle.pgx.client.HttpRequestExecutor;
import oracle.pgx.client.PgxRemoteFuture;
import oracle.pgx.client.PgxRemoteRequest;
import oracle.pgx.client.RemoteResponse;
import oracle.pgx.client.RemoteUtils;
import oracle.pgx.common.marshalers.Marshaler;
import oracle.pgx.config.InteractionMode;
import org.apache.http.client.fluent.Executor;

public abstract class AbstractAsyncRequest<T>
implements PgxRemoteRequest<RemoteResponse> {
    private final Marshaler<T> marshaler;
    private final String csrfToken;
    private final ExecutorService executorService;
    private final Executor httpExecutor;
    private final int remoteFuturePendingRetryInterval;
    private final InteractionMode interactionMode;
    private final HttpRequestExecutor httpRequestExecutor;

    AbstractAsyncRequest(ClientContext context, Marshaler<T> marshaler, String baseUrl, SessionContext sessionContext, boolean isControl) {
        this.marshaler = marshaler;
        this.csrfToken = context.getCsrfToken();
        this.executorService = context.getExecutorService();
        this.httpExecutor = RemoteUtils.newHttpExecutor(context.getHttpClient(), baseUrl, sessionContext, context.getCsrfToken(), context.getClientStickyCookie());
        this.remoteFuturePendingRetryInterval = context.getConfig().getRemoteFuturePendingRetryInterval();
        this.interactionMode = context.getConfig().getClientServerInteractionMode();
        this.httpRequestExecutor = new HttpRequestExecutor(this.httpExecutor, this.csrfToken, isControl, baseUrl);
    }

    protected Executor getHttpExecutor() {
        return this.httpExecutor;
    }

    final PgxFuture<T> execute() {
        try {
            RemoteResponse response = (RemoteResponse)this.request();
            return new PgxRemoteFuture<T>(this.httpExecutor, this.executorService, this.csrfToken, response.getRemoteFutureLocation(), response.getFutureUuid(), this.marshaler, this.remoteFuturePendingRetryInterval, true, this.interactionMode);
        }
        catch (ExecutionException e) {
            return PgxFuture.exceptionallyCompletedFuture((Throwable)e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return PgxFuture.exceptionallyCompletedFuture((Throwable)e);
        }
        catch (Throwable e) {
            return PgxFuture.exceptionallyCompletedFuture((Throwable)e);
        }
    }

    HttpRequestExecutor getHttpRequestExecutor() {
        return this.httpRequestExecutor;
    }
}

