/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common.pojo;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import oracle.pgx.api.internal.Argument;
import oracle.pgx.common.PgxId;
import oracle.pgx.common.marshalers.Marshalers;
import oracle.pgx.common.pojo.GraphFilterDeserializer;
import oracle.pgx.common.types.ArgumentType;
import oracle.pgx.common.util.JsonUtil;

public class ArgumentDeserializer
extends JsonDeserializer<Argument> {
    public Argument deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonNode node = (JsonNode)jp.readValueAsTree();
        ArgumentType type = (ArgumentType)JsonUtil.fromJsonNode((JsonNode)node.get("type"), ArgumentType.class);
        JsonNode valueNode = node.get("value");
        Argument arg = new Argument();
        arg.setType(type);
        JsonNode tableNameNode = valueNode.get("tableName");
        if (tableNameNode != null) {
            if (type == ArgumentType.NODE_ID_IN || type == ArgumentType.NODE_ID_OUT) {
                arg.setValue(Marshalers.VERTEX_MARSHALER.unmarshal(valueNode.toString()));
                return arg;
            }
            if (type == ArgumentType.EDGE_ID_IN || type == ArgumentType.EDGE_ID_OUT) {
                arg.setValue(Marshalers.EDGE_MARSHALER.unmarshal(valueNode.toString()));
                return arg;
            }
        }
        if (type == ArgumentType.GENERIC_FILTER) {
            arg.setValue(GraphFilterDeserializer.parseGraphFilter(valueNode));
        } else {
            arg.setValue(JsonUtil.fromJsonNode((JsonNode)valueNode, Object.class));
        }
        if (type.isPgxId()) {
            arg.setValue(PgxId.fromString((String)arg.getName()));
        }
        return arg;
    }
}

