/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common.marshalers;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.io.IOException;
import oracle.pgx.api.SessionContext;
import oracle.pgx.api.internal.MapProxy;
import oracle.pgx.common.marshalers.Marshaler;
import oracle.pgx.common.pojo.MapProxyResponse;
import oracle.pgx.common.util.JsonUtil;
import oracle.pgx.common.util.RemoteMapProxyFactory;

public class MapProxyMarshaler<K, V>
implements Marshaler<MapProxy<K, V>> {
    private final SessionContext sessionContext;
    private final RemoteMapProxyFactory mapProxyFactory;

    public MapProxyMarshaler(SessionContext sessionContext, RemoteMapProxyFactory factory) {
        this.sessionContext = sessionContext;
        this.mapProxyFactory = factory;
    }

    public MapProxyMarshaler() {
        this(null, null);
    }

    @Override
    public MapProxy<K, V> unmarshal(String jsonString) throws JsonParseException, JsonMappingException, IOException {
        if (this.mapProxyFactory == null) {
            throw new IllegalStateException("map proxy factory is not set");
        }
        if (this.sessionContext.getSessionId() == null) {
            throw new IllegalStateException("session is not set");
        }
        MapProxyResponse response = (MapProxyResponse)((Object)JsonUtil.readTopLevelJson((String)jsonString, MapProxyResponse.class));
        return this.mapProxyFactory.createRemoteMapProxy(this.sessionContext, response.proxyId, response.size, response.keyType, response.keyNodeEdgeValueType, response.valueType, response.valueNodeEdgeValueType, response.mapName);
    }

    @Override
    public String marshal(MapProxy<K, V> mapProxy) throws JsonGenerationException, JsonMappingException, IOException {
        String proxyUUID = mapProxy.getId();
        MapProxyResponse response = new MapProxyResponse(proxyUUID);
        response.proxyId = proxyUUID;
        response.mapName = mapProxy.getMapName();
        response.size = mapProxy.size();
        response.keyType = mapProxy.getKeyType();
        response.keyNodeEdgeValueType = mapProxy.getKeyNodeEdgeValueType();
        response.valueType = mapProxy.getValueType();
        response.valueNodeEdgeValueType = mapProxy.getValueNodeEdgeValueType();
        String jsonString = JsonUtil.toJson((Object)((Object)response));
        return jsonString;
    }
}

