/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common.marshalers;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.io.IOException;
import oracle.pgx.api.SessionContext;
import oracle.pgx.api.internal.ComponentsProxy;
import oracle.pgx.common.marshalers.Marshaler;
import oracle.pgx.common.pojo.ComponentsProxyResponse;
import oracle.pgx.common.util.JsonUtil;
import oracle.pgx.common.util.RemoteComponentsProxyFactory;

public class ComponentsProxyMarshaler
implements Marshaler<ComponentsProxy> {
    private final SessionContext sessionContext;
    private final RemoteComponentsProxyFactory componentsProxyFactory;

    public ComponentsProxyMarshaler(SessionContext sessionContext, RemoteComponentsProxyFactory factory) {
        this.sessionContext = sessionContext;
        this.componentsProxyFactory = factory;
    }

    public ComponentsProxyMarshaler() {
        this(null, null);
    }

    @Override
    public ComponentsProxy unmarshal(String jsonString) throws JsonParseException, JsonMappingException, IOException {
        if (this.componentsProxyFactory == null) {
            throw new IllegalStateException("components proxy factory is not set");
        }
        if (this.sessionContext.getSessionId() == null) {
            throw new IllegalStateException("session is not set");
        }
        ComponentsProxyResponse response = (ComponentsProxyResponse)((Object)JsonUtil.readTopLevelJson((String)jsonString, ComponentsProxyResponse.class));
        return this.componentsProxyFactory.createRemoteComponentsProxy(this.sessionContext, response.proxyId, response.size, response.propertyId, response.componentNamespace);
    }

    @Override
    public String marshal(ComponentsProxy proxy) throws JsonGenerationException, JsonMappingException, IOException {
        ComponentsProxyResponse response = new ComponentsProxyResponse();
        response.proxyId = proxy.getId();
        response.size = proxy.size();
        response.propertyId = proxy.getPropertyId();
        response.componentNamespace = proxy.getComponentNamespace();
        String jsonString = JsonUtil.toJson((Object)((Object)response));
        return jsonString;
    }
}

