/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common;

import oracle.pgx.api.AlgorithmProgress;
import oracle.pgx.api.FutureProgress;
import oracle.pgx.api.internal.FutureProgressAccumulator;
import oracle.pgx.common.Progress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlgorithmExecutionState
implements FutureProgressAccumulator {
    private static final Logger LOG = LoggerFactory.getLogger(AlgorithmExecutionState.class);
    private long currentNumberOfStepsCompleted = 0L;
    private long numberOfStepsEstimatedForCompletion = -1L;

    @Override
    public FutureProgress getFutureProgress() {
        AlgorithmProgress progress = new AlgorithmProgress(this.currentNumberOfStepsCompleted, this.numberOfStepsEstimatedForCompletion == -1L ? null : Long.valueOf(this.numberOfStepsEstimatedForCompletion), Progress.PROCESSING);
        return progress;
    }

    public void updateNumberOfStepsCompleted() {
        ++this.currentNumberOfStepsCompleted;
    }

    public void updateNumberOfStepsCompleted(long val) {
        this.currentNumberOfStepsCompleted += val;
    }

    public long getCurrentNumberOfStepsCompleted() {
        return this.currentNumberOfStepsCompleted;
    }

    public void setNumberOfStepsEstimatedForCompletion(long val) {
        if (val <= 0L) {
            LOG.warn("Negative number of steps estimated for completion provided: {}", (Object)val);
            return;
        }
        if (this.numberOfStepsEstimatedForCompletion == -1L) {
            this.numberOfStepsEstimatedForCompletion = val;
            return;
        }
        if (val > this.numberOfStepsEstimatedForCompletion) {
            LOG.warn("the new provided value for number of steps estimated for completion is bigger than the previous onenew value: {}, old value: {}", (Object)val, (Object)this.numberOfStepsEstimatedForCompletion);
            return;
        }
        this.numberOfStepsEstimatedForCompletion = val;
    }
}

