/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.mllib;

import java.util.concurrent.ExecutionException;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import oracle.pgx.api.PgxFuture;
import oracle.pgx.api.PgxGraph;
import oracle.pgx.api.PgxSession;
import oracle.pgx.api.PgxVertex;
import oracle.pgx.api.frames.PgxFrame;
import oracle.pgx.api.frames.internal.PgxFrameImpl;
import oracle.pgx.api.internal.Core;
import oracle.pgx.api.internal.FrameMetaData;
import oracle.pgx.api.internal.Graph;
import oracle.pgx.api.internal.mllib.GnnExplanationMetaData;
import oracle.pgx.api.internal.mllib.ModelMetadata;
import oracle.pgx.api.internal.mllib.UnsupervisedGnnExplainerConfig;
import oracle.pgx.api.internal.mllib.UnsupervisedGraphWiseModelMetadata;
import oracle.pgx.api.mllib.FileModelStorer;
import oracle.pgx.api.mllib.GnnExplanation;
import oracle.pgx.api.mllib.GraphWiseModel;
import oracle.pgx.api.mllib.UnsupervisedGnnExplainer;
import oracle.pgx.api.mllib.UnsupervisedGnnExplanation;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.config.mllib.GraphWiseDgiLayerConfig;
import oracle.pgx.config.mllib.GraphWiseEmbeddingConfig;
import oracle.pgx.config.mllib.ModelKind;
import oracle.pgx.config.mllib.UnsupervisedGraphWiseModelConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnsupervisedGraphWiseModel
extends GraphWiseModel<UnsupervisedGraphWiseModelConfig, UnsupervisedGraphWiseModelMetadata, UnsupervisedGraphWiseModel> {
    public static final String ALGORITHM_NAME = "UnsupervisedGraphWise";
    private static final Logger LOG = LoggerFactory.getLogger(UnsupervisedGraphWiseModel.class);

    public UnsupervisedGraphWiseModel(PgxSession session, Core core, Supplier<String> keystorePathSupplier, Supplier<char[]> keystorePasswordSupplier, UnsupervisedGraphWiseModelMetadata modelMetadata, BiFunction<PgxSession, Graph, PgxGraph> graphConstructor) {
        super(session, core, keystorePathSupplier, keystorePasswordSupplier, modelMetadata, graphConstructor);
    }

    public UnsupervisedGraphWiseModel(PgxSession session, Core core, Supplier<String> keystorePathSupplier, Supplier<char[]> keystorePasswordSupplier, ModelMetadata modelMetadata, BiFunction<PgxSession, Graph, PgxGraph> graphConstructor) {
        super(session, core, keystorePathSupplier, keystorePasswordSupplier, null, graphConstructor);
        if (modelMetadata.getModelKind() != this.getModelKind()) {
            ErrorMessages.throwException(IllegalArgumentException::new, (String)"UNEXPECTED_MODEL_KIND", (Object[])new Object[]{this.getModelKind(), modelMetadata.getModelKind()});
        } else {
            this.modelMetadata = (UnsupervisedGraphWiseModelMetadata)modelMetadata;
        }
    }

    @Override
    protected UnsupervisedGraphWiseModel getThis() {
        return this;
    }

    @Override
    protected ModelKind getModelKind() {
        return ModelKind.UNSUPERVISED_GRAPHWISE;
    }

    @Override
    public PgxFuture<Double> fitAsync(PgxGraph graph) {
        return this.core.fitUnsupervisedGraphWiseModel(this.session.getSessionContext(), ((UnsupervisedGraphWiseModelMetadata)this.modelMetadata).getModelName(), graph.getId()).thenApply(metadata -> {
            this.modelMetadata = metadata;
            return ((UnsupervisedGraphWiseModelConfig)metadata.getConfig()).getTrainingLoss();
        });
    }

    @Override
    public PgxFuture<Double> fitAsync(PgxGraph trainGraph, PgxGraph valGraph) {
        return this.core.fitUnsupervisedGraphWiseModel(this.session.getSessionContext(), ((UnsupervisedGraphWiseModelMetadata)this.modelMetadata).getModelName(), trainGraph.getId(), valGraph.getId()).thenApply(metadata -> {
            this.modelMetadata = metadata;
            return ((UnsupervisedGraphWiseModelConfig)metadata.getConfig()).getTrainingLoss();
        });
    }

    @Override
    public PgxFuture<PgxFrame> getTrainingLogAsync() {
        return this.core.getTrainingLogUnsupervisedGraphWiseModel(this.session.getSessionContext(), ((UnsupervisedGraphWiseModelMetadata)this.modelMetadata).getModelName()).thenApply(frameMetaData -> new PgxFrameImpl(this.session, this.core, (FrameMetaData)((Object)frameMetaData), this.keystorePathSupplier, this.keystorePasswordSupplier));
    }

    @Override
    public <ID> PgxFuture<PgxFrame> inferEmbeddingsAsync(PgxGraph graph, Iterable<PgxVertex<ID>> vertices) {
        return this.core.inferEmbeddingsUnsupervisedGraphWiseModel(this.session.getSessionContext(), ((UnsupervisedGraphWiseModelMetadata)this.modelMetadata).getModelName(), graph.getId(), this.serializeVertices(vertices)).thenApply(frameMetaData -> new PgxFrameImpl(this.session, this.core, (FrameMetaData)((Object)frameMetaData), this.keystorePathSupplier, this.keystorePasswordSupplier));
    }

    @Deprecated
    public <ID> UnsupervisedGnnExplanation<ID> inferAndGetExplanation(PgxGraph graph, PgxVertex<ID> vertex, int numClusters) {
        return this.inferAndGetExplanationAsync(graph, vertex, numClusters).join();
    }

    @Deprecated
    public <ID> UnsupervisedGnnExplanation<ID> inferAndGetExplanation(PgxGraph graph, PgxVertex<ID> vertex) {
        return this.inferAndGetExplanationAsync(graph, vertex).join();
    }

    @Deprecated
    public <ID> PgxFuture<UnsupervisedGnnExplanation<ID>> inferAndGetExplanationAsync(PgxGraph graph, PgxVertex<ID> vertex) {
        return this.inferAndGetExplanationAsync(graph, vertex, 50);
    }

    @Deprecated
    public <ID> PgxFuture<UnsupervisedGnnExplanation<ID>> inferAndGetExplanationAsync(PgxGraph graph, PgxVertex<ID> vertex, int numClusters) {
        UnsupervisedGnnExplainerConfig explainerConfig = new UnsupervisedGnnExplainerConfig();
        explainerConfig.setNumClusters(numClusters);
        return this.inferAndExplainWithConfigAsync(graph, vertex, explainerConfig);
    }

    <ID> PgxFuture<UnsupervisedGnnExplanation<ID>> inferAndExplainWithConfigAsync(PgxGraph graph, PgxVertex<ID> vertex, UnsupervisedGnnExplainerConfig config) {
        long numVertices = graph.getNumVertices();
        int numClusters = config.getNumClusters();
        if ((long)numClusters > numVertices) {
            LOG.warn("Setting number of clusters used for explanation to {} instead of {} as graph only has {} vertices.", new Object[]{numVertices, numClusters, numVertices});
            config.setNumClusters((int)numVertices);
        }
        if (numClusters < 2) {
            throw new IllegalStateException(ErrorMessages.getMessage((String)"NOT_ENOUGH_CLUSTERS_FOR_EXPLANATION", (Object[])new Object[0]));
        }
        return this.core.inferAndGetExplanationUnsupervisedGraphWiseModel(this.session.getSessionContext(), ((UnsupervisedGraphWiseModelMetadata)this.modelMetadata).getModelName(), graph.getId(), vertex.serialize(), config).thenApply(gnnExplanationResult -> {
            GnnExplanation explanation = this.processExplanationResult(graph, (GnnExplanationMetaData)gnnExplanationResult);
            return new UnsupervisedGnnExplanation(explanation.getVertexFeatureImportance(), explanation.getImportanceGraph(), explanation.getVertexImportanceProperty(), explanation.getEmbedding());
        });
    }

    public UnsupervisedGnnExplainer gnnExplainer() {
        return new UnsupervisedGnnExplainer(this);
    }

    public PgxFuture<Void> storeAsync(String path, String key) throws ExecutionException, InterruptedException {
        return this.storeAsync(path, key, false);
    }

    public PgxFuture<Void> storeAsync(String path, String key, boolean overwrite) {
        return ((FileModelStorer)this.export().file().path(path).key(key).overwrite(overwrite)).storeAsync();
    }

    public void store(String path, String key) throws ExecutionException, InterruptedException {
        this.storeAsync(path, key).get();
    }

    public void store(String path, String key, boolean overwrite) throws ExecutionException, InterruptedException {
        this.storeAsync(path, key, overwrite).get();
    }

    public UnsupervisedGraphWiseModelConfig.LossFunction getLossFunction() {
        return ((UnsupervisedGraphWiseModelConfig)this.getConfig()).getLossFunction();
    }

    @Deprecated
    public GraphWiseDgiLayerConfig getDgiLayerConfigs() {
        return ((UnsupervisedGraphWiseModelConfig)this.getConfig()).getDgiLayerConfig();
    }

    public GraphWiseEmbeddingConfig getEmbeddingConfig() {
        return ((UnsupervisedGraphWiseModelConfig)this.getConfig()).getEmbeddingConfig();
    }

    public static enum UnsupervisedGraphWiseInferenceType {
        INFER_EMBEDDINGS;

    }
}

