/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.mllib;

import java.util.concurrent.ExecutionException;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import oracle.pgx.api.PgxFuture;
import oracle.pgx.api.PgxGraph;
import oracle.pgx.api.PgxSession;
import oracle.pgx.api.internal.Core;
import oracle.pgx.api.internal.Graph;
import oracle.pgx.api.internal.mllib.UnsupervisedGraphWiseModelMetadata;
import oracle.pgx.api.mllib.GraphWiseModelBuilder;
import oracle.pgx.api.mllib.SupervisedGraphWiseModelBuilder;
import oracle.pgx.api.mllib.UnsupervisedAnomalyDetectionGraphWiseModel;
import oracle.pgx.config.mllib.GraphWiseEmbeddingConfig;
import oracle.pgx.config.mllib.UnsupervisedGraphWiseModelConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnsupervisedAnomalyDetectionGraphWiseModelBuilder
extends GraphWiseModelBuilder<UnsupervisedAnomalyDetectionGraphWiseModel, UnsupervisedGraphWiseModelConfig, UnsupervisedAnomalyDetectionGraphWiseModelBuilder> {
    private static final Logger LOG = LoggerFactory.getLogger(SupervisedGraphWiseModelBuilder.class);
    private final PgxSession session;
    private final Core core;
    private final Supplier<String> keystorePathSupplier;
    private final Supplier<char[]> keystorePasswordSupplier;
    private final BiFunction<PgxSession, Graph, PgxGraph> graphConstructor;

    public UnsupervisedAnomalyDetectionGraphWiseModelBuilder(PgxSession session, Core core, Supplier<String> keystorePathSupplier, Supplier<char[]> keystorePasswordSupplier, BiFunction<PgxSession, Graph, PgxGraph> graphConstructor) {
        this.session = session;
        this.core = core;
        this.keystorePathSupplier = keystorePathSupplier;
        this.keystorePasswordSupplier = keystorePasswordSupplier;
        this.modelConfig = new UnsupervisedGraphWiseModelConfig();
        this.graphConstructor = graphConstructor;
    }

    public UnsupervisedAnomalyDetectionGraphWiseModelBuilder setEmbeddingConfig(GraphWiseEmbeddingConfig embeddingConfig) {
        ((UnsupervisedGraphWiseModelConfig)this.modelConfig).setEmbeddingConfig(embeddingConfig);
        return this;
    }

    public UnsupervisedAnomalyDetectionGraphWiseModelBuilder setLossFunction(UnsupervisedGraphWiseModelConfig.LossFunction lossFunction) {
        ((UnsupervisedGraphWiseModelConfig)this.modelConfig).setLossFunction(lossFunction);
        return this;
    }

    @Override
    public UnsupervisedAnomalyDetectionGraphWiseModel build() throws InterruptedException, ExecutionException {
        super.validateAll();
        LOG.debug("Building Model...");
        UnsupervisedGraphWiseModelMetadata metadata = new UnsupervisedGraphWiseModelMetadata(null, (UnsupervisedGraphWiseModelConfig)this.modelConfig);
        return (UnsupervisedAnomalyDetectionGraphWiseModel)((PgxFuture)this.core.createUnsupervisedGraphWiseModel(this.session.getSessionContext(), metadata).thenApply(metaData -> new UnsupervisedAnomalyDetectionGraphWiseModel(this.session, this.core, this.keystorePathSupplier, this.keystorePasswordSupplier, (UnsupervisedGraphWiseModelMetadata)((Object)metaData), this.graphConstructor))).get();
    }

    @Override
    protected UnsupervisedAnomalyDetectionGraphWiseModelBuilder getThis() {
        return this;
    }
}

