/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.internal;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import oracle.pgx.api.EdgeProviderMetaData;
import oracle.pgx.api.EntityProviderMetaData;
import oracle.pgx.api.GraphMetaData;
import oracle.pgx.api.Namespace;
import oracle.pgx.api.PropertyMetaData;
import oracle.pgx.api.VertexProviderMetaData;
import oracle.pgx.api.internal.CollectByNamespace;
import oracle.pgx.api.internal.EdgeTable;
import oracle.pgx.api.internal.EntityTable;
import oracle.pgx.api.internal.Property;
import oracle.pgx.api.internal.VertexTable;
import oracle.pgx.common.Link;
import oracle.pgx.common.LinkRel;
import oracle.pgx.common.PgxId;
import oracle.pgx.common.Self;
import oracle.pgx.common.types.IdType;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.common.util.PrettyPrint;
import oracle.pgx.config.LinkTemplate;

public class Graph
extends Self {
    private static final PgxId DEFAULT_ID = new PgxId(UUID.nameUUIDFromBytes("default".getBytes()));
    private String graphName;
    private Map<String, VertexTable> vertexTables;
    private Map<String, EdgeTable> edgeTables;
    private GraphMetaData metaData;
    @JsonProperty(value="transient")
    private boolean transientFlag;
    @JsonProperty(value="partitioned")
    private boolean partitionedFlag = false;
    private long ageMs;

    public Graph() {
        this(DEFAULT_ID, "emptyGraph", false, null);
    }

    public Graph(PgxId graphId, String graphName, boolean transientFlag, URI baseUri) {
        this(graphId, graphName, new GraphMetaData(IdType.INTEGER, IdType.LONG), Collections.emptyMap(), Collections.emptyMap(), transientFlag);
    }

    public Graph(PgxId graphId, String graphName, GraphMetaData metaData, boolean transientFlag) {
        this(graphId, graphName, metaData, Collections.emptyMap(), Collections.emptyMap(), transientFlag);
    }

    public Graph(PgxId graphId, String graphName, GraphMetaData metaData, Map<String, VertexTable> vertexTables, Map<String, EdgeTable> edgeTables, boolean transientFlag) {
        this.setId(graphId.toString());
        this.graphName = graphName;
        this.metaData = metaData;
        this.transientFlag = transientFlag;
        this.vertexTables = new HashMap<String, VertexTable>(vertexTables);
        this.edgeTables = new HashMap<String, EdgeTable>(edgeTables);
        this.injectLinks();
    }

    public void fixMetaData() {
        if (this.metaData == null) {
            return;
        }
        Map<String, VertexProviderMetaData> vertexProviderMetaDataMap = this.metaData.getVertexProvidersMetaData();
        this.getVertexTables().forEach((name, table) -> {
            EntityProviderMetaData providerMetaData = (EntityProviderMetaData)((Object)((Object)vertexProviderMetaDataMap.get(name)));
            this.fixPropertyMetaData(providerMetaData, table.getProperties());
        });
        Map<String, EdgeProviderMetaData> edgeProviderMetaDataMap = this.metaData.getEdgeProvidersMetaData();
        this.getEdgeTables().forEach((name, table) -> {
            EntityProviderMetaData providerMetaData = (EntityProviderMetaData)((Object)((Object)edgeProviderMetaDataMap.get(name)));
            this.fixPropertyMetaData(providerMetaData, table.getProperties());
        });
    }

    private void fixPropertyMetaData(EntityProviderMetaData providerMetaData, LinkedHashMap<PgxId, Property> properties) {
        if (providerMetaData == null) {
            return;
        }
        HashMap propertyMetaData = new HashMap();
        properties.forEach((id, prop) -> propertyMetaData.put(id, new PropertyMetaData(prop.getName(), (PgxId)id, prop.getType(), prop.getDimension(), prop.isTransient())));
        providerMetaData.setProperties(new ArrayList<PropertyMetaData>(propertyMetaData.values()));
    }

    @JsonIgnore
    public PgxId getGraphId() {
        return PgxId.fromString((String)this.getId());
    }

    public long getAgeMs() {
        return this.ageMs;
    }

    public void setAgeMs(long ageMs) {
        this.ageMs = ageMs;
    }

    public boolean isTransient() {
        return this.transientFlag;
    }

    public void setTransient(boolean transientFlag) {
        this.transientFlag = transientFlag;
    }

    public boolean isPartitioned() {
        return this.isMultiTable() || this.vertexTables.size() == 1 && !this.vertexTables.containsKey("V") || this.edgeTables.size() == 1 && !this.edgeTables.containsKey("E");
    }

    private void throwIfMultiTable() {
        if (this.isMultiTable()) {
            throw new UnsupportedOperationException(ErrorMessages.getMessage((String)"UNSUPPORTED_OP_ON_PARTITIONED_GRAPH", (Object[])new Object[0]));
        }
    }

    public void setPartitioned(boolean partitionedFlag) {
        this.partitionedFlag = partitionedFlag;
    }

    public String getGraphName() {
        return this.graphName;
    }

    public void setGraphName(String graphName) {
        this.graphName = graphName;
    }

    public GraphMetaData getMetaData() {
        return this.metaData;
    }

    public void setMetaData(GraphMetaData metaData) {
        this.metaData = metaData;
    }

    public String toString() {
        return PrettyPrint.prettify((Object)this);
    }

    public void injectLinks() {
        Link selfLink = new Link(LinkRel.SELF, LinkTemplate.GRAPH_SELF.generateLink(new Object[0]));
        this.addLinks(new Link[]{selfLink});
    }

    @JsonIgnore
    private boolean isMultiTable() {
        return this.vertexTables.size() > 1 || this.edgeTables.size() > 1;
    }

    @JsonIgnore
    public VertexTable getMainVertexTable() {
        this.throwIfMultiTable();
        return this.vertexTables.get("V");
    }

    @JsonIgnore
    public EdgeTable getMainEdgeTable() {
        this.throwIfMultiTable();
        return this.edgeTables.get("E");
    }

    public void addVertexTable(String name, VertexTable table) {
        this.vertexTables.put(name, table);
    }

    public Map<String, VertexTable> getVertexTables() {
        return this.vertexTables;
    }

    public void setVertexTables(Map<String, VertexTable> tables) {
        this.vertexTables = tables;
    }

    public void addEdgeTable(String name, EdgeTable table) {
        this.edgeTables.put(name, table);
    }

    public Map<String, EdgeTable> getEdgeTables() {
        return this.edgeTables;
    }

    public void setEdgeTables(Map<String, EdgeTable> tables) {
        this.edgeTables = tables;
    }

    @JsonIgnore
    public Set<String> getVertexPropertyNames() {
        return this.getAllVertexProperties().stream().map(Property::getName).collect(Collectors.toSet());
    }

    @JsonIgnore
    public Set<PgxId> getVertexPropertyIds() {
        return this.getAllVertexProperties().stream().map(Property::getPropertyId).collect(Collectors.toSet());
    }

    @JsonIgnore
    public LinkedHashMap<PgxId, Property> getVertexProperties() {
        this.throwIfMultiTable();
        return this.getMainVertexTable().getVertexProperties();
    }

    @JsonIgnore
    public Set<Property> getAllVertexProperties() {
        return this.getAllPropertiesAcrossTables(this.getVertexTables().values());
    }

    @JsonIgnore
    public void setVertexProperties(LinkedHashMap<PgxId, Property> nodeProps) {
        this.throwIfMultiTable();
        this.getMainVertexTable().setVertexProperties(nodeProps);
    }

    @JsonIgnore
    public void addVertexProperty(PgxId id, Property pr) {
        this.throwIfMultiTable();
        this.getMainVertexTable().addVertexProperty(id, pr);
    }

    @JsonIgnore
    public boolean hasVertexLabels() {
        return this.getVertexTables().values().stream().anyMatch(vt -> vt.getVertexLabels() != null);
    }

    @JsonIgnore
    public Property getVertexLabels() {
        Set<Property> vertexLabelsInAllTables = this.getVertexTables().values().stream().map(VertexTable::getVertexLabels).filter(Objects::nonNull).collect(Collectors.toSet());
        return this.getMergedProperty("__vertex_labels__", vertexLabelsInAllTables);
    }

    @JsonIgnore
    public void setVertexLabels(Property pr) {
        this.throwIfMultiTable();
        this.getMainVertexTable().setVertexLabels(pr);
    }

    @JsonIgnore
    public Set<String> getEdgePropertyNames() {
        return this.getAllEdgeProperties().stream().map(Property::getName).collect(Collectors.toSet());
    }

    @JsonIgnore
    public Set<PgxId> getEdgePropertyIds() {
        return this.getAllEdgeProperties().stream().map(Property::getPropertyId).collect(Collectors.toSet());
    }

    @JsonIgnore
    public LinkedHashMap<PgxId, Property> getEdgeProperties() {
        this.throwIfMultiTable();
        return this.getMainEdgeTable().getEdgeProperties();
    }

    @JsonIgnore
    public Set<Property> getAllEdgeProperties() {
        return this.getAllPropertiesAcrossTables(this.getEdgeTables().values());
    }

    @JsonIgnore
    private <T extends EntityTable> Set<Property> getAllPropertiesAcrossTables(Collection<T> tables) {
        HashSet<Property> allProperties = new HashSet<Property>();
        for (EntityTable table : tables) {
            allProperties.addAll(table.getProperties().values());
        }
        return allProperties;
    }

    @JsonIgnore
    public Property getEdgeProperty(Namespace namespace, String propertyName) {
        return this.getProperty(namespace, propertyName, this.getEdgeTables().values());
    }

    @JsonIgnore
    public Property getVertexProperty(Namespace namespace, String propertyName) {
        return this.getProperty(namespace, propertyName, this.getVertexTables().values());
    }

    private <T extends EntityTable> Property getProperty(@Nullable Namespace namespace, String propertyName, Collection<T> tables) {
        HashSet<Property> propertyInAllTables = new HashSet<Property>();
        for (EntityTable table : tables) {
            table.getProperties().values().stream().filter(p -> Objects.equals(propertyName, p.getName())).collect(CollectByNamespace.collectByNamespace(namespace)).ifPresent(propertyInAllTables::add);
        }
        return this.getMergedProperty(propertyName, propertyInAllTables);
    }

    private Property getMergedProperty(String propertyName, Set<Property> propertyInAllTables) {
        if (propertyInAllTables.size() == 0) {
            return null;
        }
        if (propertyInAllTables.size() > 1) {
            throw new IllegalStateException(ErrorMessages.getMessage((String)"INCOMPATIBLE_PROP_TYPES", (Object[])new Object[]{propertyName}));
        }
        return propertyInAllTables.iterator().next();
    }

    @JsonIgnore
    public void setEdgeProperties(LinkedHashMap<PgxId, Property> edgeProps) {
        this.throwIfMultiTable();
        this.getMainEdgeTable().setEdgeProperties(edgeProps);
    }

    @JsonIgnore
    public void addEdgeProperty(PgxId id, Property pr) {
        this.throwIfMultiTable();
        this.getMainEdgeTable().addEdgeProperty(id, pr);
    }

    @JsonIgnore
    public boolean hasEdgeLabel() {
        return this.getEdgeTables().values().stream().anyMatch(et -> et.getEdgeLabel() != null);
    }

    @JsonIgnore
    public Property getEdgeLabel() {
        Set<Property> edgeLabelsInAllTables = this.getEdgeTables().values().stream().map(EdgeTable::getEdgeLabel).filter(Objects::nonNull).collect(Collectors.toSet());
        return this.getMergedProperty("__edge_label__", edgeLabelsInAllTables);
    }

    @JsonIgnore
    public void setEdgeLabel(Property pr) {
        this.throwIfMultiTable();
        this.getMainEdgeTable().setEdgeLabel(pr);
    }
}

