/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.internal;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Objects;
import oracle.pgx.api.internal.ElementChanges;
import oracle.pgx.common.util.ErrorMessages;

public final class EdgeChanges
extends ElementChanges {
    private Object elementId;
    protected Object srcId;
    protected Object dstId;
    private String labelChange;

    private EdgeChanges() {
    }

    EdgeChanges(Object elementId) {
        this(elementId, null, null);
    }

    EdgeChanges(Object elementId, Object srcId, Object dstId) {
        this.elementId = elementId;
        this.srcId = srcId;
        this.dstId = dstId;
    }

    public void setSrcId(Object srcId) {
        this.srcId = srcId;
    }

    public void setDstId(Object dstId) {
        this.dstId = dstId;
    }

    private void setLabelChange(String labelChange) {
        this.labelChange = labelChange;
    }

    public void setLabel(String label) {
        if (label == null) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"NULL_LABEL_VALUE", (Object[])new Object[0]));
        }
        this.labelChange = label;
    }

    public Object getSrcId() {
        return this.srcId;
    }

    public Object getDstId() {
        return this.dstId;
    }

    @JsonIgnore
    public boolean isComplete() {
        return this.srcId != null && this.dstId != null;
    }

    public String getLabelChange() {
        return this.labelChange;
    }

    @Override
    public String toString() {
        return "EdgeChanges{" + super.toString() + ", srcId=" + this.srcId + ", dstId=" + this.dstId + ", labelChange='" + this.labelChange + '\'' + '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EdgeChanges that = (EdgeChanges)o;
        return Objects.equals(this.srcId, that.srcId) && Objects.equals(this.dstId, that.dstId) && Objects.equals(this.labelChange, that.labelChange);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.srcId, this.dstId, this.labelChange);
    }

    private void setId(Object elementId) {
        this.elementId = elementId;
    }

    public Object getId() {
        return this.elementId;
    }
}

