/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.frames;

import java.util.function.Supplier;
import oracle.pgx.api.PgxFuture;
import oracle.pgx.api.PgxSession;
import oracle.pgx.api.frames.PgxFrame;
import oracle.pgx.api.frames.PgxFrameStorer;
import oracle.pgx.api.internal.Core;
import oracle.pgx.common.types.PropertyType;
import oracle.pgx.config.EntityProviderConfig;
import oracle.pgx.config.RdbmsEntityProviderConfig;
import oracle.pgx.config.RdbmsEntityProviderConfigBuilder;

public class PgxDbFrameStorer
extends PgxFrameStorer<PgxDbFrameStorer> {
    protected final RdbmsEntityProviderConfigBuilder configBuilder = new RdbmsEntityProviderConfigBuilder();

    public PgxDbFrameStorer(PgxSession session, Core core, PgxFrame frame, Supplier<String> keystorePathSupplier, Supplier<char[]> keystorePasswordSupplier) {
        super(session, core, frame, keystorePathSupplier, keystorePasswordSupplier);
        this.configBuilder.setHasKeys(false);
    }

    @Override
    protected PgxDbFrameStorer getThis() {
        return this;
    }

    @Override
    protected PgxDbFrameStorer withVectorColumn(String columnName, PropertyType type, int dimension, Object defaultValue) {
        this.configBuilder.addVectorProperty(columnName, type, dimension, defaultValue);
        return this;
    }

    @Override
    public PgxDbFrameStorer name(String frameName) {
        this.configBuilder.setName(frameName);
        return this;
    }

    public PgxDbFrameStorer tablename(String tableName) {
        this.configBuilder.setDatabaseTableName(tableName);
        return this;
    }

    public PgxDbFrameStorer dataSourceId(String dataSourceId) {
        this.configBuilder.setDataSourceId(dataSourceId);
        return this;
    }

    public PgxDbFrameStorer jdbcUrl(String jdbcUrl) {
        this.configBuilder.setJdbcUrl(jdbcUrl);
        return this;
    }

    public PgxDbFrameStorer username(String userName) {
        this.configBuilder.setUsername(userName);
        return this;
    }

    public PgxDbFrameStorer keystoreAlias(String keystoreAlias) {
        this.configBuilder.setKeystoreAlias(keystoreAlias);
        return this;
    }

    public PgxDbFrameStorer password(String password) {
        this.configBuilder.setPassword(password);
        return this;
    }

    public PgxDbFrameStorer schema(String schema) {
        this.configBuilder.setSchema(schema);
        return this;
    }

    public PgxDbFrameStorer owner(String owner) {
        return this.schema(owner);
    }

    public PgxDbFrameStorer connections(int numConnections) {
        this.configBuilder.setNumConnections(numConnections);
        return this;
    }

    @Override
    public PgxFuture<Void> storeAsync(String ... uris) {
        this.configBuilder.setName(this.frame.getMetaData().getFrameUid().toString());
        RdbmsEntityProviderConfig config = (RdbmsEntityProviderConfig)this.configBuilder.build();
        return this.triggerStoreAsync((EntityProviderConfig)config);
    }
}

