/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api;

import java.util.Collection;
import java.util.Iterator;
import oracle.pgx.api.PgxCollection;
import oracle.pgx.api.PgxEntity;
import oracle.pgx.api.PgxFuture;
import oracle.pgx.api.PgxSession;
import oracle.pgx.api.ScalarSequence;
import oracle.pgx.api.ScalarSet;
import oracle.pgx.api.internal.CollectionProxy;
import oracle.pgx.common.IllegalEnumConstantException;
import oracle.pgx.common.PgxId;
import oracle.pgx.common.types.CollectionType;
import oracle.pgx.common.types.IdType;
import oracle.pgx.common.types.PropertyType;

public abstract class ScalarCollection<E>
extends PgxCollection<E, Void> {
    ScalarCollection(PgxSession session, PgxId collectionId, String collectionName, CollectionType type, PropertyType contentType) {
        super(session, collectionId, collectionName, type, contentType);
    }

    @Override
    public final PgxFuture<Void> addAllElementsAsync(Collection<E> source) {
        return this.core.addAllToCollection(this.getSessionContext(), this.getId(), source).thenReturn(null);
    }

    @Override
    public final PgxFuture<Void> removeAllElementsAsync(Collection<E> source) {
        return this.core.removeAllFromCollection(this.getSessionContext(), this.getId(), source).thenReturn(null);
    }

    @Override
    public final PgxFuture<Boolean> containsAsync(E element) {
        return this.core.containsElement(this.getSessionContext(), this.getId(), element);
    }

    @Override
    public String toString() {
        return this.toString(ScalarCollection.entry("name", this.getName()), ScalarCollection.entry("session", this.getSession().getName()));
    }

    @Override
    public IdType getIdType() {
        return null;
    }

    @Override
    public void addAll(PgxEntity[] elements) {
        throw new UnsupportedOperationException();
    }

    public void addAllElements(ScalarCollection source) {
        Iterator<Object> iterator = source.getProxy().iterator();
        while (iterator.hasNext()) {
            this.add(iterator.next());
        }
    }

    public void removeAllElements(ScalarCollection source) {
        Iterator<Object> iterator = source.getProxy().iterator();
        while (iterator.hasNext()) {
            this.remove(iterator.next());
        }
    }

    @Override
    protected PgxCollection.AbstractProxyIterator<E> newProxyIterator(CollectionProxy proxy) {
        return new ScalarCollectionProxyIterator(this.getSession(), proxy);
    }

    static <E> ScalarCollection<E> createFromNameAndTypes(PgxSession session, PgxId collectionId, String collectionName, CollectionType collectionType, PropertyType contentType) {
        switch (collectionType) {
            case SET: {
                return new ScalarSet(session, collectionId, collectionName, contentType);
            }
            case SEQUENCE: {
                return new ScalarSequence(session, collectionId, collectionName, contentType);
            }
        }
        throw new IllegalEnumConstantException((Enum)collectionType);
    }

    protected static final class ScalarCollectionProxyIterator<E>
    extends PgxCollection.AbstractProxyIterator<E> {
        protected final PgxSession session;

        ScalarCollectionProxyIterator(PgxSession session, CollectionProxy proxy) {
            super(proxy);
            this.session = session;
        }

        @Override
        public boolean hasNext() {
            return this.wrapped.hasNext();
        }

        @Override
        public E next() {
            return this.wrapped.next();
        }

        @Override
        public void remove() {
            this.wrapped.remove();
        }
    }
}

