/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Singleton;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import oracle.pgx.api.PgxSession;
import oracle.pgx.api.ServerInstance;
import oracle.pgx.api.internal.ApiProvider;
import oracle.pgx.api.internal.ApiProviderClassFactory;
import oracle.pgx.api.internal.RealmClientFactory;
import oracle.pgx.api.internal.ServerInstanceHolder;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.config.ClientConfig;
import oracle.pgx.config.ClientConfigBuilder;
import oracle.pgx.realm.client.RealmClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Pgx {
    public static final String EMBEDDED_URL = null;
    public static final String DIST_URL = "DIST";
    private static final AtomicReference<String> DEFAULT_URL = new AtomicReference<String>(System.getProperty("pgxDefaultUrl", EMBEDDED_URL));
    private static final Logger LOG = LoggerFactory.getLogger(Pgx.class);

    public static void setDefaultUrl(String url) {
        DEFAULT_URL.set(url);
    }

    public static String getDefaultUrl() {
        return DEFAULT_URL.get();
    }

    public static ApiProvider getProviderFor(String url) {
        Injector injector = url == EMBEDDED_URL ? EmbeddedApiInjector.INJECTOR : RemoteApiInjector.INJECTOR;
        return (ApiProvider)injector.getInstance(ApiProvider.class);
    }

    static RealmClient getRealmClientFor(ClientConfig config) {
        return new RealmClientFactory(config.getBaseUrl() == EMBEDDED_URL, config).provide();
    }

    public static ServerInstance getInstance() throws ExecutionException, InterruptedException {
        return Pgx.getInstance(Pgx.getDefaultUrl());
    }

    public static ServerInstance getInstance(String baseUrl) {
        ClientConfigBuilder builder = ClientConfigBuilder.forBaseUrl(baseUrl);
        return Pgx.getInstance(builder.build());
    }

    public static ServerInstance getInstance(String baseUrl, String token) {
        ClientConfig clientConfig = ClientConfigBuilder.forBaseUrl(baseUrl).setAccessToken(token).build();
        return Pgx.getInstance(clientConfig);
    }

    public static ServerInstance getInstance(String baseUrl, RealmClient realmClient) {
        ClientConfig clientConfig = ClientConfigBuilder.forBaseUrl(baseUrl).build();
        return Pgx.getInstance(clientConfig, realmClient);
    }

    public static ServerInstance getInstance(ClientConfig config) {
        Pgx.checkBaseUrl(config);
        return ServerInstanceHolder.set(new ServerInstance(config));
    }

    public static ServerInstance getInstance(ClientConfig config, RealmClient realmClient) {
        Pgx.checkBaseUrl(config);
        return ServerInstanceHolder.set(new ServerInstance(config, realmClient));
    }

    private static void checkBaseUrl(ClientConfig config) {
        String baseUrl = config.getBaseUrl();
        if (baseUrl != null && baseUrl.startsWith("http://") && !baseUrl.startsWith("https://")) {
            LOG.warn(ErrorMessages.getMessage((String)"TLS_DISABLED_CLIENT", (Object[])new Object[0]));
        }
    }

    public static PgxSession createSession(String baseUrl, String source) throws ExecutionException, InterruptedException {
        return Pgx.getInstance(baseUrl).createSession(source);
    }

    public static PgxSession createSession(String source) throws ExecutionException, InterruptedException {
        return Pgx.createSession(Pgx.getDefaultUrl(), source);
    }

    private static final class RemoteApiInjector {
        static final Injector INJECTOR = Guice.createInjector((Module[])new Module[]{new ApiProviderModule("remote", "oracle.pgx.api.ClientApiProvider")});

        private RemoteApiInjector() {
        }
    }

    private static final class EmbeddedApiInjector {
        static final Injector INJECTOR = Guice.createInjector((Module[])new Module[]{new ApiProviderModule("embedded", "oracle.pgx.api.EmbeddedApiProvider")});

        private EmbeddedApiInjector() {
        }
    }

    private static class ApiProviderModule
    extends AbstractModule {
        private final Class<ApiProvider> providerClass;

        ApiProviderModule(String modeName, String className) {
            this.providerClass = ApiProviderClassFactory.provideClass(modeName, className);
        }

        protected void configure() {
            this.bind(ApiProvider.class).to(this.providerClass).in(Singleton.class);
        }
    }
}

