/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.internal;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import oracle.pgx.api.PgxVect;
import oracle.pgx.api.internal.Entity;
import oracle.pgx.common.Link;
import oracle.pgx.common.LinkRel;
import oracle.pgx.common.Self;
import oracle.pgx.common.types.IdType;
import oracle.pgx.common.types.PropertyType;
import oracle.pgx.common.util.JsonUtil;
import oracle.pgx.common.util.internal.EntityDeserializationHelper;
import oracle.pgx.config.LinkTemplate;

public class ScalarValue<V>
extends Self {
    private V value;
    private Boolean isValueWrapped;
    private final String scalarName;
    private PropertyType valueType;
    private IdType nodeEdgeValueType;
    private boolean isVector;

    public ScalarValue() {
        this.scalarName = null;
    }

    public ScalarValue(V value, PropertyType valueType) {
        this.scalarName = null;
        this.setValue(value);
        this.valueType = valueType;
        this.isVector = value instanceof PgxVect;
    }

    public ScalarValue(String scalarName, PropertyType valueType, IdType nodeEdgeValueType, V value, boolean isVector) {
        super((Object)scalarName);
        this.value = value;
        this.nodeEdgeValueType = nodeEdgeValueType;
        this.valueType = valueType;
        this.isVector = isVector;
        this.scalarName = scalarName;
        this.injectLinks();
    }

    public void setVector(boolean vector) {
        this.isVector = vector;
    }

    public V getValue() {
        return this.value;
    }

    public void setValue(V value) {
        this.value = value;
        this.isValueWrapped = value instanceof Entity;
    }

    public void setValueWrapped(Boolean value) {
        this.isValueWrapped = value;
    }

    public Boolean isValueWrapped() {
        return this.isValueWrapped;
    }

    public PropertyType getValueType() {
        return this.valueType;
    }

    public boolean isVector() {
        return this.isVector;
    }

    public void setValueType(PropertyType valueType) {
        this.valueType = valueType;
    }

    public IdType getNodeEdgeValueType() {
        return this.nodeEdgeValueType;
    }

    public void setNodeEdgeValueType(IdType nodeEdgeValueType) {
        this.nodeEdgeValueType = nodeEdgeValueType;
    }

    @JsonIgnore
    public Class<?> getTypeClass() {
        if (this.isVector) {
            return PgxVect.class;
        }
        if (this.valueType == PropertyType.VERTEX || this.valueType == PropertyType.EDGE) {
            return this.nodeEdgeValueType.getTypeClass();
        }
        return this.valueType.getTypeClass();
    }

    @JsonIgnore
    public Object getParsedValue() throws IOException {
        if (this.value == null) {
            return null;
        }
        String json = JsonUtil.sanitize((String)JsonUtil.toJson(this.value));
        if (Boolean.TRUE.equals(this.isValueWrapped)) {
            return EntityDeserializationHelper.deserializeEntityOrKey((JsonNode)JsonUtil.readTopLevelJsonToTree((String)json)).getLeft().get();
        }
        return JsonUtil.readValue((String)json, this.getTypeClass());
    }

    public void injectLinks() {
        Link selfLink = new Link(LinkRel.SELF, LinkTemplate.SCALAR_VALUE_SELF.generateLink(new Object[0]));
        this.addLinks(new Link[]{selfLink});
    }
}

