/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.internal;

import java.net.URI;
import java.util.LinkedHashMap;
import oracle.pgx.api.internal.FrameColumnMetaData;
import oracle.pgx.common.Link;
import oracle.pgx.common.LinkRel;
import oracle.pgx.common.PgxId;
import oracle.pgx.common.Self;
import oracle.pgx.common.util.PrettyPrint;
import oracle.pgx.config.EntityProviderConfig;
import oracle.pgx.config.GraphPropertyConfig;
import oracle.pgx.config.LinkTemplate;

public class FrameMetaData
extends Self {
    private PgxId frameUid;
    private LinkedHashMap<String, FrameColumnMetaData> columnMetaDataMap;

    private static LinkedHashMap<String, FrameColumnMetaData> extractColumnMetaData(URI baseUri, PgxId frameId, EntityProviderConfig config) {
        LinkedHashMap<String, FrameColumnMetaData> columnMetaDataMap = new LinkedHashMap<String, FrameColumnMetaData>();
        for (GraphPropertyConfig propertyConfig : config.getProps()) {
            String propertyName = propertyConfig.getName();
            FrameColumnMetaData columnMetaData = new FrameColumnMetaData(frameId, propertyName, propertyConfig.getType(), propertyConfig.getDimension());
            columnMetaDataMap.put(propertyName, columnMetaData);
        }
        return columnMetaDataMap;
    }

    public FrameMetaData() {
    }

    public FrameMetaData(URI baseUri, PgxId frameId, EntityProviderConfig config) {
        super((Object)frameId);
        this.frameUid = frameId;
        this.columnMetaDataMap = FrameMetaData.extractColumnMetaData(baseUri, frameId, config);
        this.injectLinks();
    }

    public PgxId getFrameUid() {
        return this.frameUid;
    }

    public void setFrameUid(PgxId frameUid) {
        this.frameUid = frameUid;
    }

    public LinkedHashMap<String, FrameColumnMetaData> getColumnMetaDataMap() {
        return this.columnMetaDataMap;
    }

    public void setColumnMetaDataMap(LinkedHashMap<String, FrameColumnMetaData> columnMetaDataMap) {
        this.columnMetaDataMap = columnMetaDataMap;
    }

    public String toString() {
        return PrettyPrint.prettify((Object)this);
    }

    public void injectLinks() {
        Link selfLink = new Link(LinkRel.SELF, LinkTemplate.FRAME_SELF.generateLink(new Object[0]));
        this.addLinks(new Link[]{selfLink});
    }
}

