/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.stream.Collectors;
import oracle.pgx.api.PgxCollection;
import oracle.pgx.api.PgxEntity;
import oracle.pgx.api.PgxFuture;
import oracle.pgx.api.PgxGraph;
import oracle.pgx.api.internal.CollectionProxy;
import oracle.pgx.common.PgxId;
import oracle.pgx.common.types.CollectionType;
import oracle.pgx.common.types.EntityType;
import oracle.pgx.common.util.ErrorMessages;

public abstract class GraphEntityCollection<E extends PgxEntity<ID>, ID>
extends PgxCollection<E, ID> {
    GraphEntityCollection(PgxGraph graph, PgxId collectionId, String collectionName, CollectionType type, EntityType elementType) {
        super(graph, collectionId, collectionName, type, elementType);
    }

    public PgxFuture<Void> addAllByIdAsync(Collection<ID> source) {
        return this.core.addAllToCollection(this.getSessionContext(), this.getId(), source).thenReturn(null);
    }

    @Override
    public PgxFuture<Void> addAllElementsAsync(Collection<E> source) {
        return this.core.addAllToCollection(this.getSessionContext(), this.getId(), this.unbox(source)).thenReturn(null);
    }

    public PgxFuture<Void> removeAllByIdAsync(Collection<ID> source) {
        return this.core.removeAllFromCollection(this.getSessionContext(), this.getId(), source).thenReturn(null);
    }

    @Override
    public PgxFuture<Void> removeAllElementsAsync(Collection<E> source) {
        return this.core.removeAllFromCollection(this.getSessionContext(), this.getId(), this.unbox(source)).thenReturn(null);
    }

    @Override
    public PgxFuture<Boolean> containsAsync(E element) {
        return this.core.containsElement(this.getSessionContext(), this.getId(), ((PgxEntity)element).serialize());
    }

    public void addAllById(Collection<ID> source) {
        this.addAllByIdAsync(source).join();
    }

    public void removeAllById(Collection<ID> source) {
        this.removeAllByIdAsync(source).join();
    }

    @Override
    public void addAll(PgxEntity[] elements) {
        this.addAllAsync(elements).join();
    }

    protected Collection<E> box(Function<ID, E> boxer, ID ... ids) {
        ArrayList<E> entities = new ArrayList<E>(ids.length);
        for (ID id : ids) {
            if (id != null && id.getClass() != this.getIdType().getTypeClass()) {
                throw new IllegalArgumentException(ErrorMessages.getMessage((String)"EXPECTED_ID_TYPE", (Object[])new Object[]{this.getIdType().getTypeClass(), id.getClass()}));
            }
            entities.add(boxer.apply(id));
        }
        return entities;
    }

    private Collection<Object> unbox(Collection<E> in) {
        return in.stream().map(PgxEntity::serialize).collect(Collectors.toList());
    }

    public abstract void addAllById(ID ... var1) throws ExecutionException, InterruptedException;

    public abstract void removeAllById(ID ... var1) throws ExecutionException, InterruptedException;

    protected static abstract class GraphEntityProxyIterator<E extends PgxEntity<ID>, ID>
    extends PgxCollection.AbstractProxyIterator<E> {
        protected final PgxGraph graph;

        GraphEntityProxyIterator(PgxGraph graph, CollectionProxy proxy) {
            super(proxy);
            this.graph = graph;
        }

        protected abstract E newEntityObject(Object var1);

        @Override
        public boolean hasNext() {
            return this.wrapped.hasNext();
        }

        @Override
        public E next() {
            Object object = this.wrapped.next();
            return this.newEntityObject(object);
        }

        @Override
        public void remove() {
            this.wrapped.remove();
        }
    }
}

