/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.internal;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import oracle.pgx.common.types.PropertyType;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.common.util.JsonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class ElementChanges {
    private static final Logger LOG = LoggerFactory.getLogger(ElementChanges.class);
    private static final Map<String, Object> EMPTY_PROPERTY_UPDATES = Collections.emptyMap();
    private Map<String, Object> propertyUpdates;

    ElementChanges() {
    }

    void fixProperties(Map<String, PropertyType> expectedPropertyTypes) throws IOException {
        HashMap<String, Object> updatedValues = new HashMap<String, Object>();
        for (Map.Entry<String, Object> stringObjectEntry : this.getPropertyUpdates().entrySet()) {
            PropertyType expectedPropertyType = expectedPropertyTypes.get(stringObjectEntry.getKey());
            Object propertyValue = stringObjectEntry.getValue();
            if (propertyValue == null || propertyValue.getClass() == expectedPropertyType.getTypeClass()) continue;
            Object updatedPropertyValue = JsonUtil.reparseObject((Object)propertyValue, (Class)expectedPropertyType.getTypeClass());
            if (LOG.isTraceEnabled()) {
                LOG.trace("Fixing {} of type {} to {} of type {}", new Object[]{propertyValue, propertyValue.getClass(), updatedPropertyValue, expectedPropertyType.getTypeClass()});
            }
            updatedValues.put(stringObjectEntry.getKey(), updatedPropertyValue);
        }
        updatedValues.forEach(this::setPropertyValue);
    }

    public Map<String, Object> getPropertyUpdates() {
        if (this.propertyUpdates == null) {
            return EMPTY_PROPERTY_UPDATES;
        }
        return Collections.unmodifiableMap(this.propertyUpdates);
    }

    private void setPropertyUpdates(Map<String, Object> propertyUpdates) {
        if (propertyUpdates == null || propertyUpdates.isEmpty()) {
            this.propertyUpdates = null;
        }
        this.propertyUpdates = propertyUpdates;
    }

    public void setPropertyValue(String key, Object value) {
        if (value == null) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"NULL_PROPERTY_VALUE", (Object[])new Object[0]));
        }
        if (this.propertyUpdates == null) {
            this.propertyUpdates = new HashMap<String, Object>();
        }
        this.propertyUpdates.put(key, value);
    }

    public String toString() {
        return "ElementChanges{propertyUpdates=" + this.getPropertyUpdates() + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ElementChanges that = (ElementChanges)o;
        if (this.propertyUpdates == null || this.propertyUpdates.isEmpty()) {
            return that.propertyUpdates == null || that.propertyUpdates.isEmpty();
        }
        return Objects.equals(this.propertyUpdates, that.propertyUpdates);
    }

    public int hashCode() {
        return Objects.hash(this.propertyUpdates);
    }
}

