/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common.pojo;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Collection;
import java.util.Map;
import oracle.pgx.common.PgxId;
import oracle.pgx.common.mutations.EdgeStrategy;
import oracle.pgx.common.mutations.MutationStrategy;
import oracle.pgx.common.pojo.EdgeStrategyDeserializer;
import oracle.pgx.common.pojo.UnsafeHttpMethodRequest;

public class MutateGraphRequest
extends UnsafeHttpMethodRequest {
    @JsonInclude
    public Collection<PgxId> vertexPropIds;
    @JsonInclude
    public Collection<PgxId> edgePropIds;
    @JsonInclude
    public Map<String, String> edgeLabelMapping;
    @JsonInclude
    public boolean inPlace;
    @JsonInclude
    public String newGraphName;
    @JsonInclude
    public boolean noTrivialVertices;
    @JsonDeserialize(using=EdgeStrategyDeserializer.class)
    @JsonInclude
    public EdgeStrategy edgeStrategy;

    public MutationStrategy createMutationStrategy() {
        return new MutationStrategy(this.vertexPropIds, this.edgePropIds, this.inPlace, this.newGraphName, this.noTrivialVertices, this.edgeStrategy, this.edgeLabelMapping);
    }

    public void initMutationStrategy(MutationStrategy mutationStrategy) {
        this.vertexPropIds = mutationStrategy.getVertexPropIds();
        this.edgePropIds = mutationStrategy.getEdgePropIds();
        this.inPlace = mutationStrategy.isInPlace();
        this.newGraphName = mutationStrategy.getNewGraphName();
        this.noTrivialVertices = mutationStrategy.isNoTrivialVertices();
        this.edgeStrategy = mutationStrategy.getEdgeStrategy();
        this.edgeLabelMapping = mutationStrategy.getEdgeLabelMapping();
    }
}

