/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common.marshalers;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import oracle.pgx.common.marshalers.Marshaler;
import oracle.pgx.common.util.JsonUtil;
import oracle.pgx.config.PgxRedactionRuleConfig;
import org.apache.commons.io.IOUtils;

public class PgxRedactionRuleConfigListMarshaler
implements Marshaler<List<PgxRedactionRuleConfig>> {
    @Override
    public String marshal(List<PgxRedactionRuleConfig> object) throws IOException {
        return JsonUtil.toJson(object);
    }

    @Override
    public List<PgxRedactionRuleConfig> unmarshal(String jsonString) throws IOException {
        JsonNode node = JsonUtil.readTopLevelJsonToTree((String)jsonString);
        JsonNode items = node.get("items");
        return this.unmarshalFromArray(items);
    }

    public List<PgxRedactionRuleConfig> unmarshalFromArray(String jsonString) throws IOException {
        JsonNode node = JsonUtil.readTopLevelJsonToTree((String)jsonString);
        return this.unmarshalFromArray(node);
    }

    private List<PgxRedactionRuleConfig> unmarshalFromArray(JsonNode items) throws IOException {
        ArrayList<PgxRedactionRuleConfig> result = new ArrayList<PgxRedactionRuleConfig>();
        for (JsonNode item : items) {
            InputStream inputStream = IOUtils.toInputStream((String)item.toString(), (Charset)StandardCharsets.UTF_8);
            Throwable throwable = null;
            try {
                PgxRedactionRuleConfig redactionRuleConfig = PgxRedactionRuleConfig.parse((InputStream)inputStream, (boolean)false, null);
                result.add(redactionRuleConfig);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (inputStream == null) continue;
                if (throwable != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                inputStream.close();
            }
        }
        return result;
    }
}

