/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.mllib;

import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.config.mllib.ActivationFunction;
import oracle.pgx.config.mllib.GraphWiseConvLayerConfig;
import oracle.pgx.config.mllib.WeightInitScheme;

public class GraphWiseConvLayerConfigBuilder {
    private GraphWiseConvLayerConfig convLayerConfig = new GraphWiseConvLayerConfig();

    public GraphWiseConvLayerConfigBuilder setNumSampledNeighbors(int numSampledNeighbors) {
        this.convLayerConfig.setNumSampledNeighbors(numSampledNeighbors);
        return this;
    }

    public GraphWiseConvLayerConfigBuilder setWeightedAggregationProperty(String neighborWeightProperty) {
        this.convLayerConfig.setWeightedAggregationProperty(neighborWeightProperty);
        return this;
    }

    public GraphWiseConvLayerConfigBuilder setActivationFunction(ActivationFunction activationFunction) {
        this.convLayerConfig.setActivationFunction(activationFunction);
        return this;
    }

    public GraphWiseConvLayerConfigBuilder setWeightInitScheme(WeightInitScheme weightInitScheme) {
        this.convLayerConfig.setWeightInitScheme(weightInitScheme);
        return this;
    }

    public GraphWiseConvLayerConfigBuilder setDropoutRate(double dropoutRate) {
        this.convLayerConfig.setDropoutRate(dropoutRate);
        return this;
    }

    private void validateDropoutRate() {
        if (this.convLayerConfig.getDropoutRate() < 0.0 || this.convLayerConfig.getDropoutRate() >= 1.0) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"INVALID_DROPOUT_RATE", (Object[])new Object[]{this.convLayerConfig.getDropoutRate()}));
        }
    }

    public GraphWiseConvLayerConfigBuilder useVertexToEdgeConnection(boolean vertexToEdgeConnection) {
        this.convLayerConfig.useVertexToEdgeConnection(vertexToEdgeConnection);
        return this;
    }

    public GraphWiseConvLayerConfigBuilder useVertexToVertexConnection(boolean vertexToVertexConnection) {
        this.convLayerConfig.useVertexToVertexConnection(vertexToVertexConnection);
        return this;
    }

    public GraphWiseConvLayerConfigBuilder useEdgeToVertexConnection(boolean edgeToVertexConnection) {
        this.convLayerConfig.useEdgeToVertexConnection(edgeToVertexConnection);
        return this;
    }

    public GraphWiseConvLayerConfigBuilder useEdgeToEdgeConnection(boolean edgeToEdgeConnection) {
        this.convLayerConfig.useEdgeToEdgeConnection(edgeToEdgeConnection);
        return this;
    }

    public GraphWiseConvLayerConfig build() {
        this.validateDropoutRate();
        return this.convLayerConfig;
    }
}

