/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.mllib;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import oracle.pgx.api.PgxFuture;
import oracle.pgx.api.PgxGraph;
import oracle.pgx.api.PgxSession;
import oracle.pgx.api.frames.PgxFrame;
import oracle.pgx.api.frames.internal.PgxFrameImpl;
import oracle.pgx.api.internal.Core;
import oracle.pgx.api.internal.FrameMetaData;
import oracle.pgx.api.internal.mllib.DeepWalkModelMetadata;
import oracle.pgx.api.internal.mllib.ModelMetadata;
import oracle.pgx.api.mllib.FileModelStorer;
import oracle.pgx.api.mllib.Model;
import oracle.pgx.config.mllib.ModelKind;

public class DeepWalkModel
extends Model<DeepWalkModel> {
    private final DeepWalkModelMetadata modelMetadata;

    public DeepWalkModel(PgxSession session, Core core, Supplier<String> keystorePathSupplier, Supplier<char[]> keystorePasswordSupplier, DeepWalkModelMetadata modelMetadata) {
        super(session, core, keystorePathSupplier, keystorePasswordSupplier);
        this.modelMetadata = modelMetadata;
    }

    public DeepWalkModel(PgxSession session, Core core, Supplier<String> keystorePathSupplier, Supplier<char[]> keystorePasswordSupplier, ModelMetadata modelMetadata) {
        super(session, core, keystorePathSupplier, keystorePasswordSupplier);
        if (!(modelMetadata instanceof DeepWalkModelMetadata)) {
            throw new IllegalArgumentException("expected DeepWalkModelMetaData");
        }
        this.modelMetadata = (DeepWalkModelMetadata)modelMetadata;
    }

    @Override
    protected DeepWalkModel getThis() {
        return this;
    }

    @Override
    protected ModelKind getModelKind() {
        return ModelKind.DEEPWALK;
    }

    @Override
    String getModelName() {
        return this.modelMetadata.getModelName();
    }

    public PgxFuture<Void> fitAsync(PgxGraph graph) {
        return this.core.fitDeepWalkModel(this.session.getSessionContext(), this.modelMetadata.getModelName(), graph.getId()).thenApply(trainingLoss -> {
            this.modelMetadata.setLoss((Double)trainingLoss);
            return null;
        });
    }

    public void fit(PgxGraph graph) throws ExecutionException, InterruptedException {
        this.fitAsync(graph).get();
    }

    public PgxFuture<PgxFrame> getTrainedVertexVectorsAsync() {
        return this.core.getTrainedVertexVectorsDeepWalkModel(this.session.getSessionContext(), this.modelMetadata.getModelName()).thenApply(frameMetaData -> new PgxFrameImpl(this.session, this.core, (FrameMetaData)((Object)frameMetaData), this.keystorePathSupplier, this.keystorePasswordSupplier));
    }

    public PgxFrame getTrainedVertexVectors() throws ExecutionException, InterruptedException {
        return this.getTrainedVertexVectorsAsync().get();
    }

    public PgxFuture<PgxFrame> computeSimilarsAsync(Object vertexIdObject, int k) {
        String vertexId = String.valueOf(vertexIdObject);
        return this.core.computeSimilarsDeepWalkModel(this.session.getSessionContext(), this.modelMetadata.getModelName(), vertexId, k).thenApply(frameMetaData -> new PgxFrameImpl(this.session, this.core, (FrameMetaData)((Object)frameMetaData), this.keystorePathSupplier, this.keystorePasswordSupplier));
    }

    public PgxFrame computeSimilars(Object vertexId, int k) throws ExecutionException, InterruptedException {
        return this.computeSimilarsAsync(vertexId, k).get();
    }

    public PgxFuture<PgxFrame> computeSimilarsAsync(List<Object> vertexIdObjects, int k) {
        List vertexIds = Lists.transform(vertexIdObjects, (Function)Functions.toStringFunction());
        return this.core.computeSimilarsBatchedDeepWalkModel(this.session.getSessionContext(), this.modelMetadata.getModelName(), vertexIds, k).thenApply(frameMetaData -> new PgxFrameImpl(this.session, this.core, (FrameMetaData)((Object)frameMetaData), this.keystorePathSupplier, this.keystorePasswordSupplier));
    }

    public PgxFrame computeSimilars(List<Object> vertexIds, int k) throws ExecutionException, InterruptedException {
        return this.computeSimilarsAsync(vertexIds, k).get();
    }

    public PgxFuture<Void> storeAsync(String path, String key) {
        return this.export().file().path(path).key(key).storeAsync();
    }

    public PgxFuture<Void> storeAsync(String path, String key, boolean overwrite) {
        return ((FileModelStorer)this.export().file().path(path).key(key).overwrite(overwrite)).storeAsync();
    }

    public void store(String path, String key) throws ExecutionException, InterruptedException {
        this.storeAsync(path, key).get();
    }

    public void store(String path, String key, boolean overwrite) throws ExecutionException, InterruptedException {
        this.storeAsync(path, key, overwrite).get();
    }

    @Override
    public PgxFuture<Void> destroyAsync() {
        return this.core.destroyMlModel(this.session.getSessionContext(), this.modelMetadata.getModelName());
    }

    public void destroy() throws ExecutionException, InterruptedException {
        this.destroyAsync().get();
    }

    public int getNegativeSample() {
        return this.modelMetadata.getNegativeSample();
    }

    public double getSampleRate() {
        return this.modelMetadata.getSampleRate();
    }

    public int getMinWordFrequency() {
        return this.modelMetadata.getMinWordFrequency();
    }

    public int getBatchSize() {
        return this.modelMetadata.getBatchSize();
    }

    public int getNumEpochs() {
        return this.modelMetadata.getNumEpochs();
    }

    public int getLayerSize() {
        return this.modelMetadata.getLayerSize();
    }

    public double getLearningRate() {
        return this.modelMetadata.getLearningRate();
    }

    public double getMinLearningRate() {
        return this.modelMetadata.getMinLearningRate();
    }

    public int getWindowSize() {
        return this.modelMetadata.getWindowSize();
    }

    public int getWalkLength() {
        return this.modelMetadata.getWalkLength();
    }

    public int getWalksPerVertex() {
        return this.modelMetadata.getWalksPerVertex();
    }

    public double getValidationFraction() {
        return this.modelMetadata.getValidationFraction();
    }

    public double getLoss() {
        return this.modelMetadata.getLoss();
    }

    public double getSeed() {
        return this.modelMetadata.getSeed().longValue();
    }
}

