/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.internal.synchronizer;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.function.Consumer;
import oracle.pgx.api.EdgeBuilder;
import oracle.pgx.api.EdgeModifier;
import oracle.pgx.api.GraphChangeSet;
import oracle.pgx.api.PgxGraph;
import oracle.pgx.api.VertexBuilder;
import oracle.pgx.api.VertexModifier;
import oracle.pgx.api.internal.synchronizer.ResultSetConverter;
import oracle.pgx.common.PartitionedId;
import oracle.pgx.common.types.ChangeType;
import oracle.pgx.common.types.IdStrategy;
import oracle.pgx.config.GraphPropertyConfig;
import oracle.pgx.config.RdbmsEntityProviderConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultSetToChangeSetHandler {
    private GraphChangeSet changeSet;
    private PgxGraph graph;
    private static final Logger LOG = LoggerFactory.getLogger(ResultSetToChangeSetHandler.class);

    public ResultSetToChangeSetHandler(GraphChangeSet changeSet, PgxGraph graph) {
        this.changeSet = changeSet;
        this.graph = graph;
    }

    public long addEdgesToChangeSet(ResultSet rs, RdbmsEntityProviderConfig rdbmsProvider) throws SQLException {
        LOG.debug("Adding edges resultSet to changeset for: {}", (Object)rdbmsProvider.getName());
        long addedEdges = 0L;
        while (rs.next()) {
            Object edgeId = ResultSetConverter.getKeyColumnValue(rs, rdbmsProvider);
            Object destId = ResultSetConverter.getKeyColumnValue(rs, rdbmsProvider.getDestinationVertexKeyType(), rdbmsProvider.getDestinationColumn());
            Object sourceId = ResultSetConverter.getKeyColumnValue(rs, rdbmsProvider.getSourceVertexKeyType(), rdbmsProvider.getSourceColumn());
            EdgeBuilder<Object> edgeBuilder = null;
            if (this.graph.getEdgeIdStrategy() == IdStrategy.PARTITIONED_IDS) {
                String partitionedEdgeId = PartitionedId.createPartitionedId((String)rdbmsProvider.getName(), (Object[])new Object[]{edgeId});
                String partitionedSourceId = PartitionedId.createPartitionedId((String)rdbmsProvider.getSourceVertexProvider(), (Object[])new Object[]{sourceId});
                String partitionedDestId = PartitionedId.createPartitionedId((String)rdbmsProvider.getDestinationVertexProvider(), (Object[])new Object[]{destId});
                edgeBuilder = this.changeSet.addEdge(partitionedEdgeId, partitionedSourceId, partitionedDestId);
            } else {
                edgeBuilder = this.changeSet.addEdge((long)((Long)edgeId), sourceId, destId).setLabel(rdbmsProvider.getName());
            }
            this.addPropertiesToGraphBuilder(edgeBuilder, rs, rdbmsProvider);
            ++addedEdges;
        }
        return addedEdges;
    }

    public long addVerticesToChangeSet(ResultSet rs, RdbmsEntityProviderConfig rdbmsProvider) throws SQLException {
        LOG.debug("Adding vertices resultSet to changeset for: {}", (Object)rdbmsProvider.getName());
        long addedVertices = 0L;
        while (rs.next()) {
            Object vertexId = ResultSetConverter.getKeyColumnValue(rs, rdbmsProvider);
            VertexBuilder<Object> vertexBuilder = null;
            if (this.graph.getVertexIdStrategy() == IdStrategy.PARTITIONED_IDS) {
                String partitionedVertexId = PartitionedId.createPartitionedId((String)rdbmsProvider.getName(), (Object[])new Object[]{vertexId});
                vertexBuilder = this.changeSet.addVertex(partitionedVertexId);
            } else {
                vertexBuilder = this.changeSet.addVertex(vertexId).addLabel(rdbmsProvider.getName());
            }
            this.addPropertiesToGraphBuilder(vertexBuilder, rs, rdbmsProvider);
            ++addedVertices;
        }
        return addedVertices;
    }

    public long removeEdgesFromChangeSet(ResultSet rs, RdbmsEntityProviderConfig rdbmsProvider) throws SQLException {
        LOG.debug("Removing edges resultSet to changeset for: {}", (Object)rdbmsProvider.getName());
        long removedEdges = 0L;
        while (rs.next()) {
            Object edgeId = ResultSetConverter.getKeyColumnValue(rs, rdbmsProvider);
            if (this.graph.getEdgeIdStrategy() == IdStrategy.PARTITIONED_IDS) {
                String partitionedEdgeId = PartitionedId.createPartitionedId((String)rdbmsProvider.getName(), (Object[])new Object[]{edgeId});
                ChangeType changeType = this.changeSet.getEdgeChangeType(partitionedEdgeId);
                this.removeEntityWithId(changeType, partitionedEdgeId, this.changeSet::resetEdge, this.changeSet::removeEdge);
            } else {
                ChangeType changeType = this.changeSet.getEdgeChangeType(edgeId);
                this.removeEntityWithId(changeType, (Long)edgeId, this.changeSet::resetEdge, this.changeSet::removeEdge);
            }
            ++removedEdges;
        }
        return removedEdges;
    }

    public long removeVerticesFromChangeSet(ResultSet rs, RdbmsEntityProviderConfig rdbmsProvider) throws SQLException {
        LOG.debug("Removing vertices resultSet to changeset for: {}", (Object)rdbmsProvider.getName());
        long removedVertices = 0L;
        while (rs.next()) {
            Object vertexId = ResultSetConverter.getKeyColumnValue(rs, rdbmsProvider);
            if (this.graph.getVertexIdStrategy() == IdStrategy.PARTITIONED_IDS) {
                vertexId = PartitionedId.createPartitionedId((String)rdbmsProvider.getName(), (Object[])new Object[]{vertexId});
            }
            ChangeType changeType = this.changeSet.getVertexChangeType(vertexId);
            this.removeEntityWithId(changeType, vertexId, this.changeSet::resetVertex, this.changeSet::removeVertex);
            ++removedVertices;
        }
        return removedVertices;
    }

    private <T> void removeEntityWithId(ChangeType changeType, T entityId, Consumer<T> resetEntity, Consumer<T> removeEntity) {
        if (changeType == null) {
            removeEntity.accept(entityId);
            return;
        }
        switch (changeType) {
            case ADD: {
                resetEntity.accept(entityId);
                break;
            }
            case MODIFY: {
                resetEntity.accept(entityId);
                removeEntity.accept(entityId);
            }
        }
    }

    public long updateEdgesToChangeSet(ResultSet rs, RdbmsEntityProviderConfig rdbmsProvider) throws SQLException {
        LOG.debug("Updating edges resultSet to changeset for: {}", (Object)rdbmsProvider.getName());
        long updatedEdges = 0L;
        while (rs.next()) {
            Object edgeId = ResultSetConverter.getKeyColumnValue(rs, rdbmsProvider);
            EdgeModifier edgeBuilder = null;
            if (this.graph.getEdgeIdStrategy() == IdStrategy.PARTITIONED_IDS) {
                String partitionedEdgeId = PartitionedId.createPartitionedId((String)rdbmsProvider.getName(), (Object[])new Object[]{edgeId});
                edgeBuilder = this.changeSet.updateEdge(partitionedEdgeId);
            } else {
                edgeBuilder = this.changeSet.updateEdge((Long)edgeId).setLabel(rdbmsProvider.getName());
            }
            this.addPropertiesToGraphBuilder(edgeBuilder, rs, rdbmsProvider);
            ++updatedEdges;
        }
        return updatedEdges;
    }

    public long updateVerticesToChangeSet(ResultSet rs, RdbmsEntityProviderConfig rdbmsProvider) throws SQLException {
        LOG.debug("Updating vertices resultSet to changeset for: {}", (Object)rdbmsProvider.getName());
        long updatedVertices = 0L;
        while (rs.next()) {
            Object vertexId = ResultSetConverter.getKeyColumnValue(rs, rdbmsProvider);
            VertexModifier<String> vertexBuilder = null;
            if (this.graph.getVertexIdStrategy() == IdStrategy.PARTITIONED_IDS) {
                String partitionedVertexId = PartitionedId.createPartitionedId((String)rdbmsProvider.getName(), (Object[])new Object[]{vertexId});
                vertexBuilder = this.changeSet.updateVertex(partitionedVertexId);
            } else {
                vertexBuilder = this.changeSet.updateVertex(vertexId).addLabel(rdbmsProvider.getName());
            }
            this.addPropertiesToGraphBuilder(vertexBuilder, rs, rdbmsProvider);
            ++updatedVertices;
        }
        return updatedVertices;
    }

    void addPropertiesToGraphBuilder(VertexBuilder builder, ResultSet rs, RdbmsEntityProviderConfig provider) throws SQLException {
        for (GraphPropertyConfig propConfig : provider.getProps()) {
            if (propConfig.getName().equals(provider.getKeyColumn())) continue;
            builder.setProperty(propConfig.getName(), ResultSetConverter.getParsedObject(rs, propConfig.getName(), propConfig.getType()));
        }
    }

    void addPropertiesToGraphBuilder(EdgeBuilder builder, ResultSet rs, RdbmsEntityProviderConfig provider) throws SQLException {
        for (GraphPropertyConfig propConfig : provider.getProps()) {
            if (propConfig.getName().equals(provider.getKeyColumn())) continue;
            builder.setProperty(propConfig.getName(), ResultSetConverter.getParsedObject(rs, propConfig.getName(), propConfig.getType()));
        }
    }

    public static long fetchAndAddToChangeSet(Statement statement, String query, ResultSetToChangeSet action, RdbmsEntityProviderConfig provider) throws SQLException {
        try (ResultSet rs = statement.executeQuery(query);){
            long l = action.addToChangeSet(rs, provider);
            return l;
        }
    }

    public static interface ResultSetToChangeSet {
        public long addToChangeSet(ResultSet var1, RdbmsEntityProviderConfig var2) throws SQLException;
    }
}

