/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.internal.synchronizer;

import oracle.pgql.lang.ir.PgqlUtils;
import oracle.pgx.api.internal.synchronizer.FlashbackConfig;
import oracle.pgx.api.internal.synchronizer.FlashbackPropertyConfig;
import oracle.pgx.common.types.EntityType;

public final class FlashbackQueryFactory {
    private FlashbackQueryFactory() {
    }

    public static String selectAddedVertices(FlashbackConfig config) {
        return FlashbackQueryFactory.getChangedElementsQuery(config, 'I', EntityType.VERTEX);
    }

    public static String selectAddedEdges(FlashbackConfig config) {
        return FlashbackQueryFactory.getChangedElementsQuery(config, 'I', EntityType.EDGE);
    }

    public static String selectVertexChanges(FlashbackConfig config) {
        return FlashbackQueryFactory.getChangedElementsQuery(config, 'U', EntityType.VERTEX);
    }

    public static String selectEdgeChanges(FlashbackConfig config) {
        return FlashbackQueryFactory.getChangedElementsQuery(config, 'U', EntityType.EDGE);
    }

    public static String selectRemovedVertices(FlashbackConfig config) {
        return FlashbackQueryFactory.getRemovedElementsQuery(config);
    }

    public static String selectRemovedEdges(FlashbackConfig config) {
        return FlashbackQueryFactory.getRemovedElementsQuery(config);
    }

    private static String getChangedElementsQuery(FlashbackConfig config, char opType, EntityType entityType) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT /* parallel(").append(config.getDop()).append(") */ ").append(PgqlUtils.printIdentifier((String)config.getKeyColumn())).append(", versions_operation vo ");
        for (FlashbackPropertyConfig property : config.getProperties()) {
            String propertyName = property.getName();
            String columnName = property.getColumnName() == null ? propertyName : property.getColumnName();
            sb.append(", " + PgqlUtils.printIdentifier((String)columnName) + " AS " + PgqlUtils.printIdentifier((String)propertyName) + " ");
        }
        sb.append(", versions_startscn, versions_endscn, versions_xid");
        if (entityType == EntityType.EDGE) {
            sb.append(", ").append(PgqlUtils.printIdentifier((String)config.getSourceColumn())).append(", ").append(PgqlUtils.printIdentifier((String)config.getDestinationColumn()));
        }
        sb.append(" from ").append(config.printTableName()).append(" versions between scn ").append(config.getStartScn()).append(" and ").append(config.getLastScn()).append(" where versions_operation = '").append(opType).append("'");
        return sb.toString();
    }

    private static String getRemovedElementsQuery(FlashbackConfig config) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT /* parallel(").append(config.getDop()).append(") */ ").append(PgqlUtils.printIdentifier((String)config.getKeyColumn())).append(", versions_operation vo").append(" from ").append(config.printTableName()).append(" versions between scn ").append(config.getStartScn()).append(" and ").append(config.getLastScn()).append(" where versions_operation = 'D'").append(" order by ").append(PgqlUtils.printIdentifier((String)config.getKeyColumn()));
        return sb.toString();
    }
}

