/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.internal;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import oracle.pgx.api.EdgeProperty;
import oracle.pgx.api.VertexProperty;
import oracle.pgx.api.internal.Graph;
import oracle.pgx.api.internal.GraphConfigGenerationHelper;
import oracle.pgx.api.internal.Property;
import oracle.pgx.common.Pair;
import oracle.pgx.common.types.IdStrategy;
import oracle.pgx.common.types.IdType;
import oracle.pgx.common.types.PropertyType;
import oracle.pgx.config.AbstractEntityProviderConfigBuilder;
import oracle.pgx.config.FileEntityProviderConfigBuilder;
import oracle.pgx.config.FileGraphStoringConfig;
import oracle.pgx.config.FileGraphStoringConfigBuilder;
import oracle.pgx.config.GraphConfigBuilder;
import oracle.pgx.config.PartitionedGraphConfig;
import oracle.pgx.config.PartitionedGraphConfigBuilder;
import oracle.pgx.config.ProviderFormat;

public class PartitionedGraphConfigGenerationContext {
    private ProviderFormat targetFormat;
    private String targetBasePath;
    private int numPartitions;
    private Map<String, FileGraphStoringConfig> vertexStoringConfigs;
    private Map<String, FileGraphStoringConfig> edgeStoringConfigs;
    private Graph graph;
    private IdType vertexIdType;
    private IdType edgeIdType;
    private IdStrategy vertexIdStrategy;
    private IdStrategy edgeIdStrategy;
    private Collection<VertexProperty<?, ?>> vertexProperties;
    private Collection<EdgeProperty<?>> edgeProperties;
    private Set<String> vertexProvidersToStore = null;
    private Set<String> edgeProvidersToStore = null;

    public PartitionedGraphConfigGenerationContext() {
    }

    public PartitionedGraphConfigGenerationContext(ProviderFormat targetFormat, String targetBasePath, int numPartitions, Map<String, FileGraphStoringConfig> vertexStoringConfigs, Map<String, FileGraphStoringConfig> edgeStoringConfigs, Graph graph, IdType vertexIdType, IdType edgeIdType, IdStrategy vertexIdStrategy, IdStrategy edgeIdStrategy, Collection<VertexProperty<?, ?>> vertexProperties, Collection<EdgeProperty<?>> edgeProperties) {
        this.targetFormat = targetFormat;
        this.targetBasePath = targetBasePath;
        this.numPartitions = numPartitions;
        this.vertexStoringConfigs = vertexStoringConfigs;
        this.edgeStoringConfigs = edgeStoringConfigs;
        this.graph = graph;
        this.vertexIdType = vertexIdType;
        this.edgeIdType = edgeIdType;
        this.vertexIdStrategy = vertexIdStrategy;
        this.edgeIdStrategy = edgeIdStrategy;
        this.vertexProperties = vertexProperties;
        this.edgeProperties = edgeProperties;
    }

    public PartitionedGraphConfig generatePartitionedGraphConfig() {
        new GraphConfigBuilder();
        PartitionedGraphConfigBuilder builder = (PartitionedGraphConfigBuilder)((PartitionedGraphConfigBuilder)((PartitionedGraphConfigBuilder)((PartitionedGraphConfigBuilder)GraphConfigBuilder.forPartitioned().setName(this.getGraph().getGraphName()).setVertexIdStrategy(this.getVertexIdStrategy())).setEdgeIdStrategy(this.getEdgeIdStrategy())).setVertexIdType(this.getVertexIdType())).setEdgeIdType(this.getEdgeIdType());
        for (VertexProperty<?, ?> vertexProperty : this.getVertexProperties()) {
            builder.addVertexVectorProperty(vertexProperty.getName(), vertexProperty.getType(), vertexProperty.getDimension(), null);
        }
        for (EdgeProperty edgeProperty : this.getEdgeProperties()) {
            builder.addEdgeVectorProperty(edgeProperty.getName(), edgeProperty.getType(), edgeProperty.getDimension(), null);
        }
        Set<Pair<String, PropertyType>> vertexPropertiesToStore = this.asPropertyNameAndTypePairs(this.vertexProperties);
        this.getGraph().getVertexTables().forEach((name, table) -> {
            if (this.getVertexProvidersToStore() != null && !this.getVertexProvidersToStore().contains(name)) {
                return;
            }
            String label = GraphConfigGenerationHelper.getLabelFromProvider(name, table);
            String path = "";
            path = this.getVertexStoringConfigs() != null ? this.getVertexStoringConfigs().get(name).getBasePath() + "." + this.getVertexStoringConfigs().get(name).getVertexExtension() : this.getTargetBasePath() + name + "." + this.getTargetFormat().toString();
            boolean hasKeys = this.getVertexIdStrategy() == IdStrategy.KEYS_AS_IDS || this.getVertexIdStrategy() == IdStrategy.PARTITIONED_IDS && !table.getIsIdentityKeyMapping();
            Integer keyColumnIndex = GraphConfigGenerationHelper.getKeyColumnIndex(table);
            IdType keyType = table.getEntityKeyType() == null ? IdType.INTEGER : table.getEntityKeyType();
            int currentColumnIndex = 1;
            FileEntityProviderConfigBuilder vertexProviderBuilder = (FileEntityProviderConfigBuilder)((FileEntityProviderConfigBuilder)((FileEntityProviderConfigBuilder)((FileEntityProviderConfigBuilder)((FileEntityProviderConfigBuilder)new FileEntityProviderConfigBuilder().setName(name)).setLabel(label)).setUris(new String[]{path}).setFormat(this.getTargetFormat()).setKeyColumn((Object)(keyColumnIndex == null ? currentColumnIndex++ : keyColumnIndex)).setKeyType(keyType)).setHasKeys(hasKeys)).createKeyMapping(hasKeys);
            for (Property property : table.getVertexProperties().values()) {
                if (!vertexPropertiesToStore.contains(Pair.of((Object)property.getName(), (Object)property.getType()))) continue;
                vertexProviderBuilder.addVectorProperty(property.getName(), property.getType(), property.getDimension(), null, (Object)currentColumnIndex++);
            }
            if (this.getVertexStoringConfigs() != null) {
                vertexProviderBuilder.setStoringOptions(this.getVertexStoringConfigs().get(name));
            } else if (this.getNumPartitions() > 0) {
                vertexProviderBuilder.setStoringOptions(new FileGraphStoringConfigBuilder(this.getTargetBasePath() + name).setNumPartitions(this.getNumPartitions()).setInitialPartitionIndex(0).setVertexExtension(this.getTargetFormat().toString()).build());
            } else {
                vertexProviderBuilder.setStoringOptions(new FileGraphStoringConfigBuilder(this.getTargetBasePath() + name).setVertexExtension(this.getTargetFormat().toString()).build());
            }
            vertexProviderBuilder.setKeyType(keyType);
            builder.addVertexProvider((AbstractEntityProviderConfigBuilder)vertexProviderBuilder);
        });
        Set<Pair<String, PropertyType>> set = this.asPropertyNameAndTypePairs(this.edgeProperties);
        this.getGraph().getEdgeTables().forEach((name, table) -> {
            if (this.getEdgeProvidersToStore() != null && !this.getEdgeProvidersToStore().contains(name)) {
                return;
            }
            String label = GraphConfigGenerationHelper.getLabelFromProvider(name, table);
            String path = "";
            path = this.getEdgeStoringConfigs() != null ? this.getEdgeStoringConfigs().get(name).getBasePath() + "." + this.getEdgeStoringConfigs().get(name).getEdgeExtension() : this.getTargetBasePath() + name + "." + this.getTargetFormat().toString();
            boolean hasKeys = this.getEdgeIdStrategy() == IdStrategy.KEYS_AS_IDS || this.getEdgeIdStrategy() == IdStrategy.PARTITIONED_IDS && !table.getIsIdentityKeyMapping();
            Integer keyColumnIndex = GraphConfigGenerationHelper.getKeyColumnIndex(table);
            IdType keyType = table.getEntityKeyType() == null ? IdType.LONG : table.getEntityKeyType();
            int currentColumnIndex = 1;
            FileEntityProviderConfigBuilder edgeProviderBuilder = (FileEntityProviderConfigBuilder)((FileEntityProviderConfigBuilder)((FileEntityProviderConfigBuilder)((FileEntityProviderConfigBuilder)((FileEntityProviderConfigBuilder)((FileEntityProviderConfigBuilder)((FileEntityProviderConfigBuilder)new FileEntityProviderConfigBuilder().setName(name)).setLabel(label)).setUris(new String[]{path}).setHasKeys(hasKeys)).setKeyColumn((Object)(keyColumnIndex == null ? currentColumnIndex++ : keyColumnIndex)).setKeyType(keyType)).setSourceVertexProvider(table.getSourceVertexTableName())).setSourceColumn((Object)currentColumnIndex++).setDestinationVertexProvider(table.getDestinationVertexTableName())).setDestinationColumn((Object)currentColumnIndex++).setFormat(this.getTargetFormat()).createKeyMapping(hasKeys);
            for (Property property : table.getEdgeProperties().values()) {
                if (!edgePropertiesToStore.contains(Pair.of((Object)property.getName(), (Object)property.getType()))) continue;
                edgeProviderBuilder.addVectorProperty(property.getName(), property.getType(), property.getDimension(), null, (Object)currentColumnIndex++);
            }
            if (this.getEdgeStoringConfigs() != null) {
                edgeProviderBuilder.setStoringOptions(this.getEdgeStoringConfigs().get(name));
            } else if (this.getNumPartitions() > 0) {
                edgeProviderBuilder.setStoringOptions(new FileGraphStoringConfigBuilder(this.getTargetBasePath() + name).setNumPartitions(this.getNumPartitions()).setInitialPartitionIndex(0).setEdgeExtension(this.getTargetFormat().toString()).build());
            } else {
                edgeProviderBuilder.setStoringOptions(new FileGraphStoringConfigBuilder(this.getTargetBasePath() + name).setEdgeExtension(this.getTargetFormat().toString()).build());
            }
            edgeProviderBuilder.setKeyType(keyType);
            builder.addEdgeProvider((AbstractEntityProviderConfigBuilder)edgeProviderBuilder);
        });
        return (PartitionedGraphConfig)builder.build();
    }

    private Set<Pair<String, PropertyType>> asPropertyNameAndTypePairs(Collection<? extends oracle.pgx.api.Property<?, ?, ?>> properties) {
        return properties.stream().map(property -> Pair.of((Object)property.getName(), (Object)property.getType())).collect(Collectors.toSet());
    }

    public PartitionedGraphConfigGenerationContext setTargetFormat(ProviderFormat targetFormat) {
        this.targetFormat = targetFormat;
        return this;
    }

    public PartitionedGraphConfigGenerationContext setTargetBasePath(String targetBasePath) {
        this.targetBasePath = targetBasePath;
        return this;
    }

    public PartitionedGraphConfigGenerationContext setNumPartitions(int numPartitions) {
        this.numPartitions = numPartitions;
        return this;
    }

    public PartitionedGraphConfigGenerationContext setVertexStoringConfigs(Map<String, FileGraphStoringConfig> vertexStoringConfigs) {
        this.vertexStoringConfigs = vertexStoringConfigs;
        return this;
    }

    public PartitionedGraphConfigGenerationContext setEdgeStoringConfigs(Map<String, FileGraphStoringConfig> edgeStoringConfigs) {
        this.edgeStoringConfigs = edgeStoringConfigs;
        return this;
    }

    public PartitionedGraphConfigGenerationContext setGraph(Graph graph) {
        this.graph = graph;
        return this;
    }

    public PartitionedGraphConfigGenerationContext setVertexIdType(IdType vertexIdType) {
        this.vertexIdType = vertexIdType;
        return this;
    }

    public PartitionedGraphConfigGenerationContext setEdgeIdType(IdType edgeIdType) {
        this.edgeIdType = edgeIdType;
        return this;
    }

    public PartitionedGraphConfigGenerationContext setVertexIdStrategy(IdStrategy vertexIdStrategy) {
        this.vertexIdStrategy = vertexIdStrategy;
        return this;
    }

    public PartitionedGraphConfigGenerationContext setEdgeIdStrategy(IdStrategy edgeIdStrategy) {
        this.edgeIdStrategy = edgeIdStrategy;
        return this;
    }

    public PartitionedGraphConfigGenerationContext setVertexProperties(Collection<VertexProperty<?, ?>> vertexProperties) {
        this.vertexProperties = vertexProperties;
        return this;
    }

    public PartitionedGraphConfigGenerationContext setEdgeProperties(Collection<EdgeProperty<?>> edgeProperties) {
        this.edgeProperties = edgeProperties;
        return this;
    }

    public PartitionedGraphConfigGenerationContext setVertexProvidersToStore(Set<String> vertexProvidersToStore) {
        this.vertexProvidersToStore = vertexProvidersToStore;
        return this;
    }

    public PartitionedGraphConfigGenerationContext setEdgeProvidersToStore(Set<String> edgeProvidersToStore) {
        this.edgeProvidersToStore = edgeProvidersToStore;
        return this;
    }

    ProviderFormat getTargetFormat() {
        return this.targetFormat;
    }

    String getTargetBasePath() {
        return this.targetBasePath;
    }

    int getNumPartitions() {
        return this.numPartitions;
    }

    Map<String, FileGraphStoringConfig> getVertexStoringConfigs() {
        return this.vertexStoringConfigs;
    }

    Map<String, FileGraphStoringConfig> getEdgeStoringConfigs() {
        return this.edgeStoringConfigs;
    }

    Graph getGraph() {
        return this.graph;
    }

    IdType getVertexIdType() {
        return this.vertexIdType;
    }

    IdType getEdgeIdType() {
        return this.edgeIdType;
    }

    IdStrategy getVertexIdStrategy() {
        return this.vertexIdStrategy;
    }

    IdStrategy getEdgeIdStrategy() {
        return this.edgeIdStrategy;
    }

    Collection<VertexProperty<?, ?>> getVertexProperties() {
        return this.vertexProperties;
    }

    Collection<EdgeProperty<?>> getEdgeProperties() {
        return this.edgeProperties;
    }

    Set<String> getVertexProvidersToStore() {
        return this.vertexProvidersToStore;
    }

    Set<String> getEdgeProvidersToStore() {
        return this.edgeProvidersToStore;
    }
}

