/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgql.lang;

import com.google.common.collect.Lists;
import com.google.inject.Module;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import oracle.pgql.lang.PgqlConfig;
import oracle.pgql.lang.PgqlException;
import oracle.pgql.lang.PgqlResult;
import oracle.pgql.lang.PgqlVersion;
import oracle.pgql.lang.completion.PgqlCompletionGenerator;
import oracle.pgql.lang.editor.completion.PgqlCompletion;
import oracle.pgql.lang.editor.completion.PgqlCompletionContext;
import oracle.pgql.lang.ir.PgqlStatement;
import oracle.pgql.lang.ir.StatementType;
import oracle.pgql.lang.metadata.AbstractMetadataProvider;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.vfs2.FileObject;
import org.metaborg.core.MetaborgException;
import org.metaborg.core.completion.ICompletion;
import org.metaborg.core.config.IProjectConfig;
import org.metaborg.core.config.ISourceConfig;
import org.metaborg.core.language.ILanguageImpl;
import org.metaborg.core.language.LanguageIdentifier;
import org.metaborg.core.language.LanguageUtils;
import org.metaborg.core.messages.IMessage;
import org.metaborg.core.project.IProject;
import org.metaborg.core.project.Project;
import org.metaborg.core.source.AffectedSourceHelper;
import org.metaborg.core.source.ISourceRegion;
import org.metaborg.core.syntax.IInputUnit;
import org.metaborg.core.syntax.IParseUnit;
import org.metaborg.core.syntax.ParseException;
import org.metaborg.spoofax.core.Spoofax;
import org.metaborg.spoofax.core.SpoofaxModule;
import org.metaborg.spoofax.core.unit.ISpoofaxInputUnit;
import org.metaborg.spoofax.core.unit.ISpoofaxParseUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoInt;
import org.spoofax.interpreter.terms.IStrategoString;
import org.spoofax.interpreter.terms.IStrategoTerm;

public class Pgql
implements Closeable {
    private static final Object lock = new Object();
    private static final Set<Pgql> instances = new HashSet<Pgql>();
    private static final Logger LOG = LoggerFactory.getLogger(Pgql.class);
    private static final String NON_BREAKING_WHITE_SPACE_ERROR = "Illegal character '\u00a0' (non-breaking white space); use a normal space instead";
    private static final String ERROR_MESSSAGE_INDENTATION = "\t";
    private static final String SPOOFAX_BINARIES = "pgql.spoofax-language";
    private static final int POS_QUERY_ANNOTATIONS = 9;
    private static final int POS_PGQL_VERSION = 1;
    private static final int POS_BIND_VARIABLE_COUNT = 2;
    private static final int POS_SELECTING_ALL_PROPERTIES = 3;
    private static final PgqlVersion LATEST_VERSION = PgqlVersion.V_1_3_OR_UP;
    private static String ALLOW_REFERENCING_ANY_PROPERTY_FLAG = "/*ALLOW_REFERENCING_ANY_PROPERTY*/";
    private static boolean isGloballyInitialized = false;
    private static Spoofax spoofax;
    private static ILanguageImpl pgqlLang;
    private static FileObject dummyProjectDir;
    private static IProject dummyProject;
    private static File spoofaxBinaryFile;
    private boolean isInitialized;

    public Pgql() throws PgqlException {
        this(new PgqlConfig(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pgql(SpoofaxModule module, String tmpDir) throws PgqlException {
        Object object = lock;
        synchronized (object) {
            if (!isGloballyInitialized) {
                this.initializeGlobalInstance(module, tmpDir);
            }
            instances.add(this);
            this.isInitialized = true;
        }
    }

    private void initializeGlobalInstance(SpoofaxModule spoofaxModule, String tmpDir) throws PgqlException {
        try {
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                Object object = lock;
                synchronized (object) {
                    if (isGloballyInitialized) {
                        instances.clear();
                        this.cleanUp();
                    }
                }
            }));
            spoofax = new Spoofax(spoofaxModule, new Module[0]);
            spoofax.configureAsHeadlessApplication();
            URL inputUrl = this.getClass().getResource("/pgql.spoofax-language");
            spoofaxBinaryFile = tmpDir == null ? File.createTempFile(SPOOFAX_BINARIES, UUID.randomUUID().toString()) : new File(tmpDir, SPOOFAX_BINARIES + UUID.randomUUID());
            FileUtils.copyURLToFile((URL)inputUrl, (File)spoofaxBinaryFile);
            FileObject fileObject = Pgql.spoofax.resourceService.resolve(spoofaxBinaryFile.getAbsolutePath());
            Set languages = Pgql.spoofax.languageDiscoveryService.languagesFromArchive(fileObject);
            Set components = LanguageUtils.toComponents((Iterable)languages);
            Set implementations = LanguageUtils.toImpls((Iterable)components);
            pgqlLang = LanguageUtils.active((Iterable)implementations);
            assert (pgqlLang != null);
            dummyProjectDir = Pgql.spoofax.resourceService.resolve("ram://pgql/");
            final LanguageIdentifier id = pgqlLang.id();
            dummyProject = new Project(dummyProjectDir, new IProjectConfig(){

                public Collection<LanguageIdentifier> sourceDeps() {
                    HashSet<LanguageIdentifier> sourceDeps = new HashSet<LanguageIdentifier>();
                    sourceDeps.add(id);
                    return sourceDeps;
                }

                public Collection<LanguageIdentifier> javaDeps() {
                    return Collections.emptySet();
                }

                public Collection<LanguageIdentifier> compileDeps() {
                    return Collections.emptySet();
                }

                public String metaborgVersion() {
                    return null;
                }

                public Collection<ISourceConfig> sources() {
                    return Collections.emptySet();
                }
            });
            this.parseInternal("SELECT * FROM MATCH (initQuery)", null);
        }
        catch (IOException | MetaborgException e) {
            throw new PgqlException("Failed to initialize PGQL", e);
        }
        isGloballyInitialized = true;
    }

    public PgqlResult parse(String queryString) throws PgqlException {
        return this.parse(queryString, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PgqlResult parse(String queryString, AbstractMetadataProvider metadataProvider) throws PgqlException {
        Object object = lock;
        synchronized (object) {
            this.checkInitialized();
            return this.parseInternal(queryString, metadataProvider);
        }
    }

    private void checkInitialized() throws PgqlException {
        if (!this.isInitialized) {
            throw new PgqlException("Pgql instance was closed");
        }
    }

    /*
     * Exception decompiling
     */
    private PgqlResult parseInternal(String queryString, AbstractMetadataProvider metadataProvider) throws PgqlException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[CATCHBLOCK]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void checkNoMessages(Iterable<IMessage> messages, String queryString) {
        if (messages.iterator().hasNext()) {
            String prettyMessages = Pgql.getMessages(messages, queryString);
            throw new IllegalStateException("Error messages not expected: " + prettyMessages);
        }
    }

    private PgqlVersion getPgqlVersion(IStrategoTerm queryAnnotations, PgqlStatement statement) {
        PgqlVersion pgqlVersion;
        String pgqlVersionString;
        if (statement == null || statement.getStatementType() != StatementType.SELECT && statement.getStatementType() != StatementType.GRAPH_MODIFY) {
            return LATEST_VERSION;
        }
        switch (pgqlVersionString = ((IStrategoString)queryAnnotations.getSubterm(1)).stringValue()) {
            case "v1.0": {
                pgqlVersion = PgqlVersion.V_1_0;
                break;
            }
            case "v1.1": {
                pgqlVersion = PgqlVersion.V_1_1_OR_V_1_2;
                break;
            }
            case "v1.3": {
                pgqlVersion = PgqlVersion.V_1_3_OR_UP;
                break;
            }
            default: {
                throw new IllegalArgumentException("Version not recognized: " + pgqlVersionString);
            }
        }
        return pgqlVersion;
    }

    private int getBindVariableCount(IStrategoTerm queryAnnotations, PgqlStatement statement) {
        if (statement == null) {
            return 0;
        }
        if (statement.getStatementType() == StatementType.SELECT || statement.getStatementType() == StatementType.GRAPH_MODIFY) {
            return ((IStrategoInt)queryAnnotations.getSubterm(2)).intValue();
        }
        return 0;
    }

    private boolean querySelectsAllProperties(IStrategoTerm queryAnnotations, PgqlStatement statement) {
        if (statement == null) {
            return false;
        }
        if (statement.getStatementType() == StatementType.SELECT || statement.getStatementType() == StatementType.GRAPH_MODIFY) {
            IStrategoAppl selectingAllPropertiesT = (IStrategoAppl)queryAnnotations.getSubterm(3);
            return selectingAllPropertiesT.getConstructor().getName().equals("True");
        }
        return false;
    }

    private FileObject getFileObject(String queryString) throws UnsupportedEncodingException, IOException {
        String randomFileName = UUID.randomUUID().toString() + ".pgql";
        FileObject dummyFile = Pgql.spoofax.resourceService.resolve(dummyProjectDir, randomFileName);
        try (OutputStream out = dummyFile.getContent().getOutputStream();){
            IOUtils.write((byte[])queryString.getBytes("UTF-8"), (OutputStream)out);
        }
        return dummyFile;
    }

    private ISpoofaxParseUnit parseHelper(String queryString, FileObject fileObject) throws ParseException {
        ISpoofaxInputUnit input = (ISpoofaxInputUnit)Pgql.spoofax.unitService.inputUnit(fileObject, queryString, pgqlLang, null);
        return (ISpoofaxParseUnit)Pgql.spoofax.syntaxService.parse((IInputUnit)input);
    }

    private static void quietlyDelete(FileObject fo) {
        try {
            if (fo != null && fo.exists() && !fo.delete()) {
                LOG.warn("failed to delete temporary query file: " + fo.getURL().toString());
            }
        }
        catch (IOException e) {
            LOG.warn("got error while trying to delete temporary query file", (Throwable)e);
        }
    }

    private Iterable<ICompletion> spoofaxComplete(ISpoofaxParseUnit parseResult, int cursor) {
        try {
            return Pgql.spoofax.completionService.get(cursor, (IParseUnit)parseResult, false);
        }
        catch (MetaborgException e) {
            LOG.debug("spoofax completion failed: " + e.getMessage());
            return Collections.emptyList();
        }
    }

    private static String getMessages(Iterable<IMessage> messages, String sourceText) {
        StringBuilder sb = new StringBuilder();
        int lineNumber = -1;
        Iterator it = Lists.reverse((List)Lists.newArrayList(messages.iterator())).iterator();
        while (it.hasNext()) {
            String m;
            String affectedSourceText;
            int startRow;
            IMessage message = (IMessage)it.next();
            if (message.region() != null && lineNumber != (startRow = message.region().startRow() + 1)) {
                if (lineNumber != -1) {
                    sb.append("\n");
                }
                lineNumber = startRow;
                sb.append("Error(s) in line " + startRow + ":");
            }
            try {
                affectedSourceText = AffectedSourceHelper.affectedSourceText((ISourceRegion)message.region(), (String)sourceText, (String)ERROR_MESSSAGE_INDENTATION);
            }
            catch (NullPointerException e) {
                affectedSourceText = null;
            }
            sb.append("\n\n");
            if (affectedSourceText != null) {
                sb.append(affectedSourceText);
            }
            if ((m = message.message()).contains("\u00a0")) {
                m = NON_BREAKING_WHITE_SPACE_ERROR;
            }
            sb.append(ERROR_MESSSAGE_INDENTATION + m);
            if (!it.hasNext()) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    public List<PgqlCompletion> complete(String queryString, int cursor, PgqlCompletionContext ctx) throws PgqlException {
        PgqlResult pgqlResult = null;
        try {
            pgqlResult = this.parse(queryString);
        }
        catch (PgqlException pgqlException) {
            // empty catch block
        }
        Iterable<ICompletion> spoofaxCompletions = null;
        return PgqlCompletionGenerator.generate(pgqlResult, spoofaxCompletions, queryString, cursor, ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = lock;
        synchronized (object) {
            this.isInitialized = false;
            instances.remove(this);
            if (instances.isEmpty()) {
                this.cleanUp();
            }
        }
    }

    private void cleanUp() {
        LOG.info("closing the global PGQL instance");
        isGloballyInitialized = false;
        if (System.getProperty("os.name").startsWith("Windows")) {
            return;
        }
        if (spoofax != null) {
            spoofax.close();
        }
        if (spoofaxBinaryFile != null && !spoofaxBinaryFile.delete()) {
            LOG.warn("failed to delete Spoofax binary file: " + spoofaxBinaryFile.getAbsolutePath());
        }
    }
}

