/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms;

import java.util.Date;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import oracle.pg.rdbms.AdbGraphClientConfiguration;
import oracle.pg.rdbms.exception.JobFailedException;
import oracle.pg.rdbms.exception.JobTimeoutException;
import oracle.pg.rdbms.internal.adb.GraphStudioClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Job
extends CompletableFuture<Void> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Job.class);
    private GraphStudioClient client;
    private long id;
    private String name;
    private String description;
    private Type type;
    private Status status;
    private String createdBy;
    private String error;
    private List<LogEntry> logEntries;

    public Job poll() {
        if (this.isDone()) {
            log.debug("future is already set to 'done'. Do nothing.");
            return this;
        }
        if (!this.status.isRunning()) {
            log.debug("job has completed with status {}. Do nothing.", (Object)this.status);
            return this;
        }
        AdbGraphClientConfiguration config = this.client.getConfig();
        long jobPollIntervalMillis = config.getJobPollIntervalTimeUnit().toMillis(config.getJobPollInterval());
        log.info("starting polling job ID = {} (poll interval = {}ms)", (Object)this.id, (Object)jobPollIntervalMillis);
        this.client.getExecutorService().submit(() -> {
            do {
                try {
                    Job job = this.client.getJob(this.id);
                    this.status = job.getStatus();
                    log.info("job ID = {} retrieved status = {}", (Object)this.id, (Object)this.status);
                    this.error = job.getError();
                    this.logEntries = job.getLogEntries();
                    if (!this.status.isRunning()) {
                        this.completeFuture(job);
                    }
                    Thread.sleep(jobPollIntervalMillis);
                }
                catch (Exception e) {
                    this.completeExceptionally(e);
                }
            } while (this.status.isRunning());
        });
        return this;
    }

    private void completeFuture(Job job) {
        switch (job.getStatus()) {
            case FAILED: {
                log.info("job ID = {} completing future exceptionally with error = {}", (Object)this.id, (Object)job.getError());
                this.completeExceptionally(new JobFailedException(job.getError()));
                return;
            }
            case TIMED_OUT: {
                log.info("job ID = {} completing future exceptionally with timeout", (Object)this.id);
                this.completeExceptionally(new JobTimeoutException("job timed out"));
                return;
            }
            case CANCELLED: {
                log.info("job ID = {} cancelling future", (Object)this.id);
                super.cancel(true);
                return;
            }
        }
        log.info("job ID = {} completing future", (Object)this.id);
        this.complete(null);
    }

    @Generated
    public Job(GraphStudioClient client, long id, String name, String description, Type type, Status status, String createdBy, String error, List<LogEntry> logEntries) {
        this.client = client;
        this.id = id;
        this.name = name;
        this.description = description;
        this.type = type;
        this.status = status;
        this.createdBy = createdBy;
        this.error = error;
        this.logEntries = logEntries;
    }

    @Generated
    public GraphStudioClient getClient() {
        return this.client;
    }

    @Generated
    public long getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Type getType() {
        return this.type;
    }

    @Generated
    public Status getStatus() {
        return this.status;
    }

    @Generated
    public String getCreatedBy() {
        return this.createdBy;
    }

    @Generated
    public String getError() {
        return this.error;
    }

    @Generated
    public List<LogEntry> getLogEntries() {
        return this.logEntries;
    }

    public static class LogEntry {
        private Date timestamp;
        private String message;

        @Generated
        public LogEntry(Date timestamp, String message) {
            this.timestamp = timestamp;
            this.message = message;
        }

        @Generated
        public Date getTimestamp() {
            return this.timestamp;
        }

        @Generated
        public String getMessage() {
            return this.message;
        }
    }

    public static enum Status {
        CANCELLING(true),
        CANCELLED(false),
        FAILED(false),
        FINISHED(false),
        STARTED(true),
        TIMED_OUT(false);

        boolean running;

        @Generated
        private Status(boolean running) {
            this.running = running;
        }

        @Generated
        public boolean isRunning() {
            return this.running;
        }
    }

    public static enum Type {
        ENVIRONMENT_CREATION,
        ENVIRONMENT_STOP,
        ENVIRONMENT_RESTART;

    }
}

