/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgql.lang.ir;

import java.util.List;
import oracle.pgql.lang.ir.CommonPathExpression;
import oracle.pgql.lang.ir.GraphPattern;
import oracle.pgql.lang.ir.GroupBy;
import oracle.pgql.lang.ir.OrderBy;
import oracle.pgql.lang.ir.PgqlStatement;
import oracle.pgql.lang.ir.PgqlUtils;
import oracle.pgql.lang.ir.Projection;
import oracle.pgql.lang.ir.QueryExpression;
import oracle.pgql.lang.ir.QueryExpressionVisitor;
import oracle.pgql.lang.ir.QueryType;
import oracle.pgql.lang.ir.SchemaQualifiedName;
import oracle.pgql.lang.ir.TableExpression;
import oracle.pgql.lang.ir.TableExpressionType;

public abstract class GraphQuery
implements PgqlStatement {
    private List<CommonPathExpression> commonPathExpressions;
    private SchemaQualifiedName graphName;
    private List<TableExpression> tableExpressions;
    private GroupBy groupBy;
    private QueryExpression having;
    private OrderBy orderBy;
    private QueryExpression limit;
    private QueryExpression offset;

    protected GraphQuery(List<CommonPathExpression> commonPathExpressions, SchemaQualifiedName graphName, List<TableExpression> tableExpressions, GroupBy groupBy, QueryExpression having, OrderBy orderBy, QueryExpression limit, QueryExpression offset) {
        this.commonPathExpressions = commonPathExpressions;
        this.graphName = graphName;
        this.tableExpressions = tableExpressions;
        this.groupBy = groupBy;
        this.having = having;
        this.orderBy = orderBy;
        this.limit = limit;
        this.offset = offset;
    }

    public abstract QueryType getQueryType();

    public List<CommonPathExpression> getCommonPathExpressions() {
        return this.commonPathExpressions;
    }

    public void setCommonPathExpressions(List<CommonPathExpression> commonPathExpressions) {
        this.commonPathExpressions = commonPathExpressions;
    }

    @Deprecated
    public abstract Projection getProjection();

    @Deprecated
    public abstract void setProjection(Projection var1);

    @Deprecated
    public String getInputGraphName() {
        return this.graphName == null ? null : this.graphName.getName();
    }

    @Deprecated
    public void setInputGraphName(String inputGraphName) {
        if (this.graphName == null) {
            this.graphName = new SchemaQualifiedName(null, inputGraphName);
        } else {
            this.graphName.setName(inputGraphName);
        }
    }

    public SchemaQualifiedName getGraphName() {
        return this.graphName;
    }

    public void setGraphName(SchemaQualifiedName graphName) {
        this.graphName = graphName;
    }

    public GraphPattern getGraphPattern() {
        this.guaranteeQueryHasAtMostSingleGraphPattern();
        if (this.tableExpressions.isEmpty()) {
            return null;
        }
        return (GraphPattern)this.tableExpressions.get(0);
    }

    public void setGraphPattern(GraphPattern graphPattern) {
        this.guaranteeQueryHasAtMostSingleGraphPattern();
        this.tableExpressions.set(0, graphPattern);
    }

    public List<TableExpression> getTableExpressions() {
        return this.tableExpressions;
    }

    public void setTableExpressions(List<TableExpression> tableExpressions) {
        this.tableExpressions = tableExpressions;
    }

    public GroupBy getGroupBy() {
        return this.groupBy;
    }

    public void setGroupBy(GroupBy groupBy) {
        this.groupBy = groupBy;
    }

    public QueryExpression getHaving() {
        return this.having;
    }

    public void setHaving(QueryExpression having) {
        this.having = having;
    }

    public OrderBy getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(OrderBy orderBy) {
        this.orderBy = orderBy;
    }

    public QueryExpression getLimit() {
        return this.limit;
    }

    public void setLimit(QueryExpression limit) {
        this.limit = limit;
    }

    public QueryExpression getOffset() {
        return this.offset;
    }

    public void setOffset(QueryExpression offset) {
        this.offset = offset;
    }

    public String toString() {
        return PgqlUtils.printPgqlString(this);
    }

    public int hashCode() {
        return 31;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GraphQuery other = (GraphQuery)obj;
        if (this.commonPathExpressions == null ? other.commonPathExpressions != null : !this.commonPathExpressions.equals(other.commonPathExpressions)) {
            return false;
        }
        if (this.graphName == null ? other.graphName != null : !this.graphName.equals(other.graphName)) {
            return false;
        }
        if (this.groupBy == null ? other.groupBy != null : !this.groupBy.equals(other.groupBy)) {
            return false;
        }
        if (this.having == null ? other.having != null : !this.having.equals(other.having)) {
            return false;
        }
        if (this.limit == null ? other.limit != null : !this.limit.equals(other.limit)) {
            return false;
        }
        if (this.offset == null ? other.offset != null : !this.offset.equals(other.offset)) {
            return false;
        }
        if (this.orderBy == null ? other.orderBy != null : !this.orderBy.equals(other.orderBy)) {
            return false;
        }
        return !(this.tableExpressions == null ? other.tableExpressions != null : !this.tableExpressions.equals(other.tableExpressions));
    }

    public abstract void accept(QueryExpressionVisitor var1);

    private void guaranteeQueryHasAtMostSingleGraphPattern() {
        if (this.tableExpressions.size() == 0) {
            return;
        }
        if (this.tableExpressions.get(0).getTableExpressionType() != TableExpressionType.GRAPH_PATTERN) {
            throw new UnsupportedOperationException("Subqueries in FROM clause not supported");
        }
    }
}

