/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgql.lang.ddl.propertygraph;

import oracle.pgql.lang.ir.PgqlUtils;
import oracle.pgql.lang.ir.QueryExpression;

public class Property {
    QueryExpression valueExpression;
    String propertyName;

    public Property(QueryExpression valueExpression, String propertyName) {
        this.valueExpression = valueExpression;
        this.propertyName = propertyName;
    }

    public QueryExpression getValueExpression() {
        return this.valueExpression;
    }

    public void setValueExpression(QueryExpression valueExpression) {
        this.valueExpression = valueExpression;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    @Deprecated
    public String getColumnName() {
        if (this.valueExpression.getExpType() == QueryExpression.ExpressionType.VARREF) {
            QueryExpression.VarRef varRef = (QueryExpression.VarRef)this.valueExpression;
            return varRef.getVariable().getName();
        }
        return null;
    }

    public String toString() {
        if (this.getColumnName() != null && this.getColumnName().equals(this.propertyName)) {
            return PgqlUtils.printIdentifier(this.propertyName, false);
        }
        return this.valueExpression + " AS " + PgqlUtils.printIdentifier(this.propertyName, false);
    }

    public int hashCode() {
        return 31;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Property other = (Property)obj;
        if (this.propertyName == null ? other.propertyName != null : !this.propertyName.equals(other.propertyName)) {
            return false;
        }
        return !(this.valueExpression == null ? other.valueExpression != null : !this.valueExpression.equals(other.valueExpression));
    }
}

