/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgql.lang;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import oracle.pgql.lang.PgqlException;
import oracle.pgql.lang.ResultAccess;
import oracle.pgql.lang.ResultSet;
import oracle.pgql.lang.ResultSetMetaData;

public class ResultSetFormatter {
    private static final String NULL_STRING = "<null>";
    private static final long DEFAULT_PRINT_LIMIT = 1000L;

    public static void out(ResultSet<? extends ResultAccess> resultSet, PrintStream printStream, long numResults, int from) throws PgqlException {
        ResultSetFormatter.out(resultSet, printStream, numResults, from, false);
    }

    public static void out(ResultSet<? extends ResultAccess> resultSet) throws PgqlException {
        ResultSetFormatter.out(resultSet, System.out, 1000L, 0, true);
    }

    private static void out(ResultSet<? extends ResultAccess> resultSet, PrintStream printStream, long numResults, int from, boolean truncate) throws PgqlException {
        int i;
        ResultSetMetaData metadata = resultSet.getMetaData();
        int numElements = metadata.getColumnCount();
        int[] columnWidth = new int[numElements];
        for (int i2 = 0; i2 < numElements; ++i2) {
            int length = metadata.getColumnName(i2 + 1).length();
            if (length <= columnWidth[i2]) continue;
            columnWidth[i2] = length;
        }
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        Iterator results = resultSet.iterator();
        for (int i3 = 0; i3 < from; ++i3) {
            if (!results.hasNext()) continue;
            results.next();
        }
        int count = 0;
        while (results.hasNext() && (long)count < numResults) {
            ResultAccess result = (ResultAccess)results.next();
            Object[] row = new Object[numElements];
            rows.add(row);
            for (int i4 = 0; i4 < numElements; ++i4) {
                Object elem;
                row[i4] = elem = result.getObject(i4 + 1);
                int length = ResultSetFormatter.getLengthOfElem(elem);
                if (length <= columnWidth[i4]) continue;
                columnWidth[i4] = length;
            }
            ++count;
        }
        int totalWidth = -1;
        for (int i5 = 0; i5 < numElements; ++i5) {
            totalWidth += columnWidth[i5] + 3;
        }
        String truncationMessage = "";
        int countResults = count;
        if (truncate) {
            while (results.hasNext()) {
                results.next();
                ++countResults;
            }
            if ((long)countResults > numResults) {
                truncationMessage = "... truncated " + ((long)countResults - 1000L) + " rows ...";
                int columnNum = 0;
                while (totalWidth < truncationMessage.length()) {
                    if (columnWidth.length > 0) {
                        int n = columnNum;
                        columnWidth[n] = columnWidth[n] + 1;
                        columnNum = (columnNum + 1) % columnWidth.length;
                    }
                    ++totalWidth;
                }
            }
        }
        ResultSetFormatter.printHorizontalLine(printStream, totalWidth);
        printStream.print("|");
        if (numElements == 0) {
            for (i = 0; i < totalWidth; ++i) {
                printStream.print(" ");
            }
            printStream.print("|");
        } else {
            for (i = 0; i < numElements; ++i) {
                ResultSetFormatter.printElem(printStream, metadata.getColumnName(i + 1), columnWidth[i]);
            }
        }
        printStream.println();
        ResultSetFormatter.printHorizontalLine(printStream, totalWidth);
        for (int idx = 0; idx < count; ++idx) {
            int i6;
            printStream.print("|");
            Object[] row = (Object[])rows.get(idx);
            if (numElements == 0) {
                for (i6 = 0; i6 < totalWidth; ++i6) {
                    printStream.print(" ");
                }
                printStream.print("|");
            } else {
                for (i6 = 0; i6 < numElements; ++i6) {
                    ResultSetFormatter.printElem(printStream, row[i6], columnWidth[i6]);
                }
            }
            printStream.println();
        }
        if (truncate && (long)countResults > numResults) {
            ResultSetFormatter.printTruncationMessage(printStream, totalWidth, truncationMessage);
        } else {
            ResultSetFormatter.printHorizontalLine(printStream, totalWidth);
        }
    }

    private static void printTruncationMessage(PrintStream printStream, int tableWidth, String truncationMessage) {
        String before = "";
        int i = 0;
        while ((double)i < Math.floor((tableWidth - truncationMessage.length()) / 2)) {
            before = before + ".";
            ++i;
        }
        String after = "";
        for (int i2 = 0; i2 < tableWidth - before.length() - truncationMessage.length(); ++i2) {
            after = after + ".";
        }
        printStream.print("+" + before + truncationMessage + after + "+");
        printStream.println();
    }

    private static int getLengthOfElem(Object elem) {
        if (elem == null) {
            return NULL_STRING.length();
        }
        return elem.toString().length();
    }

    private static void printElem(PrintStream printStream, Object elem, int columnWidth) {
        int length = ResultSetFormatter.getLengthOfElem(elem);
        printStream.print(" ");
        if (elem == null) {
            printStream.print(NULL_STRING);
        } else {
            printStream.print(elem.toString());
        }
        for (int i = length; i < columnWidth; ++i) {
            printStream.print(" ");
        }
        printStream.print(" |");
    }

    private static void printHorizontalLine(PrintStream printStream, int length) {
        printStream.print("+");
        for (int i = 0; i < length; ++i) {
            printStream.print("-");
        }
        printStream.println("+");
    }
}

