/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.io.json.genson.datetime;

import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;

class DateTimeUtil {
    private static final long THOUSAND = 1000L;
    private static final long MILLION = 1000000L;
    private static final long BILLION = 1000000000L;
    private static final DateTimeFormatter DEFAULTS = new DateTimeFormatterBuilder().parseDefaulting(ChronoField.YEAR, 2000L).parseDefaulting(ChronoField.MONTH_OF_YEAR, 1L).parseDefaulting(ChronoField.DAY_OF_MONTH, 1L).parseDefaulting(ChronoField.HOUR_OF_DAY, 0L).parseDefaulting(ChronoField.MINUTE_OF_HOUR, 0L).parseDefaulting(ChronoField.SECOND_OF_MINUTE, 0L).parseDefaulting(ChronoField.NANO_OF_SECOND, 0L).toFormatter();

    private DateTimeUtil() {
    }

    static DateTimeFormatter createFormatterWithDefaults(DateTimeFormatter formatter, ZoneId zoneId) {
        if (formatter == DateTimeFormatter.ISO_INSTANT) {
            return formatter;
        }
        DateTimeFormatterBuilder formatterWithDefaultsBuilder = new DateTimeFormatterBuilder().append(formatter).append(DEFAULTS);
        formatterWithDefaultsBuilder.parseDefaulting(ChronoField.OFFSET_SECONDS, OffsetDateTime.now(zoneId).getOffset().getTotalSeconds());
        return formatterWithDefaultsBuilder.toFormatter().withZone(zoneId);
    }

    static long getNanos(long seconds, long nanoAdjustment) {
        return seconds * 1000000000L + nanoAdjustment;
    }

    static long getMillis(long seconds, long nanoAdjustment) {
        return seconds * 1000L + nanoAdjustment / 1000000L;
    }

    static long getSecondsFromMillis(long millis) {
        return millis / 1000L;
    }

    static long getNanosFromMillis(long millis) {
        return millis % 1000L * 1000000L;
    }

    static Instant instantFromMillis(long millis) {
        return Instant.ofEpochMilli(millis);
    }

    static Instant instantFromNanos(long nanos) {
        long seconds = nanos / 1000000000L;
        long adjustment = nanos % 1000000000L;
        return Instant.ofEpochSecond(seconds, adjustment);
    }

    static Long instantToMillis(Instant instant) {
        return instant.toEpochMilli();
    }

    static Long instantToNanos(Instant instant) {
        return DateTimeUtil.getNanos(instant.getEpochSecond(), instant.getNano());
    }

    static OffsetDateTime correctOffset(OffsetDateTime value, ZoneId zoneId) {
        Instant instant = value.toLocalDateTime().atZone(zoneId).toInstant();
        return OffsetDateTime.ofInstant(instant, zoneId);
    }
}

