/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.jcache.partitionedcache.processors;

import com.tangosol.coherence.jcache.common.Helper;
import com.tangosol.coherence.jcache.common.JCacheContext;
import com.tangosol.coherence.jcache.common.JCacheEntryMetaInf;
import com.tangosol.coherence.jcache.common.JCacheIdentifier;
import com.tangosol.coherence.jcache.common.JCacheStatistics;
import com.tangosol.coherence.jcache.partitionedcache.processors.AbstractRemoveProcessor;
import com.tangosol.coherence.jcache.partitionedcache.processors.BinaryEntryHelper;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.net.BackingMapManagerContext;
import com.tangosol.util.Binary;
import com.tangosol.util.BinaryEntry;
import com.tangosol.util.InvocableMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ConditionalRemoveProcessor<K, V>
extends AbstractRemoveProcessor<K, V> {
    private Binary m_binValueOrig;

    public ConditionalRemoveProcessor() {
        this.m_binValueOrig = new Binary();
    }

    public ConditionalRemoveProcessor(Binary binValueOrig, JCacheIdentifier id) {
        super(id);
        this.m_binValueOrig = binValueOrig;
    }

    public Object process(InvocableMap.Entry entry) {
        long ldtStart = Helper.getCurrentTimeMillis();
        BinaryEntry binEntry = (BinaryEntry)entry;
        JCacheContext jcacheCtx = BinaryEntryHelper.getContext(this.m_cacheId, binEntry);
        JCacheStatistics stats = jcacheCtx.getStatistics();
        BackingMapManagerContext ctx = binEntry.getContext();
        Binary binValue = binEntry.isPresent() ? binEntry.getBinaryValue() : null;
        Boolean fResult = Boolean.FALSE;
        if (binEntry.isPresent() && binValue != null) {
            binValue = (Binary)ctx.removeInternalValueDecoration((Object)binValue, 14);
            binValue = (Binary)ctx.removeInternalValueDecoration((Object)binValue, 15);
            if (BinaryEntryHelper.isExpired(binEntry, ldtStart)) {
                BinaryEntryHelper.expireEntry(binEntry);
                fResult = Boolean.FALSE;
                stats.registerMisses(1, ldtStart);
            } else if (binValue.equals((Object)this.m_binValueOrig)) {
                binEntry.remove(false);
                fResult = Boolean.TRUE;
                stats.registerHits(1, ldtStart);
            } else {
                JCacheEntryMetaInf valueMetaInf = BinaryEntryHelper.getValueMetaInf(binEntry);
                valueMetaInf.accessed(ldtStart, jcacheCtx.getExpiryPolicy());
                binValue = BinaryEntryHelper.decorateBinValueWithJCacheMetaInf(binValue, valueMetaInf, ctx);
                binValue = BinaryEntryHelper.jcacheSyntheticUpdateEntry(binValue, ctx);
                binEntry.updateBinaryValue(binValue);
                stats.registerHits(1, ldtStart);
            }
        } else {
            stats.registerMisses(1, ldtStart);
        }
        if (fResult.booleanValue()) {
            stats.registerRemoves(1L, ldtStart);
        }
        return fResult;
    }

    @Override
    public void readExternal(DataInput dataInput) throws IOException {
        super.readExternal(dataInput);
        this.m_binValueOrig.readExternal(dataInput);
    }

    @Override
    public void writeExternal(DataOutput dataOutput) throws IOException {
        super.writeExternal(dataOutput);
        this.m_binValueOrig.writeExternal(dataOutput);
    }

    @Override
    public void readExternal(PofReader pofReader) throws IOException {
        super.readExternal(pofReader);
        this.m_binValueOrig = pofReader.readBinary(2);
    }

    @Override
    public void writeExternal(PofWriter pofWriter) throws IOException {
        super.writeExternal(pofWriter);
        pofWriter.writeBinary(2, this.m_binValueOrig);
    }
}

