/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.jcache;

import com.oracle.coherence.common.base.Logger;
import com.tangosol.coherence.config.Config;
import com.tangosol.coherence.jcache.CoherenceBasedCacheManager;
import com.tangosol.coherence.jcache.CoherenceBasedConfiguration;
import com.tangosol.coherence.jcache.localcache.LocalCacheConfiguration;
import com.tangosol.coherence.jcache.partitionedcache.PartitionedCacheConfiguration;
import com.tangosol.coherence.jcache.passthroughcache.PassThroughCacheConfiguration;
import com.tangosol.coherence.jcache.remotecache.RemoteCacheConfiguration;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.ConfigurableCacheFactory;
import com.tangosol.util.Base;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.cache.CacheException;
import javax.cache.CacheManager;
import javax.cache.configuration.CompleteConfiguration;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.configuration.OptionalFeature;
import javax.cache.spi.CachingProvider;

public class CoherenceBasedCachingProvider
implements CachingProvider {
    private WeakHashMap<ClassLoader, HashMap<URI, CacheManager>> m_mapClzldrToMgrMap;
    private AtomicReference<String> m_defaultConfigurationClassName = new AtomicReference<Object>(null);

    public CoherenceBasedCachingProvider() {
        this.m_mapClzldrToMgrMap = new WeakHashMap();
    }

    public synchronized CacheManager getCacheManager(URI u, ClassLoader cl, Properties p) {
        CacheManager mgr;
        Object eccf = null;
        Properties props = p == null ? this.getDefaultProperties() : p;
        URI uri = u == null ? this.getDefaultURI() : u;
        ClassLoader cldr = cl == null ? this.getDefaultClassLoader() : cl;
        HashMap<URI, Object> mapUriToMgr = this.m_mapClzldrToMgrMap.get(cldr);
        if (mapUriToMgr == null) {
            mapUriToMgr = new HashMap();
        }
        if ((mgr = mapUriToMgr.get(uri)) == null) {
            mgr = this.createCacheMananger(uri, cldr, props);
            mapUriToMgr.put(uri, mgr);
        } else {
            Logger.finest((String)("getCacheManager found existing CacheManager uri=" + String.valueOf(uri) + " classloader=" + String.valueOf(cldr)));
        }
        if (!this.m_mapClzldrToMgrMap.containsKey(cldr)) {
            this.m_mapClzldrToMgrMap.put(cldr, mapUriToMgr);
        }
        return mgr;
    }

    public ClassLoader getDefaultClassLoader() {
        return Base.getContextClassLoader();
    }

    public URI getDefaultURI() {
        String kind = Config.getProperty((String)"coherence.jcache.configuration.classname");
        boolean fExtendEnabled = CoherenceBasedCachingProvider.isExtendClient(kind);
        String uri = Config.getProperty((String)"coherence.cacheconfig", (String)(fExtendEnabled ? "coherence-jcache-extendclient-cache-config.xml" : "coherence-jcache-cache-config.xml"));
        try {
            return new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new CacheException("Failed to create the default URI for the javax.cache CoherenceAdapter Implementation", (Throwable)e);
        }
    }

    public Properties getDefaultProperties() {
        return new Properties();
    }

    public CacheManager getCacheManager(URI uri, ClassLoader cl) {
        return this.getCacheManager(uri, cl, this.getDefaultProperties());
    }

    public CacheManager getCacheManager() {
        return this.getCacheManager(null, null, null);
    }

    public synchronized void close() {
        WeakHashMap<ClassLoader, HashMap<URI, CacheManager>> mapClassLoaderToMgrMap = this.m_mapClzldrToMgrMap;
        this.m_mapClzldrToMgrMap = new WeakHashMap();
        for (Map.Entry<ClassLoader, HashMap<URI, CacheManager>> entry : mapClassLoaderToMgrMap.entrySet()) {
            for (CacheManager mgr : entry.getValue().values()) {
                mgr.close();
            }
        }
        this.m_defaultConfigurationClassName = new AtomicReference<Object>(null);
    }

    public synchronized void close(ClassLoader cl) {
        ClassLoader clzldr = cl == null ? this.getDefaultClassLoader() : cl;
        HashMap<URI, CacheManager> mapUriToMgrs = this.m_mapClzldrToMgrMap.remove(clzldr);
        if (mapUriToMgrs != null) {
            for (CacheManager mgr : mapUriToMgrs.values()) {
                mgr.close();
            }
        }
    }

    public synchronized void close(URI u, ClassLoader cl) {
        URI uri = u == null ? this.getDefaultURI() : u;
        ClassLoader clzldr = cl == null ? this.getDefaultClassLoader() : cl;
        HashMap<URI, CacheManager> mapUriToMgr = this.m_mapClzldrToMgrMap.get(clzldr);
        if (mapUriToMgr != null) {
            CacheManager mgr = mapUriToMgr.remove(uri);
            if (mgr != null) {
                mgr.close();
            }
            if (mapUriToMgr.size() == 0) {
                this.m_mapClzldrToMgrMap.remove(clzldr);
            }
        }
    }

    public boolean isSupported(OptionalFeature feature) {
        switch (feature) {
            case STORE_BY_REFERENCE: {
                String defaultConfigurationClassName = this.getDefaultCoherenceBasedConfigurationClassName();
                return defaultConfigurationClassName.contains("LocalCacheConfiguration");
            }
        }
        return false;
    }

    public synchronized void release(ClassLoader c, URI u) {
        URI uri = u == null ? this.getDefaultURI() : u;
        ClassLoader cl = c == null ? this.getDefaultClassLoader() : c;
        HashMap<URI, CacheManager> mapUriToMgr = this.m_mapClzldrToMgrMap.get(cl);
        if (mapUriToMgr != null) {
            mapUriToMgr.remove(uri);
            if (mapUriToMgr.size() == 0) {
                this.m_mapClzldrToMgrMap.remove(cl);
            }
        }
    }

    protected CacheManager createCacheMananger(URI uri, ClassLoader classLoader, Properties properties) {
        if (uri == null) {
            uri = this.getDefaultURI();
        }
        if (properties == null) {
            properties = this.getDefaultProperties();
        }
        if (classLoader == null) {
            classLoader = this.getDefaultClassLoader();
        }
        String sURI = uri.toString();
        try {
            if (Logger.isEnabled((int)6)) {
                Logger.finer((String)("ConfigurableCacheFactory being configured using configuration file=[" + sURI + "] classloader=" + String.valueOf(classLoader)));
            }
            ConfigurableCacheFactory ccf = CacheFactory.getCacheFactoryBuilder().getConfigurableCacheFactory(sURI, classLoader);
            Logger.info((String)("getConfigurableCacheFactory returned ccf=" + String.valueOf(ccf) + " classLoader Hierarchy=" + CoherenceBasedCachingProvider.toStringClassLoaderHierachy(classLoader)));
            assert (ccf != null);
            CoherenceBasedCacheManager mgr = new CoherenceBasedCacheManager(this, ccf, uri, classLoader, properties);
            return mgr;
        }
        catch (RuntimeException e) {
            throw new CacheException("Error processing " + sURI, (Throwable)e);
        }
    }

    private static String toStringClassLoaderHierachy(ClassLoader ldr) {
        StringBuilder bldr = new StringBuilder("Child ");
        ClassLoader next = ldr;
        do {
            bldr.append("ClassLoader[hashcode=").append(next.hashCode() + "] [classloader=" + String.valueOf(next) + "]");
            next = next.getParent();
            if (next == null) continue;
            bldr.append(" Parent");
        } while (next != null);
        return bldr.toString();
    }

    protected <K, V> CoherenceBasedConfiguration<K, V> convertConfiguration(Configuration<K, V> cfg, ClassLoader classLoader) {
        if (cfg instanceof CoherenceBasedConfiguration) {
            return (CoherenceBasedConfiguration)cfg;
        }
        if (cfg instanceof CompleteConfiguration) {
            CompleteConfiguration cfgComplete = (CompleteConfiguration)cfg;
            String sClassName = this.getDefaultCoherenceBasedConfigurationClassName();
            try {
                Class<?> clsConfiguration = classLoader.loadClass(sClassName);
                if (CoherenceBasedConfiguration.class.isAssignableFrom(clsConfiguration)) {
                    Constructor<?> constructor = clsConfiguration.getConstructor(CompleteConfiguration.class);
                    return (CoherenceBasedConfiguration)constructor.newInstance(cfgComplete);
                }
                throw new ClassCastException("The specified configuration class [" + sClassName + "] does not implement " + CoherenceBasedConfiguration.class.getCanonicalName());
            }
            catch (ClassNotFoundException e) {
                throw new UnsupportedOperationException("Failed to load the specified configuration class [" + sClassName + "]", e);
            }
            catch (NoSuchMethodException e) {
                throw new UnsupportedOperationException("The specified configuration class [" + sClassName + "] does not have a public constructor taking a single CompleteConfiguration argument", e);
            }
            catch (InstantiationException e) {
                throw new UnsupportedOperationException("The specified configuration class [" + sClassName + "] could not be instantiated", e);
            }
            catch (IllegalAccessException e) {
                throw new UnsupportedOperationException("The specified configuration class [" + sClassName + "] is not accessible", e);
            }
            catch (InvocationTargetException e) {
                throw new UnsupportedOperationException("The specified configuration class [" + sClassName + "] could not be instantiated", e);
            }
        }
        Logger.warn((String)("CoherenceBasedCachingProvider: Ignoring unknown configuration class " + cfg.getClass().getCanonicalName() + " defaulting to basic javax.cache.configuration.MutableConfiguration initialized with base javax.cache.configuration.Configuration values taken from configuration parameter."));
        MutableConfiguration cfgMutable = new MutableConfiguration();
        cfgMutable.setTypes(cfg.getKeyType(), cfg.getValueType());
        cfgMutable.setStoreByValue(cfg.isStoreByValue());
        return this.convertConfiguration((Configuration<K, V>)cfgMutable, classLoader);
    }

    public String getDefaultCoherenceBasedConfigurationClassName() {
        if (this.m_defaultConfigurationClassName.get() == null) {
            String sClassName = Config.getProperty((String)"coherence.jcache.configuration.classname", (String)LocalCacheConfiguration.class.getCanonicalName());
            if (sClassName.equalsIgnoreCase("local")) {
                sClassName = LocalCacheConfiguration.class.getCanonicalName();
            } else if (sClassName.equalsIgnoreCase("partitioned")) {
                sClassName = PartitionedCacheConfiguration.class.getCanonicalName();
            } else if (sClassName.equals("passthrough")) {
                sClassName = PassThroughCacheConfiguration.class.getCanonicalName();
            } else if (sClassName.equalsIgnoreCase("extend") || sClassName.equalsIgnoreCase("remote")) {
                sClassName = RemoteCacheConfiguration.class.getCanonicalName();
            }
            boolean result = this.m_defaultConfigurationClassName.compareAndSet(null, sClassName);
            if (result) {
                Logger.info((String)("Mapping general javax.cache.Configuration implementation to CoherenceBased JCacheConfiguration of " + sClassName));
            }
        }
        return this.m_defaultConfigurationClassName.get();
    }

    private static boolean isExtendClient(String defaultJCacheConfigurationClass) {
        return defaultJCacheConfigurationClass != null && (defaultJCacheConfigurationClass.equalsIgnoreCase("remote") || defaultJCacheConfigurationClass.equalsIgnoreCase("extend") || defaultJCacheConfigurationClass.equalsIgnoreCase("com.tangosol.coherence.jcache.remotecache.RemoteConfiguration"));
    }
}

