/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.jcache.partitionedcache;

import com.oracle.coherence.common.base.Logger;
import com.oracle.coherence.common.util.Duration;
import com.tangosol.coherence.config.Config;
import com.tangosol.coherence.jcache.common.AbstractJCacheStatistics;
import com.tangosol.coherence.jcache.common.ContextJCacheStatistics;
import com.tangosol.coherence.jcache.common.Helper;
import com.tangosol.coherence.jcache.common.JCacheContext;
import com.tangosol.coherence.jcache.common.JCacheIdentifier;
import com.tangosol.coherence.jcache.common.JCacheStatistics;
import com.tangosol.coherence.jcache.partitionedcache.PartitionedCache;
import com.tangosol.coherence.jcache.partitionedcache.processors.BinaryEntryHelper;
import com.tangosol.coherence.jcache.partitionedcache.processors.GetPartitionCountEP;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.net.NamedCache;
import com.tangosol.net.partition.SimplePartitionKey;
import com.tangosol.util.BinaryEntry;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.extractor.AbstractExtractor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public class PartitionedJCacheStatistics
extends AbstractJCacheStatistics {
    private static final long NOT_SET = -1L;
    private NamedCache m_ncache;
    private AbstractExtractor m_extractor;
    private ContextJCacheStatistics m_stats = null;
    private long m_ldtLastRefresh = 0L;
    private long m_cRefreshFrequencyMillis = -1L;
    private Collection<SimplePartitionKey> m_keys = null;

    public PartitionedJCacheStatistics() {
        this.m_ncache = null;
        this.m_extractor = null;
    }

    public PartitionedJCacheStatistics(PartitionedCache cache) {
        this.m_extractor = new CacheStatisticsExtractor(cache.getIdentifier());
        this.m_ncache = cache.unwrap(NamedCache.class);
        this.m_stats = new ContextJCacheStatistics(cache.getIdentifier());
    }

    @Override
    public void registerHits(int count, long lStartMillis) {
        this.m_stats.registerHits(count, lStartMillis);
    }

    @Override
    public void registerMisses(int count, long lStartMillis) {
        this.m_stats.registerMisses(count, lStartMillis);
    }

    @Override
    public void registerPuts(long count, long lStartMillis) {
        this.m_stats.registerPuts(count, lStartMillis);
    }

    @Override
    public void registerPutsCompleted(long lStartMillis) {
        this.m_stats.registerPutsCompleted(lStartMillis);
    }

    @Override
    public void registerRemoves(long count, long lStartMillis) {
        this.m_stats.registerRemoves(count, lStartMillis);
    }

    @Override
    public void registerRemove() {
        this.m_stats.registerRemove();
    }

    @Override
    public void registerHitsCompleted(long lStartMillis) {
        this.m_stats.registerHitsCompleted(lStartMillis);
    }

    @Override
    public void registerMissesCompleted(long lStartMillis) {
        this.m_stats.registerMissesCompleted(lStartMillis);
    }

    @Override
    public void registerRemoveCompleted(long lStartMillis) {
        this.m_stats.registerRemoveCompleted(lStartMillis);
    }

    @Override
    public JCacheIdentifier getIdentifier() {
        return this.m_stats.getIdentifier();
    }

    @Override
    public JCacheStatistics add(JCacheStatistics stats) {
        this.m_stats.add(stats);
        return this;
    }

    @Override
    public long getCacheHitsMillis() {
        this.refreshClusterJCacheStatistics();
        return this.m_stats.getCacheHitsMillis();
    }

    @Override
    public long getCacheMissesMillis() {
        this.refreshClusterJCacheStatistics();
        return this.m_stats.getCacheMissesMillis();
    }

    @Override
    public long getCachePutsMillis() {
        this.refreshClusterJCacheStatistics();
        return this.m_stats.getCachePutsMillis();
    }

    @Override
    public long getCacheRemoveMillis() {
        this.refreshClusterJCacheStatistics();
        return this.m_stats.getCacheRemoveMillis();
    }

    @Override
    public void clear() {
        this.aggregateStatistics((InvocableMap.EntryAggregator)new PartitionedCacheStatisticsClear(this.getIdentifier(), (ValueExtractor)this.m_extractor));
        this.m_stats.clear();
    }

    @Override
    public long getCacheHits() {
        this.refreshClusterJCacheStatistics();
        return this.m_stats.getCacheHits();
    }

    @Override
    public float getCacheHitPercentage() {
        this.refreshClusterJCacheStatistics();
        return this.m_stats.getCacheHitPercentage();
    }

    @Override
    public long getCacheMisses() {
        this.refreshClusterJCacheStatistics();
        return this.m_stats.getCacheMisses();
    }

    @Override
    public float getCacheMissPercentage() {
        this.refreshClusterJCacheStatistics();
        return this.m_stats.getCacheMissPercentage();
    }

    @Override
    public long getCacheGets() {
        this.refreshClusterJCacheStatistics();
        return this.m_stats.getCacheGets();
    }

    @Override
    public long getCachePuts() {
        this.refreshClusterJCacheStatistics();
        return this.m_stats.getCachePuts();
    }

    @Override
    public long getCacheRemovals() {
        this.refreshClusterJCacheStatistics();
        return this.m_stats.getCacheRemovals();
    }

    @Override
    public float getAverageGetTime() {
        this.refreshClusterJCacheStatistics();
        return this.m_stats.getAverageGetTime();
    }

    @Override
    public float getAveragePutTime() {
        this.refreshClusterJCacheStatistics();
        return this.m_stats.getAveragePutTime();
    }

    @Override
    public float getAverageRemoveTime() {
        this.refreshClusterJCacheStatistics();
        return this.m_stats.getAverageRemoveTime();
    }

    @Override
    public long getCacheEvictions() {
        return this.m_stats.getCacheEvictions();
    }

    public long getRefreshFrequency() {
        if (this.m_cRefreshFrequencyMillis == -1L) {
            Duration duration;
            String durationStringValue = Config.getProperty((String)"coherence.jcache.statistics.refreshtime", (String)"3s");
            try {
                duration = new Duration(durationStringValue);
            }
            catch (IllegalArgumentException e) {
                Logger.warn((String)("Invalid value \"" + durationStringValue + "\" for system property \"coherence.jcache.statistics.refreshtime\" using default of 3s"));
                duration = new Duration("3s");
            }
            this.m_cRefreshFrequencyMillis = duration.as(Duration.Magnitude.MILLI);
        }
        return this.m_cRefreshFrequencyMillis;
    }

    public void setRefreshFrequency(long m_ldtRefreshFrequency) {
        this.m_cRefreshFrequencyMillis = m_ldtRefreshFrequency;
    }

    private void refreshClusterJCacheStatistics() {
        if (Helper.getCurrentTimeMillis() - this.m_ldtLastRefresh >= this.getRefreshFrequency()) {
            PartitionedCacheStatisticsAggregator entryAggregator = new PartitionedCacheStatisticsAggregator(this.getIdentifier(), (ValueExtractor)this.m_extractor);
            this.m_stats = (ContextJCacheStatistics)this.aggregateStatistics((InvocableMap.EntryAggregator)entryAggregator);
            this.m_ldtLastRefresh = Helper.getCurrentTimeMillis();
        }
    }

    private Object aggregateStatistics(InvocableMap.EntryAggregator entryAggregator) {
        return this.m_ncache.aggregate(this.getKeys(), entryAggregator);
    }

    private Collection getKeys() {
        if (this.m_keys == null) {
            int nPartitions = (Integer)this.m_ncache.invoke((Object)SimplePartitionKey.getPartitionKey((int)0), (InvocableMap.EntryProcessor)new GetPartitionCountEP());
            ArrayList<SimplePartitionKey> keys = new ArrayList<SimplePartitionKey>(nPartitions);
            for (int i = 0; i < nPartitions; ++i) {
                keys.add(SimplePartitionKey.getPartitionKey((int)i));
            }
            this.m_keys = keys;
        }
        return this.m_keys;
    }

    public static class PartitionedCacheStatisticsClear
    implements InvocableMap.StreamingAggregator,
    ExternalizableLite,
    PortableObject {
        private ValueExtractor m_extractor;

        public PartitionedCacheStatisticsClear() {
        }

        public PartitionedCacheStatisticsClear(JCacheIdentifier id, ValueExtractor valueExtractor) {
            this.m_extractor = valueExtractor;
        }

        public InvocableMap.StreamingAggregator supply() {
            return new PartitionedCacheStatisticsClear(null, this.m_extractor);
        }

        public boolean accumulate(InvocableMap.Entry entry) {
            this.process(entry.extract(this.m_extractor));
            return false;
        }

        public boolean combine(Object partialResult) {
            this.process(partialResult);
            return true;
        }

        public Object getPartialResult() {
            return null;
        }

        public Object finalizeResult() {
            return null;
        }

        public int characteristics() {
            return 1;
        }

        protected void process(Object o) {
            JCacheStatistics stats;
            JCacheStatistics jCacheStatistics = stats = o instanceof ContextJCacheStatistics ? (JCacheStatistics)o : null;
            if (stats != null) {
                stats.clear();
            }
        }

        public void readExternal(DataInput in) throws IOException {
            in.readBoolean();
            this.m_extractor = (ValueExtractor)ExternalizableHelper.readObject((DataInput)in);
        }

        public void writeExternal(DataOutput out) throws IOException {
            out.writeBoolean(false);
            ExternalizableHelper.writeObject((DataOutput)out, (Object)this.m_extractor);
        }

        public void readExternal(PofReader in) throws IOException {
            this.m_extractor = (ValueExtractor)in.readObject(1);
        }

        public void writeExternal(PofWriter out) throws IOException {
            out.writeBoolean(0, false);
            out.writeObject(1, (Object)this.m_extractor);
        }
    }

    public static class PartitionedCacheStatisticsAggregator
    implements InvocableMap.StreamingAggregator,
    ExternalizableLite,
    PortableObject {
        private ContextJCacheStatistics m_stats;
        private ValueExtractor m_extractor;
        private JCacheIdentifier m_id;

        public PartitionedCacheStatisticsAggregator() {
        }

        public PartitionedCacheStatisticsAggregator(JCacheIdentifier id, ValueExtractor valueExtractor) {
            this.m_extractor = valueExtractor;
            this.m_id = id;
            this.m_stats = new ContextJCacheStatistics(id);
        }

        public InvocableMap.StreamingAggregator supply() {
            return new PartitionedCacheStatisticsAggregator(this.m_id, this.m_extractor);
        }

        public boolean accumulate(InvocableMap.Entry entry) {
            this.process(entry.extract(this.m_extractor));
            return false;
        }

        public boolean combine(Object partialResult) {
            this.process(partialResult);
            return true;
        }

        public Object getPartialResult() {
            return this.m_stats;
        }

        public Object finalizeResult() {
            return this.m_stats;
        }

        public int characteristics() {
            return 1;
        }

        protected void process(Object o) {
            if (o instanceof ContextJCacheStatistics) {
                this.m_stats.add((ContextJCacheStatistics)o);
            }
        }

        public void readExternal(DataInput in) throws IOException {
            in.readBoolean();
            this.m_extractor = (ValueExtractor)ExternalizableHelper.readObject((DataInput)in);
            this.m_stats = (ContextJCacheStatistics)ExternalizableHelper.readObject((DataInput)in);
            this.m_id = (JCacheIdentifier)ExternalizableHelper.readObject((DataInput)in);
        }

        public void writeExternal(DataOutput out) throws IOException {
            out.writeBoolean(false);
            ExternalizableHelper.writeObject((DataOutput)out, (Object)this.m_extractor);
            ExternalizableHelper.writeObject((DataOutput)out, (Object)this.m_stats);
            ExternalizableHelper.writeObject((DataOutput)out, (Object)this.m_id);
        }

        public void readExternal(PofReader in) throws IOException {
            this.m_extractor = (ValueExtractor)in.readObject(1);
            this.m_stats = (ContextJCacheStatistics)in.readObject(2);
            this.m_id = (JCacheIdentifier)in.readObject(3);
        }

        public void writeExternal(PofWriter out) throws IOException {
            out.writeBoolean(0, false);
            out.writeObject(1, (Object)this.m_extractor);
            out.writeObject(2, (Object)this.m_stats);
            out.writeObject(3, (Object)this.m_id);
        }
    }

    public static class CacheStatisticsExtractor
    extends AbstractExtractor
    implements ExternalizableLite,
    PortableObject {
        private JCacheIdentifier m_id;

        public CacheStatisticsExtractor() {
        }

        public CacheStatisticsExtractor(JCacheIdentifier id) {
            this.m_id = id;
        }

        public Object extractFromEntry(Map.Entry entry) {
            BinaryEntry binEntry = entry instanceof BinaryEntry ? (BinaryEntry)entry : null;
            JCacheStatistics result = null;
            if (binEntry != null) {
                JCacheContext ctx = BinaryEntryHelper.getContext(this.m_id, binEntry);
                result = ctx != null ? ctx.getStatistics() : null;
            }
            return result;
        }

        public void readExternal(DataInput in) throws IOException {
            this.m_id = (JCacheIdentifier)CacheStatisticsExtractor.readObject((DataInput)in);
        }

        public void writeExternal(DataOutput out) throws IOException {
            CacheStatisticsExtractor.writeObject((DataOutput)out, (Object)this.m_id);
        }

        public void readExternal(PofReader in) throws IOException {
            this.m_id = (JCacheIdentifier)in.readObject(0);
        }

        public void writeExternal(PofWriter out) throws IOException {
            out.writeObject(0, (Object)this.m_id);
        }
    }
}

