/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.jcache.passthroughcache;

import com.tangosol.coherence.jcache.AbstractCoherenceBasedCache;
import com.tangosol.coherence.jcache.CoherenceBasedCacheManager;
import com.tangosol.coherence.jcache.common.JCacheIdentifier;
import com.tangosol.coherence.jcache.common.JCacheStatistics;
import com.tangosol.coherence.jcache.common.MapEntryIteratorToCacheEntryIteratorAdapter;
import com.tangosol.coherence.jcache.passthroughcache.PassThroughCacheConfiguration;
import com.tangosol.coherence.jcache.passthroughcache.PassThroughFilterAdapter;
import com.tangosol.coherence.jcache.passthroughcache.PassThroughListenerRegistration;
import com.tangosol.coherence.jcache.passthroughcache.PassThroughMapListenerAdapter;
import com.tangosol.coherence.jcache.passthroughcache.processors.GetAndReplaceProcessor;
import com.tangosol.coherence.jcache.passthroughcache.processors.InvokeProcessor;
import com.tangosol.coherence.jcache.passthroughcache.processors.ReplaceIfExistsProcessor;
import com.tangosol.coherence.jcache.passthroughcache.processors.ReplaceWithProcessor;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.MapListener;
import com.tangosol.util.MapListenerSupport;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.extractor.IdentityExtractor;
import com.tangosol.util.filter.EqualsFilter;
import com.tangosol.util.filter.MapEventFilter;
import com.tangosol.util.filter.NotFilter;
import com.tangosol.util.filter.PresentFilter;
import com.tangosol.util.processor.ConditionalPut;
import com.tangosol.util.processor.ConditionalRemove;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.cache.Cache;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.event.CacheEntryCreatedListener;
import javax.cache.event.CacheEntryListener;
import javax.cache.event.CacheEntryRemovedListener;
import javax.cache.event.CacheEntryUpdatedListener;
import javax.cache.integration.CompletionListener;
import javax.cache.management.CacheMXBean;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.EntryProcessorException;
import javax.cache.processor.EntryProcessorResult;

public class PassThroughCache<K, V>
extends AbstractCoherenceBasedCache<K, V, PassThroughCacheConfiguration<K, V>> {
    private ConcurrentHashMap<CacheEntryListenerConfiguration<? super K, ? super V>, PassThroughListenerRegistration<K, V>> m_mapListenerRegistrations = new ConcurrentHashMap();

    public PassThroughCache(CoherenceBasedCacheManager manager, String sJCacheName, PassThroughCacheConfiguration<K, V> configuration) {
        super(manager, sJCacheName, new PassThroughCacheConfiguration<K, V>(configuration));
        String sNamedCacheName = ((PassThroughCacheConfiguration)this.m_configuration).getNamedCacheName() == null ? sJCacheName : ((PassThroughCacheConfiguration)this.m_configuration).getNamedCacheName();
        this.m_namedCache = manager.getConfigurableCacheFactory().ensureCache(sNamedCacheName, manager.getClassLoader());
    }

    public V get(K key) {
        this.ensureOpen();
        return (V)this.m_namedCache.get(key);
    }

    public Map<K, V> getAll(Set<? extends K> keys) {
        this.ensureOpen();
        return this.m_namedCache.getAll(keys);
    }

    public boolean containsKey(K key) {
        this.ensureOpen();
        return this.m_namedCache.containsKey(key);
    }

    public void loadAll(Set<? extends K> keys, boolean replaceExistingValues, CompletionListener completionListener) {
        throw new UnsupportedOperationException("loadAll not supported by " + this.getClass().getName());
    }

    public void put(K key, V value) {
        this.ensureOpen();
        this.m_namedCache.putAll(Collections.singletonMap(key, value));
    }

    public V getAndPut(K key, V value) {
        this.ensureOpen();
        return (V)this.m_namedCache.put(key, value);
    }

    public void putAll(Map<? extends K, ? extends V> map) {
        this.ensureOpen();
        this.m_namedCache.putAll(map);
    }

    public boolean putIfAbsent(K key, V value) {
        this.ensureOpen();
        return this.m_namedCache.invoke(key, (InvocableMap.EntryProcessor)new ConditionalPut((Filter)new NotFilter((Filter)PresentFilter.INSTANCE), value, true)) == null;
    }

    public boolean remove(K key) {
        this.ensureOpen();
        return this.m_namedCache.remove(key) != null;
    }

    public boolean remove(K key, V oldValue) {
        this.ensureOpen();
        return this.m_namedCache.invoke(key, (InvocableMap.EntryProcessor)new ConditionalRemove((Filter)new EqualsFilter((ValueExtractor)IdentityExtractor.INSTANCE, oldValue), true)) == null;
    }

    public V getAndRemove(K key) {
        this.ensureOpen();
        return (V)this.m_namedCache.remove(key);
    }

    public boolean replace(K key, V oldValue, V newValue) {
        this.ensureOpen();
        return (Boolean)this.m_namedCache.invoke(key, new ReplaceWithProcessor(oldValue, newValue));
    }

    public boolean replace(K key, V value) {
        this.ensureOpen();
        return (Boolean)this.m_namedCache.invoke(key, new ReplaceIfExistsProcessor(value));
    }

    public V getAndReplace(K key, V value) {
        this.ensureOpen();
        return (V)this.m_namedCache.invoke(key, new GetAndReplaceProcessor(value));
    }

    public void removeAll(Set<? extends K> keys) {
        this.ensureOpen();
        this.m_namedCache.invokeAll(keys, (InvocableMap.EntryProcessor)new ConditionalRemove((Filter)PresentFilter.INSTANCE, false));
    }

    public void removeAll() {
        this.ensureOpen();
        this.m_namedCache.clear();
    }

    public void clear() {
        this.ensureOpen();
        this.m_namedCache.clear();
    }

    public <T> T invoke(K key, EntryProcessor<K, V, T> entryProcessor, Object ... arguments) throws EntryProcessorException {
        this.ensureOpen();
        try {
            EntryProcessorResult result = (EntryProcessorResult)this.m_namedCache.invoke(key, new InvokeProcessor<K, V, T>(entryProcessor, arguments));
            return (T)(result == null ? null : result.get());
        }
        catch (EntryProcessorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EntryProcessorException((Throwable)e);
        }
    }

    public <T> Map<K, EntryProcessorResult<T>> invokeAll(Set<? extends K> keys, EntryProcessor<K, V, T> entryProcessor, Object ... arguments) {
        this.ensureOpen();
        return this.m_namedCache.invokeAll(keys, new InvokeProcessor<K, V, T>(entryProcessor, arguments));
    }

    public void registerCacheEntryListener(CacheEntryListenerConfiguration<K, V> configuration) {
        this.ensureOpen();
        if (!this.m_mapListenerRegistrations.containsKey(configuration)) {
            PassThroughListenerRegistration<K, V> registration;
            CacheEntryListener cacheEntryListener = (CacheEntryListener)configuration.getCacheEntryListenerFactory().create();
            int nMask = 0;
            if (cacheEntryListener instanceof CacheEntryCreatedListener) {
                nMask |= 1;
            }
            if (cacheEntryListener instanceof CacheEntryUpdatedListener) {
                nMask |= 2;
            }
            if (cacheEntryListener instanceof CacheEntryRemovedListener) {
                nMask |= 4;
            }
            MapEventFilter filter = configuration.getCacheEntryEventFilterFactory() == null ? (nMask == 7 ? null : new MapEventFilter(nMask)) : new MapEventFilter(nMask, new PassThroughFilterAdapter(configuration.getCacheEntryEventFilterFactory()));
            MapListenerSupport.WrapperSynchronousListener listener = new PassThroughMapListenerAdapter(this, cacheEntryListener);
            if (configuration.isSynchronous()) {
                listener = new MapListenerSupport.WrapperSynchronousListener(listener);
            }
            if (this.m_mapListenerRegistrations.putIfAbsent(configuration, registration = new PassThroughListenerRegistration<K, V>(configuration, (MapListener)listener, filter)) == null) {
                this.m_namedCache.addMapListener((MapListener)listener, (Filter)filter, !configuration.isOldValueRequired());
            }
        }
    }

    public void deregisterCacheEntryListener(CacheEntryListenerConfiguration<K, V> configuration) {
        this.ensureOpen();
        PassThroughListenerRegistration<K, V> registration = this.m_mapListenerRegistrations.remove(configuration);
        if (registration != null) {
            MapListener listener = registration.getMapListener();
            MapEventFilter filter = registration.getMapEventFilter();
            this.m_namedCache.removeMapListener(listener, (Filter)filter);
        }
    }

    public Iterator<Cache.Entry<K, V>> iterator() {
        this.ensureOpen();
        return new MapEntryIteratorToCacheEntryIteratorAdapter(this.m_namedCache.entrySet().iterator());
    }

    @Override
    public void destroy() {
        throw new UnsupportedOperationException("PassThroughCaches can't be destroyed.  They may only be closed.");
    }

    @Override
    public void onBeforeClosing() {
        for (PassThroughListenerRegistration<K, V> registration : this.m_mapListenerRegistrations.values()) {
            MapListener listener = registration.getMapListener();
            MapEventFilter filter = registration.getMapEventFilter();
            if (filter == null) {
                this.m_namedCache.removeMapListener(listener);
                continue;
            }
            this.m_namedCache.removeMapListener(listener, (Filter)filter);
        }
    }

    @Override
    public CacheMXBean getMBean() {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public JCacheStatistics getStatistics() {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void setManagementEnabled(boolean fEnabled) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void setStatisticsEnabled(boolean fEnabled) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public boolean isStatisticsEnabled() {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public JCacheIdentifier getIdentifier() {
        throw new UnsupportedOperationException("not implemented");
    }
}

