/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.jcache.localcache.processors;

import com.tangosol.coherence.jcache.common.CoherenceCacheEventEventDispatcher;
import com.tangosol.coherence.jcache.common.JCacheContext;
import com.tangosol.coherence.jcache.common.JCacheStatistics;
import com.tangosol.coherence.jcache.localcache.LocalCache;
import com.tangosol.coherence.jcache.localcache.LocalCacheValue;
import com.tangosol.util.processor.AbstractProcessor;
import javax.cache.Cache;
import javax.cache.integration.CacheWriter;

public abstract class AbstractEntryProcessor<K, V, T>
extends AbstractProcessor<K, V, T> {
    private LocalCache m_cache;

    AbstractEntryProcessor(LocalCache cache) {
        this.m_cache = cache;
    }

    public JCacheStatistics getJCacheStatistics() {
        return this.getContext().getStatistics();
    }

    public JCacheContext getContext() {
        return this.getCache().getContext();
    }

    public LocalCacheValue updateLocalCacheValue(LocalCacheValue cachedValue, Object internalValue, long ldtUpdate) {
        LocalCacheValue updatedCacheValue = new LocalCacheValue(cachedValue);
        return updatedCacheValue.updateInternalValue(internalValue, ldtUpdate, this.getContext().getExpiryPolicy());
    }

    public LocalCacheValue accessLocalCacheValue(LocalCacheValue cachedValue, long ldtAccess) {
        cachedValue.accessInternalValue(ldtAccess, this.m_cache.getContext().getExpiryPolicy());
        return cachedValue;
    }

    protected void writeCacheEntry(Cache.Entry<K, V> entry) {
        CacheWriter cacheWriter = this.getContext().getCacheWriter();
        if (this.getContext().getConfiguration().isWriteThrough() && cacheWriter != null) {
            cacheWriter.write(entry);
        }
    }

    protected void deleteCacheEntry(K key) {
        CacheWriter cacheWriter = this.getContext().getCacheWriter();
        if (this.getContext().getConfiguration().isWriteThrough() && cacheWriter != null) {
            cacheWriter.delete(key);
        }
    }

    protected K fromInternalKey(Object internalObject) {
        return this.m_cache.getKeyConverter().fromInternal(internalObject);
    }

    protected V fromInternalValue(Object internalObject) {
        return this.m_cache.getValueConverter().fromInternal(internalObject);
    }

    protected Object toInternalKey(K externalKey) {
        return this.m_cache.getKeyConverter().toInternal(externalKey);
    }

    protected Object toInternalValue(V externalValue) {
        return this.m_cache.getValueConverter().toInternal(externalValue);
    }

    protected boolean isStatisticsEnabled() {
        return this.m_cache.isStatisticsEnabled();
    }

    protected LocalCache getCache() {
        return this.m_cache;
    }

    protected void processExpiries(Object internalKey) {
        CoherenceCacheEventEventDispatcher dispatcher = new CoherenceCacheEventEventDispatcher();
        this.m_cache.processExpiries(this.m_cache.getKeyConverter().fromInternal(internalKey), dispatcher);
        this.m_cache.dispatch(dispatcher);
    }
}

