/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.jcache.localcache.processors;

import com.tangosol.coherence.jcache.common.CoherenceCacheEntry;
import com.tangosol.coherence.jcache.common.CoherenceCacheEventEventDispatcher;
import com.tangosol.coherence.jcache.common.CoherenceEntryProcessorResult;
import com.tangosol.coherence.jcache.common.Helper;
import com.tangosol.coherence.jcache.common.JCacheStatistics;
import com.tangosol.coherence.jcache.localcache.LocalCache;
import com.tangosol.coherence.jcache.localcache.LocalCacheValue;
import com.tangosol.coherence.jcache.localcache.processors.AbstractEntryProcessor;
import com.tangosol.coherence.jcache.localcache.processors.EntryProcessorEntry;
import com.tangosol.coherence.jcache.localcache.processors.MutableEntryOperation;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.net.GuardSupport;
import com.tangosol.net.Guardian;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.LiteMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.MutableEntry;

public class InvokeProcessor<K, V, T>
extends AbstractEntryProcessor
implements ExternalizableLite,
PortableObject {
    private EntryProcessor<K, V, T> m_processor;
    private Object[] m_arrArguments;

    public InvokeProcessor(LocalCache cache, EntryProcessor<K, V, T> processor, Object ... arguments) {
        super(cache);
        if (processor == null) {
            throw new NullPointerException("processor can't be null");
        }
        this.m_processor = processor;
        this.m_arrArguments = new Object[arguments.length];
        System.arraycopy(arguments, 0, this.m_arrArguments, 0, arguments.length);
    }

    public Object process(InvocableMap.Entry entry) {
        long ldtNow = Helper.getCurrentTimeMillis();
        boolean fStatisticsEnabled = this.isStatisticsEnabled();
        JCacheStatistics stats = fStatisticsEnabled ? this.getJCacheStatistics() : null;
        CoherenceCacheEventEventDispatcher dispatcher = new CoherenceCacheEventEventDispatcher();
        if (fStatisticsEnabled) {
            if (entry.isPresent()) {
                stats.registerHits(1, ldtNow);
            } else {
                stats.registerMisses(1, ldtNow);
            }
        }
        EntryProcessorEntry internalEntry = new EntryProcessorEntry(this.getCache(), entry, ldtNow);
        Object result = null;
        CoherenceEntryProcessorResult<Object> theResult = null;
        try {
            result = this.m_processor.process(internalEntry, this.m_arrArguments);
            theResult = result == null ? null : new CoherenceEntryProcessorResult<Object>(result);
        }
        catch (Exception e) {
            theResult = new CoherenceEntryProcessorResult<Object>((Object)e);
            return theResult;
        }
        Object oKey = internalEntry.getKey();
        LocalCacheValue cachedValue = internalEntry.getCacheValue();
        switch (internalEntry.getOperation()) {
            case NONE: {
                break;
            }
            case ACCESS: {
                cachedValue.accessInternalValue(ldtNow, this.getContext().getExpiryPolicy());
                entry.setValue((Object)cachedValue);
                break;
            }
            case CREATE: 
            case LOAD: {
                if (internalEntry.getOperation() == MutableEntryOperation.CREATE) {
                    this.writeCacheEntry(new CoherenceCacheEntry(oKey, internalEntry.getValue()));
                }
                if (cachedValue.isExpiredAt(ldtNow)) break;
                entry.setValue((Object)cachedValue);
                if (!this.isStatisticsEnabled() || internalEntry.getOperation() != MutableEntryOperation.CREATE) break;
                stats.registerPuts(1L, ldtNow);
                break;
            }
            case UPDATE: {
                Object oldValue = this.fromInternalValue(cachedValue.get());
                this.writeCacheEntry(new CoherenceCacheEntry(oKey, internalEntry.getValue(), oldValue));
                Object internalValue = this.toInternalValue(internalEntry.getValue());
                LocalCacheValue newCachedValue = new LocalCacheValue(cachedValue);
                newCachedValue.updateInternalValue(internalValue, ldtNow, this.getContext().getExpiryPolicy());
                entry.setValue((Object)newCachedValue);
                if (!this.isStatisticsEnabled()) break;
                stats.registerPuts(1L, ldtNow);
                break;
            }
            case REMOVE: {
                this.deleteCacheEntry(oKey);
                entry.remove(false);
                if (!this.isStatisticsEnabled()) break;
                stats.registerRemoves(1L, ldtNow);
                break;
            }
        }
        this.getCache().dispatch(dispatcher);
        return theResult;
    }

    public Map processAll(Set setEntries) {
        LiteMap mapResults = new LiteMap();
        Guardian.GuardContext ctxGuard = GuardSupport.getThreadContext();
        long cMillis = ctxGuard == null ? 0L : ctxGuard.getTimeoutMillis();
        for (InvocableMap.Entry entry : setEntries) {
            Object result = this.process(entry);
            if (result != null) {
                mapResults.put(entry.getKey(), result);
            }
            if (ctxGuard == null) continue;
            ctxGuard.heartbeat(cMillis);
        }
        return mapResults;
    }

    public void readExternal(DataInput in) throws IOException {
        this.m_processor = (EntryProcessor)ExternalizableHelper.readObject((DataInput)in);
        int cArguments = ExternalizableHelper.readInt((DataInput)in);
        this.m_arrArguments = new Object[cArguments];
        for (int i = 0; i < cArguments; ++i) {
            this.m_arrArguments[i] = ExternalizableHelper.readObject((DataInput)in);
        }
    }

    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeObject((DataOutput)out, this.m_processor);
        ExternalizableHelper.writeObject((DataOutput)out, (Object)this.m_arrArguments.length);
        for (Object oArgument : this.m_arrArguments) {
            ExternalizableHelper.writeObject((DataOutput)out, (Object)oArgument);
        }
    }

    public void readExternal(PofReader reader) throws IOException {
        this.m_processor = (EntryProcessor)reader.readObject(1);
        int cArguments = reader.readInt(2);
        this.m_arrArguments = new Object[cArguments];
        reader.readObjectArray(3, this.m_arrArguments);
    }

    public void writeExternal(PofWriter writer) throws IOException {
        writer.writeObject(1, this.m_processor);
        writer.writeInt(2, this.m_arrArguments.length);
        writer.writeObjectArray(3, this.m_arrArguments);
    }

    static class InternalEntry<K, V>
    implements MutableEntry<K, V> {
        private InvocableMap.Entry m_entry;

        public InternalEntry(InvocableMap.Entry entry) {
            this.m_entry = entry;
        }

        public boolean exists() {
            return this.m_entry.isPresent();
        }

        public void remove() {
            this.m_entry.remove(false);
        }

        public void setValue(V value) {
            this.m_entry.setValue(value);
        }

        public K getKey() {
            return (K)this.m_entry.getKey();
        }

        public V getValue() {
            return (V)this.m_entry.getValue();
        }

        public <T> T unwrap(Class<T> clz) {
            if (clz != null && clz.isInstance(this.m_entry)) {
                return (T)this.m_entry;
            }
            throw new IllegalArgumentException("Unsupported unwrap(" + clz + ")");
        }
    }
}

