/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.concurrent.executor;

import com.oracle.coherence.common.base.Logger;
import com.oracle.coherence.concurrent.executor.ClusteredAssignment;
import com.oracle.coherence.concurrent.executor.ClusteredExecutorInfo;
import com.oracle.coherence.concurrent.executor.ClusteredExecutorService;
import com.oracle.coherence.concurrent.executor.ClusteredProperties;
import com.oracle.coherence.concurrent.executor.ClusteredTaskManager;
import com.oracle.coherence.concurrent.executor.ExecutionPlan;
import com.oracle.coherence.concurrent.executor.PortableAbstractProcessor;
import com.oracle.coherence.concurrent.executor.Result;
import com.oracle.coherence.concurrent.executor.Task;
import com.oracle.coherence.concurrent.executor.TaskExecutorService;
import com.oracle.coherence.concurrent.executor.internal.ExecutorTrace;
import com.oracle.coherence.concurrent.executor.management.ExecutorMBean;
import com.oracle.coherence.concurrent.executor.options.CloseExecutor;
import com.oracle.coherence.concurrent.executor.options.Description;
import com.oracle.coherence.concurrent.executor.options.Member;
import com.oracle.coherence.concurrent.executor.options.Name;
import com.oracle.coherence.concurrent.executor.tasks.CronTask;
import com.oracle.coherence.concurrent.executor.util.Caches;
import com.oracle.coherence.concurrent.executor.util.OptionsByType;
import com.tangosol.coherence.component.util.SafeNamedCache;
import com.tangosol.coherence.config.Config;
import com.tangosol.internal.tracing.Scope;
import com.tangosol.internal.tracing.Span;
import com.tangosol.internal.tracing.SpanContext;
import com.tangosol.internal.tracing.TracingHelper;
import com.tangosol.net.CacheService;
import com.tangosol.net.Cluster;
import com.tangosol.net.NamedCache;
import com.tangosol.net.management.AnnotatedStandardEmitterMBean;
import com.tangosol.net.management.Registry;
import com.tangosol.util.Base;
import com.tangosol.util.Filter;
import com.tangosol.util.Filters;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.MapEvent;
import com.tangosol.util.MapListener;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.WrapperException;
import com.tangosol.util.extractor.MultiExtractor;
import com.tangosol.util.extractor.ReflectionExtractor;
import com.tangosol.util.processor.ConditionalPut;
import com.tangosol.util.processor.ExtractorProcessor;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.NotCompliantMBeanException;

public class ClusteredRegistration
implements TaskExecutorService.Registration,
MapListener {
    public static long INFO_UPDATE_DELAY = 5L;
    public static TimeUnit INFO_UPDATE_DELAY_UNIT = TimeUnit.SECONDS;
    public static boolean s_fTraceLogging = Config.getBoolean((String)"coherence.executor.trace.logging", (boolean)false);
    protected final MapListener f_listener = new MapListener(){

        public void entryInserted(MapEvent mapEvent) {
        }

        public void entryUpdated(MapEvent mapEvent) {
            ClusteredExecutorInfo info = (ClusteredExecutorInfo)mapEvent.getNewValue();
            TaskExecutorService.ExecutorInfo.State stateInfo = info.getState();
            if (stateInfo != null && ClusteredRegistration.this.m_executorMBean != null) {
                ClusteredRegistration.this.m_executorMBean.setState(stateInfo);
            }
        }

        public void entryDeleted(MapEvent mapEvent) {
            ClusteredRegistration.this.close();
        }
    };
    protected final AtomicBoolean f_fShutdownCalled = new AtomicBoolean(false);
    protected final AtomicBoolean f_fCloseCalled = new AtomicBoolean(false);
    protected long m_cTasksCompletedCount = 0L;
    protected long m_cTasksRejectedCount = 0L;
    protected long m_cTasksInProgressCount = 0L;
    protected final ClusteredExecutorService f_clusteredExecutorService;
    protected final String f_sExecutorId;
    protected final ExecutorService f_executor;
    protected final OptionsByType<TaskExecutorService.Registration.Option> f_optionsByType;
    protected volatile ScheduledFuture m_scheduledFuture;
    protected volatile ScheduledFuture m_touchFuture;
    protected NamedCache m_viewAssignments;
    protected NamedCache<String, TaskExecutor> m_cacheTasksTermination;
    protected final ConcurrentHashMap<String, TaskExecutor> f_mapTaskExecutors;
    protected ExecutorMBeanImpl m_executorMBean;

    public ClusteredRegistration(ClusteredExecutorService clusteredExecutorService, String sExecutorId, ExecutorService executor, OptionsByType<TaskExecutorService.Registration.Option> optionsByType) {
        this.f_clusteredExecutorService = clusteredExecutorService;
        this.f_sExecutorId = sExecutorId;
        this.f_executor = executor;
        this.f_optionsByType = optionsByType == null ? OptionsByType.from(TaskExecutorService.Registration.Option.class, new TaskExecutorService.Registration.Option[0], new TaskExecutorService.Registration.Option[0]) : optionsByType;
        this.f_mapTaskExecutors = new ConcurrentHashMap();
        NamedCache cacheTmp = this.executors();
        if (cacheTmp instanceof SafeNamedCache) {
            cacheTmp = ((SafeNamedCache)cacheTmp).getNamedCache();
        }
        this.m_cacheTasksTermination = cacheTmp;
    }

    @Override
    public String getId() {
        return this.f_sExecutorId;
    }

    @Override
    public <T extends TaskExecutorService.Registration.Option> T getOption(Class<T> classOfOption, T defaultIfNotFound) {
        return (T)((TaskExecutorService.Registration.Option)this.f_optionsByType.get(classOfOption, defaultIfNotFound));
    }

    public long getTasksCompletedCount() {
        return this.m_cTasksCompletedCount;
    }

    public long getTasksRejectedCount() {
        return this.m_cTasksRejectedCount;
    }

    public long getTasksInProgressCount() {
        return this.m_cTasksInProgressCount;
    }

    public void entryInserted(MapEvent mapEvent) {
        ExecutorTrace.log(() -> String.format("Executor [%s] received insert event [%s]", this.f_sExecutorId, mapEvent));
        ClusteredAssignment assignment = (ClusteredAssignment)mapEvent.getNewValue();
        String sTaskId = assignment.getTaskId();
        String sExecId = assignment.getExecutorId();
        TaskExecutor taskExecutor = new TaskExecutor(sTaskId, assignment.isRecovered());
        TaskExecutor existing = this.f_mapTaskExecutors.putIfAbsent(sTaskId, taskExecutor);
        if (existing == null) {
            this.executingTask(taskExecutor, sTaskId, sExecId);
        }
    }

    public void entryUpdated(MapEvent mapEvent) {
        Thread executionThread;
        TaskExecutor taskExecutor;
        ExecutorTrace.log(() -> String.format("Executor [%s] received update event [%s]", this.f_sExecutorId, mapEvent));
        ClusteredAssignment assignment = (ClusteredAssignment)mapEvent.getNewValue();
        String sTaskId = assignment.getTaskId();
        if (assignment.getState() == ClusteredAssignment.State.CANCELLED && (taskExecutor = this.f_mapTaskExecutors.get(sTaskId)) != null && (executionThread = taskExecutor.getExecutionThread()) != null) {
            ExecutorTrace.log(() -> String.format("Executor [%s] attempting interrupt of task [%s] running on thread [%s]", this.f_sExecutorId, sTaskId, executionThread));
            executionThread.interrupt();
        }
    }

    public void entryDeleted(MapEvent mapEvent) {
        ExecutorTrace.log(() -> String.format("Executor [%s] received deleted event [%s]", this.f_sExecutorId, mapEvent));
        ClusteredAssignment assignment = (ClusteredAssignment)mapEvent.getOldValue();
        this.cleanupTask(assignment.getTaskId());
    }

    public void shutdown() {
        if (this.f_fShutdownCalled.compareAndSet(false, true)) {
            this.executors().invoke((Object)this.f_sExecutorId, (InvocableMap.EntryProcessor)new ClusteredExecutorInfo.SetStateProcessor(TaskExecutorService.ExecutorInfo.State.CLOSING_GRACEFULLY));
            try {
                ClusteredExecutorService service = this.f_clusteredExecutorService;
                this.m_touchFuture = service.getScheduledExecutorService().scheduleAtFixedRate(new ClusteredExecutorInfo.TouchRunnable(this.f_sExecutorId, service.getCacheService()), 1L, 1L, TimeUnit.SECONDS);
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }
    }

    protected NamedCache executors() {
        return Caches.executors(this.f_clusteredExecutorService.getCacheService());
    }

    protected NamedCache tasks() {
        return Caches.tasks(this.f_clusteredExecutorService.getCacheService());
    }

    protected NamedCache assignments() {
        return Caches.assignments(this.f_clusteredExecutorService.getCacheService());
    }

    protected static void registerExecutorMBean(CacheService service, ExecutorMBean mbean, String sName) {
        Objects.requireNonNull(service, "service cannot be null");
        Objects.requireNonNull(mbean, "mbean cannot be null");
        Objects.requireNonNull(sName, "sName cannot be null");
        Cluster cluster = service.getCluster();
        Registry registry = cluster.getManagement();
        if (registry != null) {
            String sMbeanName = ClusteredRegistration.getExecutorServiceMBeanName(registry, sName);
            try {
                registry.register(sMbeanName, (Object)new AnnotatedStandardEmitterMBean((Object)mbean, ExecutorMBean.class));
            }
            catch (NotCompliantMBeanException e) {
                throw new WrapperException((Throwable)e);
            }
        }
    }

    protected static void unregisterExecutiveServiceMBean(CacheService service, String sName) {
        Objects.requireNonNull(service, "service cannot be null");
        Objects.requireNonNull(sName, "sName cannot be null");
        Registry registry = service.getCluster().getManagement();
        if (registry != null) {
            String sMBeanName = ClusteredRegistration.getExecutorServiceMBeanName(registry, sName);
            registry.unregister(sMBeanName);
        }
    }

    protected static String getExecutorServiceMBeanName(Registry registry, String sName) {
        Objects.requireNonNull(registry, "registry cannot be null");
        Objects.requireNonNull(sName, "sName cannot be null");
        return registry.ensureGlobalName("type=Executor,name=" + sName);
    }

    protected void executingTask(TaskExecutor taskExecutor, String sExecId, String sTaskId) {
        block2: {
            ++this.m_cTasksInProgressCount;
            try {
                this.f_executor.execute(taskExecutor);
            }
            catch (RejectedExecutionException e) {
                Logger.info(() -> String.format("Executor [%s] rejected Task [%s]", sExecId, sTaskId));
                Logger.info((String)"Task rejected due to RejectedExecutionException", (Throwable)e);
                taskExecutor.setResult(Result.throwable(e), true);
                ++this.m_cTasksRejectedCount;
                this.f_clusteredExecutorService.getScheduledExecutorService().submit(() -> this.executors().invoke((Object)sExecId, (InvocableMap.EntryProcessor)new ClusteredExecutorInfo.SetStateProcessor(TaskExecutorService.ExecutorInfo.State.RUNNING, TaskExecutorService.ExecutorInfo.State.REJECTING)));
                ClusteredTaskManager.ChainedProcessor chainedProcessor = ClusteredTaskManager.ChainedProcessor.empty();
                chainedProcessor.andThen((InvocableMap.EntryProcessor<String, ClusteredTaskManager, ?>)new ClusteredTaskManager.SetActionProcessor(sExecId, EnumSet.of(ExecutionPlan.Action.ASSIGN, ExecutionPlan.Action.RECOVER), ExecutionPlan.Action.REASSIGN));
                chainedProcessor.andThen((InvocableMap.EntryProcessor<String, ClusteredTaskManager, ?>)new ClusteredTaskManager.NotifyExecutionStrategyProcessor());
                this.tasks().invoke((Object)sTaskId, (InvocableMap.EntryProcessor)chainedProcessor);
                ExecutorService executorService = this.f_executor;
                if (!executorService.isShutdown() && !executorService.isTerminated()) break block2;
                Logger.info(() -> String.format("Executor [%s] rejected Task [%s] due to shutdown", sExecId, sTaskId));
                this.f_clusteredExecutorService.deregister(this.f_executor);
            }
        }
    }

    protected void cleanupTask(String sTaskId) {
        this.f_mapTaskExecutors.remove(sTaskId);
        ++this.m_cTasksCompletedCount;
        --this.m_cTasksInProgressCount;
    }

    protected void start() {
        if (this.m_scheduledFuture == null) {
            CacheService service = this.f_clusteredExecutorService.getCacheService();
            this.executors().addMapListener(this.f_listener, (Object)this.f_sExecutorId, false);
            this.m_viewAssignments = this.assignments().view().filter(Filters.equal((String)"executorId", (Object)this.f_sExecutorId)).listener((MapListener)this).build();
            Runtime runtime = Runtime.getRuntime();
            ClusteredExecutorInfo info = new ClusteredExecutorInfo(this.f_sExecutorId, System.currentTimeMillis(), runtime.maxMemory(), runtime.totalMemory(), runtime.freeMemory(), this.f_optionsByType);
            service.getResourceRegistry().registerResource(ClusteredExecutorInfo.class, this.f_sExecutorId, (Object)info);
            ClusteredExecutorInfo existingInfo = (ClusteredExecutorInfo)this.executors().invoke((Object)this.f_sExecutorId, (InvocableMap.EntryProcessor)new ConditionalPut(Filters.not((Filter)Filters.present()), (Object)info, true));
            if (existingInfo == null) {
                this.m_executorMBean = new ExecutorMBeanImpl(info.getExecutorName(), ((Member)this.f_optionsByType.get(Member.class, null)).get().getId(), ((Member)this.f_optionsByType.get(Member.class, null)).get().toString(), this.f_sExecutorId, this.f_optionsByType.get(Description.class, Description.UNKNOWN).getName());
                ClusteredRegistration.registerExecutorMBean(service, this.m_executorMBean, info.getExecutorName());
                this.m_scheduledFuture = this.f_clusteredExecutorService.getScheduledExecutorService().scheduleAtFixedRate(new ClusteredExecutorInfo.UpdateInfoRunnable(service, this.f_sExecutorId, this.f_executor, this), INFO_UPDATE_DELAY, INFO_UPDATE_DELAY, INFO_UPDATE_DELAY_UNIT);
            }
        }
    }

    @Override
    public void close() {
        if (this.f_fCloseCalled.compareAndSet(false, true)) {
            if (this.m_scheduledFuture != null && !this.m_scheduledFuture.isDone()) {
                this.m_scheduledFuture.cancel(true);
            }
            if (this.m_touchFuture != null && !this.m_touchFuture.isDone()) {
                this.m_touchFuture.cancel(true);
            }
            NamedCache<String, TaskExecutor> esCache = this.m_cacheTasksTermination;
            ClusteredExecutorService executorService = this.f_clusteredExecutorService;
            Runnable runnable = () -> {
                ExecutorMBeanImpl executorMBean = this.m_executorMBean;
                String sExecutorId = this.f_sExecutorId;
                CacheService service = executorService.getCacheService();
                try {
                    if (service.isRunning()) {
                        ClusteredRegistration.unregisterExecutiveServiceMBean(service, executorMBean.getName());
                    }
                    if (esCache.isActive()) {
                        esCache.removeMapListener(this.f_listener, (Object)sExecutorId);
                        esCache.invoke((Object)sExecutorId, (InvocableMap.EntryProcessor)new ClusteredExecutorInfo.SetStateProcessor(TaskExecutorService.ExecutorInfo.State.CLOSING));
                    }
                }
                catch (Exception e) {
                    if (ExecutorTrace.isEnabled()) {
                        Logger.warn((String)"Exception cleaning up executor resources", (Throwable)e);
                    }
                }
                finally {
                    this.m_cacheTasksTermination = null;
                }
            };
            Base.makeThread(null, (Runnable)runnable, (String)"ConcurrentExecutorCleaner").start();
            NamedCache viewAssignments = this.m_viewAssignments;
            if (viewAssignments != null) {
                viewAssignments.release();
                this.m_viewAssignments = null;
            }
            if (this.f_optionsByType.contains((TaskExecutorService.Registration.Option)((Object)CloseExecutor.class))) {
                this.f_executor.shutdown();
            }
            executorService.deregister(this.f_executor);
        }
    }

    protected class TaskExecutor
    implements Runnable,
    Task.Context {
        protected final String f_sTaskId;
        protected Task m_task;
        protected int m_cYield;
        protected final boolean f_fRecovered;
        protected ClusteredProperties m_properties;
        protected volatile Thread m_executionThread;

        public TaskExecutor(String sTaskId, boolean fRecovered) {
            this.f_sTaskId = sTaskId;
            this.m_task = null;
            this.m_cYield = 0;
            this.m_properties = null;
            this.f_fRecovered = fRecovered;
        }

        public void setResult(Result result) {
            this.setResult(result, false);
        }

        public void setResult(Result result, boolean fComplete) {
            if (result == null) {
                result = Result.none();
            }
            Result resultLocal = result;
            ExecutorTrace.log(() -> String.format("Executor [%s] setting the execution result of Task [%s]: %s", ClusteredRegistration.this.f_sExecutorId, this.f_sTaskId, resultLocal));
            PortableAbstractProcessor processor = new ClusteredTaskManager.UpdateContributedResultProcessor(ClusteredRegistration.this.f_sExecutorId, resultLocal);
            if (fComplete) {
                ClusteredTaskManager.ChainedProcessor cp = ClusteredTaskManager.ChainedProcessor.empty();
                cp.andThen((InvocableMap.EntryProcessor<String, ClusteredTaskManager, ?>)processor);
                cp.andThen((InvocableMap.EntryProcessor<String, ClusteredTaskManager, ?>)new ClusteredTaskManager.SetActionProcessor(ClusteredRegistration.this.f_sExecutorId, ExecutionPlan.Action.COMPLETED));
                processor = cp;
            }
            ClusteredRegistration.this.tasks().invoke((Object)this.f_sTaskId, (InvocableMap.EntryProcessor)processor);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.m_executionThread = Thread.currentThread();
            if (ClusteredRegistration.this.f_mapTaskExecutors.containsKey(this.f_sTaskId)) {
                boolean fCleanupLocalExecutionResources;
                block40: {
                    boolean fUpdateExecutionStatus;
                    boolean fIsCompleted;
                    ExecutorTrace.log(() -> String.format("Executor [%s] preparing execution of Task [%s]", ClusteredRegistration.this.f_sExecutorId, this.f_sTaskId));
                    NamedCache tasksCache = ClusteredRegistration.this.tasks();
                    if (this.isResuming() && (!this.f_fRecovered || this.m_task instanceof CronTask)) {
                        Object oIsCompleted;
                        listExtracted = (List)tasksCache.invoke((Object)this.f_sTaskId, (InvocableMap.EntryProcessor)new ExtractorProcessor((ValueExtractor)new MultiExtractor(new ValueExtractor[]{new ReflectionExtractor("isCompleted")})));
                        Object v0 = oIsCompleted = listExtracted == null || listExtracted.size() < 1 ? null : listExtracted.get(0);
                        if (oIsCompleted == null) {
                            this.m_task = null;
                            fIsCompleted = true;
                        } else {
                            fIsCompleted = (Boolean)listExtracted.get(0);
                        }
                    } else {
                        Object oTask;
                        listExtracted = (List)tasksCache.invoke((Object)this.f_sTaskId, (InvocableMap.EntryProcessor)new ExtractorProcessor((ValueExtractor)new MultiExtractor(new ValueExtractor[]{new ReflectionExtractor("getTask"), new ReflectionExtractor("isCompleted")})));
                        Object v1 = oTask = listExtracted == null || listExtracted.size() < 2 ? null : listExtracted.get(0);
                        if (oTask == null) {
                            this.m_task = null;
                            fIsCompleted = true;
                        } else {
                            this.m_task = oTask;
                            fIsCompleted = (Boolean)listExtracted.get(1);
                        }
                    }
                    if (this.m_task == null) {
                        ExecutorTrace.log(() -> String.format("Executor [%s] skipping execution of Task [%s] (no longer exists)", ClusteredRegistration.this.f_sExecutorId, this.f_sTaskId));
                        fUpdateExecutionStatus = false;
                        fCleanupLocalExecutionResources = true;
                    } else if (fIsCompleted) {
                        ExecutorTrace.log(() -> String.format("Executor [%s] skipping execution of Task [%s] (it's completed or cancelled)", ClusteredRegistration.this.f_sExecutorId, this.f_sTaskId));
                        fUpdateExecutionStatus = true;
                        fCleanupLocalExecutionResources = true;
                    } else {
                        ClusteredAssignment.State existing = (ClusteredAssignment.State)((Object)ClusteredRegistration.this.m_viewAssignments.invoke((Object)ClusteredAssignment.getCacheKey(ClusteredRegistration.this.f_sExecutorId, this.f_sTaskId), (InvocableMap.EntryProcessor)new ClusteredAssignment.SetStateProcessor(ClusteredAssignment.State.ASSIGNED, ClusteredAssignment.State.EXECUTING)));
                        if (existing == null) {
                            fUpdateExecutionStatus = true;
                            fCleanupLocalExecutionResources = true;
                        } else if (existing.equals((Object)ClusteredAssignment.State.ASSIGNED) || this.isResuming() && existing.equals((Object)ClusteredAssignment.State.EXECUTING)) {
                            ClusteredTaskManager taskManager = (ClusteredTaskManager)ClusteredRegistration.this.tasks().get((Object)this.f_sTaskId);
                            if (taskManager == null) {
                                ExecutorTrace.log(() -> String.format("Executor [%s] skipping execution of Task [%s] (no longer exists)", ClusteredRegistration.this.f_sExecutorId, this.f_sTaskId));
                                fUpdateExecutionStatus = false;
                                fCleanupLocalExecutionResources = true;
                            } else {
                                SpanContext parentSpanContext = taskManager.getParentSpanContext();
                                Span executionSpan = this.createSpan(parentSpanContext);
                                try (Scope ignored = TracingHelper.getTracer().withSpan(executionSpan);){
                                    ExecutorTrace.log(() -> String.format("Executor [%s] Task [%s]", this.isResuming() ? "Resuming" : "Executing", this.f_sTaskId));
                                    executionSpan.log(String.format("%s %s", this.isResuming() ? "Resuming" : "Executing", this.f_sTaskId));
                                    this.m_executionThread = Thread.currentThread();
                                    try {
                                        this.setResult(Result.of(this.m_task.execute(this)), true);
                                    }
                                    finally {
                                        this.m_executionThread = null;
                                    }
                                    executionSpan.log("Execution completed");
                                    fUpdateExecutionStatus = true;
                                    fCleanupLocalExecutionResources = true;
                                }
                                catch (Task.Yield yield) {
                                    ++this.m_cYield;
                                    ExecutorTrace.log(() -> String.format("Executor [%s] scheduling Task [%s] to resume in %s", ClusteredRegistration.this.f_sExecutorId, this.f_sTaskId, yield.getDuration()));
                                    executionSpan.log("Yielding execution for " + String.valueOf(yield.getDuration()));
                                    TaskExecutor taskExecutor = this;
                                    ClusteredRegistration.this.f_clusteredExecutorService.getScheduledExecutorService().schedule(() -> ClusteredRegistration.this.executingTask(taskExecutor, this.f_sTaskId, ClusteredRegistration.this.f_sExecutorId), yield.getDuration().toNanos(), TimeUnit.NANOSECONDS);
                                    fUpdateExecutionStatus = false;
                                    fCleanupLocalExecutionResources = false;
                                }
                                catch (Throwable throwable) {
                                    this.setResult(Result.throwable(throwable));
                                    TracingHelper.augmentSpanWithErrorDetails((Span)executionSpan, (boolean)true, (Throwable)throwable);
                                    fUpdateExecutionStatus = true;
                                    fCleanupLocalExecutionResources = true;
                                }
                                finally {
                                    executionSpan.end();
                                }
                            }
                        } else {
                            fUpdateExecutionStatus = false;
                            fCleanupLocalExecutionResources = true;
                        }
                    }
                    if (fUpdateExecutionStatus) {
                        ExecutorTrace.log(() -> String.format("Executor [%s] updating execution state for Task [%s] (now EXECUTED)", ClusteredRegistration.this.f_sExecutorId, this.f_sTaskId));
                        NamedCache cache = ClusteredRegistration.this.m_viewAssignments;
                        if (cache != null && cache.isActive()) {
                            try {
                                cache.invoke((Object)ClusteredAssignment.getCacheKey(ClusteredRegistration.this.f_sExecutorId, this.f_sTaskId), (InvocableMap.EntryProcessor)new ClusteredAssignment.SetStateProcessor(ClusteredAssignment.State.EXECUTING, ClusteredAssignment.State.EXECUTED));
                            }
                            catch (IllegalStateException | NullPointerException e) {
                                if (ClusteredRegistration.this.f_fCloseCalled.get() || ClusteredRegistration.this.f_fShutdownCalled.get()) break block40;
                                throw e;
                            }
                        }
                    }
                }
                if (fCleanupLocalExecutionResources) {
                    ExecutorTrace.log(() -> String.format("Executor [%s] cleaning up local resources for Task [%s]", ClusteredRegistration.this.f_sExecutorId, this.f_sTaskId));
                    ClusteredRegistration.this.f_mapTaskExecutors.remove(this.f_sTaskId);
                }
            } else {
                ExecutorTrace.log(() -> String.format("Executor [%s] skipping execution of Task [%s] (no longer tracked locally)", ClusteredRegistration.this.f_sExecutorId, this.f_sTaskId));
            }
        }

        private Span createSpan(SpanContext parentSpanContext) {
            Span.Builder builder = TracingHelper.newSpan((String)"Task.Execute").withAssociation(Span.Association.CHILD_OF.key(), parentSpanContext).withMetadata(Span.Type.COMPONENT.key(), "ExecutorService");
            builder.withMetadata("task-id", this.f_sTaskId);
            builder.withMetadata("task-type", this.m_task.toString());
            builder.withMetadata("executor-id", ClusteredRegistration.this.f_sExecutorId);
            builder.withMetadata("executor-name", ClusteredRegistration.this.f_optionsByType.get(Name.class, Name.of("")).getName());
            builder.withMetadata("executor-description", ClusteredRegistration.this.f_optionsByType.get(Description.class, Description.of("")).getName());
            return builder.startSpan();
        }

        public void setResult(Object result) {
            this.setResult(Result.of(result));
        }

        @Override
        public boolean isDone() {
            Boolean fDone = (Boolean)ClusteredRegistration.this.tasks().invoke((Object)this.f_sTaskId, (InvocableMap.EntryProcessor)new ExtractorProcessor("isDone"));
            return fDone == null || fDone != false;
        }

        @Override
        public boolean isCancelled() {
            Boolean fCancelled = (Boolean)ClusteredRegistration.this.tasks().invoke((Object)this.f_sTaskId, (InvocableMap.EntryProcessor)new ExtractorProcessor("isCancelled"));
            return fCancelled == null || fCancelled != false;
        }

        @Override
        public boolean isResuming() {
            return this.m_cYield > 0 || this.f_fRecovered;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Task.Properties getProperties() {
            TaskExecutor taskExecutor = this;
            synchronized (taskExecutor) {
                if (this.m_properties == null) {
                    this.m_properties = (ClusteredProperties)ClusteredRegistration.this.f_clusteredExecutorService.acquire(this.f_sTaskId).getProperties();
                }
            }
            return this.m_properties;
        }

        @Override
        public String getTaskId() {
            return this.f_sTaskId;
        }

        @Override
        public String getExecutorId() {
            return ClusteredRegistration.this.getId();
        }

        protected Thread getExecutionThread() {
            return this.m_executionThread;
        }

        public String toString() {
            return "TaskExecutor{taskId='" + this.f_sTaskId + "', task=" + String.valueOf(this.m_task) + ", yieldCount=" + this.m_cYield + ", recovered=" + this.f_fRecovered + ", current-thread=" + String.valueOf(this.m_executionThread) + "}";
        }
    }

    protected class ExecutorMBeanImpl
    implements ExecutorMBean {
        protected final String f_sMemberId;
        protected final String f_sName;
        protected final String f_sDetails;
        protected final String f_sLocation;
        protected final String f_sExecutorId;
        protected TaskExecutorService.ExecutorInfo.State m_state = TaskExecutorService.ExecutorInfo.State.JOINING;

        public ExecutorMBeanImpl(String sName, int nMemberId, String sLocation, String sExecutorId, String sDetails) {
            this.f_sName = sName;
            this.f_sMemberId = Integer.toString(nMemberId);
            this.f_sDetails = sDetails;
            this.f_sLocation = sLocation;
            this.f_sExecutorId = sExecutorId;
        }

        @Override
        public void resetStatistics() {
            ClusteredRegistration.this.m_cTasksCompletedCount = 0L;
            ClusteredRegistration.this.m_cTasksRejectedCount = 0L;
            ClusteredRegistration.this.m_cTasksInProgressCount = 0L;
        }

        @Override
        public String getMemberId() {
            return this.f_sMemberId;
        }

        @Override
        public String getName() {
            return this.f_sName;
        }

        @Override
        public String getId() {
            return this.f_sExecutorId;
        }

        @Override
        public String getDescription() {
            return this.f_sDetails;
        }

        @Override
        public String getLocation() {
            return this.f_sLocation;
        }

        @Override
        public String getState() {
            return this.m_state.name();
        }

        @Override
        public int getStateCode() {
            return this.m_state.getCode();
        }

        @Override
        public long getTasksCompletedCount() {
            return ClusteredRegistration.this.m_cTasksCompletedCount;
        }

        @Override
        public long getTasksRejectedCount() {
            return ClusteredRegistration.this.m_cTasksRejectedCount;
        }

        @Override
        public long getTasksInProgressCount() {
            return ClusteredRegistration.this.m_cTasksInProgressCount;
        }

        @Override
        public boolean isTraceLogging() {
            return s_fTraceLogging;
        }

        void setState(TaskExecutorService.ExecutorInfo.State state) {
            Objects.requireNonNull(state, "state cannot be null");
            this.m_state = state;
        }

        @Override
        public void setTraceLogging(boolean fTrace) {
            s_fTraceLogging = fTrace;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ExecutorMBeanImpl)) {
                return false;
            }
            ExecutorMBeanImpl that = (ExecutorMBeanImpl)o;
            return this.f_sExecutorId.equals(that.f_sExecutorId);
        }

        public int hashCode() {
            return Objects.hash(this.f_sExecutorId);
        }

        public String toString() {
            return "ExecutorMBeanImpl{member-id=" + this.f_sMemberId + ", name='" + this.f_sName + "', id='" + this.f_sExecutorId + "', details='" + this.f_sDetails + "', location='" + this.f_sLocation + "', state='" + this.m_state.name() + "', tasks-completed='" + ClusteredRegistration.this.m_cTasksCompletedCount + "', tasks-in-progress='" + ClusteredRegistration.this.m_cTasksInProgressCount + "', tasks-rejected='" + ClusteredRegistration.this.m_cTasksRejectedCount + "'}";
        }
    }
}

