/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.concurrent.atomic;

import com.oracle.coherence.concurrent.atomic.AsyncAtomicStampedReference;
import com.tangosol.net.AsyncNamedMap;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.function.Remote;
import java.io.Serializable;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicStampedReference;

public class AsyncRemoteAtomicStampedReference<V>
implements AsyncAtomicStampedReference<V> {
    private final AsyncNamedMap<String, AtomicStampedReference<V>> f_mapAtomic;
    private final String f_sName;

    protected AsyncRemoteAtomicStampedReference(AsyncNamedMap<String, AtomicStampedReference<V>> mapAtomic, String sName) {
        this.f_mapAtomic = mapAtomic;
        this.f_sName = sName;
    }

    @Override
    public CompletableFuture<V> getReference() {
        return this.invoke(AtomicStampedReference::getReference, false);
    }

    @Override
    public CompletableFuture<Integer> getStamp() {
        return this.invoke(AtomicStampedReference::getStamp, false);
    }

    @Override
    public CompletableFuture<V> get(int[] iaStampHolder) {
        return this.invoke((Remote.Function & Serializable)value -> {
            int[] aiStamp = new int[1];
            Object v = value.get(aiStamp);
            return new Object[]{v, aiStamp[0]};
        }, false).thenApply(aResult -> {
            iaStampHolder[0] = (Integer)aResult[1];
            return aResult[0];
        });
    }

    @Override
    public CompletableFuture<Boolean> compareAndSet(V expectedReference, V newReference, int nExpectedStamp, int newStamp) {
        return this.invoke((Remote.Function & Serializable)value -> {
            int[] aiStamp = new int[1];
            Object v = value.get(aiStamp);
            if (Objects.equals(v, expectedReference) && nExpectedStamp == aiStamp[0]) {
                value.set(newReference, newStamp);
                return true;
            }
            return false;
        });
    }

    @Override
    public CompletableFuture<Void> set(V newReference, int nNewStamp) {
        return this.invoke((Remote.Function & Serializable)value -> {
            value.set(newReference, nNewStamp);
            return null;
        });
    }

    @Override
    public CompletableFuture<Boolean> attemptStamp(V expectedReference, int nNewStamp) {
        return this.invoke((Remote.Function & Serializable)value -> {
            Object v = value.getReference();
            if (Objects.equals(v, expectedReference)) {
                value.set(v, nNewStamp);
                return true;
            }
            return false;
        });
    }

    public String toString() {
        int[] aiStamp = new int[1];
        V value = this.get(aiStamp).join();
        return value + " (" + aiStamp[0] + ")";
    }

    protected <R> CompletableFuture<R> invoke(Remote.Function<AtomicStampedReference<V>, R> function) {
        return this.invoke(function, true);
    }

    protected <R> CompletableFuture<R> invoke(Remote.Function<AtomicStampedReference<V>, R> function, boolean fMutate) {
        return this.f_mapAtomic.invoke((Object)this.f_sName, (InvocableMap.EntryProcessor & Serializable)entry -> {
            AtomicStampedReference value = (AtomicStampedReference)entry.getValue();
            Object result = function.apply((Object)value);
            if (fMutate) {
                entry.setValue((Object)value);
            }
            return result;
        });
    }
}

