/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.concurrent.executor.util;

import com.tangosol.net.CacheService;
import com.tangosol.net.ConfigurableCacheFactory;
import com.tangosol.net.NamedCache;
import com.tangosol.net.NamedMap;
import com.tangosol.net.Session;
import java.util.Objects;

public final class Caches {
    public static String TASKS_CACHE_NAME = "executor-tasks";
    public static String ASSIGNMENTS_CACHE_NAME = "executor-assignments";
    public static final String EXECUTORS_CACHE_NAME = "executor-executors";
    public static String PROPERTIES_CACHE_NAME = "executor-properties";

    private Caches() {
    }

    public static NamedCache tasks(CacheService service) {
        return Caches.getCache(service, TASKS_CACHE_NAME);
    }

    public static NamedCache assignments(CacheService service) {
        return Caches.getCache(service, ASSIGNMENTS_CACHE_NAME);
    }

    public static NamedCache executors(CacheService service) {
        return Caches.getCache(service, EXECUTORS_CACHE_NAME);
    }

    public static NamedCache properties(CacheService service) {
        return Caches.getCache(service, PROPERTIES_CACHE_NAME);
    }

    public static NamedCache tasks(Session session) {
        return Caches.getCache(session, TASKS_CACHE_NAME);
    }

    public static NamedCache assignments(Session session) {
        return Caches.getCache(session, ASSIGNMENTS_CACHE_NAME);
    }

    public static NamedCache executors(Session session) {
        return Caches.getCache(session, EXECUTORS_CACHE_NAME);
    }

    public static NamedCache properties(Session session) {
        return Caches.getCache(session, PROPERTIES_CACHE_NAME);
    }

    public static NamedCache tasks(ConfigurableCacheFactory factory) {
        return Caches.getCache(factory, TASKS_CACHE_NAME);
    }

    public static NamedCache assignments(ConfigurableCacheFactory factory) {
        return Caches.getCache(factory, ASSIGNMENTS_CACHE_NAME);
    }

    public static NamedCache executors(ConfigurableCacheFactory factory) {
        return Caches.getCache(factory, EXECUTORS_CACHE_NAME);
    }

    public static NamedCache properties(ConfigurableCacheFactory factory) {
        return Caches.getCache(factory, PROPERTIES_CACHE_NAME);
    }

    private static NamedCache getCache(CacheService service, String sCacheName) {
        Objects.requireNonNull(service);
        return service.ensureCache(sCacheName, null);
    }

    private static NamedCache getCache(Session session, String sCacheName) {
        Objects.requireNonNull(session);
        return session.getCache(sCacheName, new NamedMap.Option[0]);
    }

    private static NamedCache getCache(ConfigurableCacheFactory factory, String sCacheName) {
        Objects.requireNonNull(factory);
        return factory.ensureCache(sCacheName, null);
    }
}

